/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

class SegmentsTermDocs
implements TermDocs {
    protected SegmentReader[] readers;
    protected int[] starts;
    protected Term term;
    protected int base = 0;
    protected int pointer = 0;
    private SegmentTermDocs[] segTermDocs;
    protected SegmentTermDocs current;

    SegmentsTermDocs(SegmentReader[] segmentReaderArray, int[] nArray) {
        this.readers = segmentReaderArray;
        this.starts = nArray;
        this.segTermDocs = new SegmentTermDocs[segmentReaderArray.length];
    }

    public final int doc() {
        return this.base + this.current.doc;
    }

    public final int freq() {
        return this.current.freq;
    }

    public final void seek(Term term) {
        this.term = term;
        this.base = 0;
        this.pointer = 0;
        this.current = null;
    }

    public final boolean next() throws IOException {
        if (this.current != null && this.current.next()) {
            return true;
        }
        if (this.pointer < this.readers.length) {
            this.base = this.starts[this.pointer];
            this.current = this.termDocs(this.pointer++);
            return this.next();
        }
        return false;
    }

    public final int read(int[] nArray, int[] nArray2) throws IOException {
        int n;
        while (true) {
            if (this.current == null) {
                if (this.pointer < this.readers.length) {
                    this.base = this.starts[this.pointer];
                    this.current = this.termDocs(this.pointer++);
                    continue;
                }
                return 0;
            }
            n = this.current.read(nArray, nArray2);
            if (n != 0) break;
            this.current = null;
        }
        int n2 = this.base;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3++;
            nArray[n4] = nArray[n4] + n2;
        }
        return n;
    }

    public boolean skipTo(int n) throws IOException {
        do {
            if (this.next()) continue;
            return false;
        } while (n > this.doc());
        return true;
    }

    private SegmentTermDocs termDocs(int n) throws IOException {
        if (this.term == null) {
            return null;
        }
        SegmentTermDocs segmentTermDocs = this.segTermDocs[n];
        if (segmentTermDocs == null) {
            segmentTermDocs = this.segTermDocs[n] = this.termDocs(this.readers[n]);
        }
        segmentTermDocs.seek(this.term);
        return segmentTermDocs;
    }

    protected SegmentTermDocs termDocs(SegmentReader segmentReader) throws IOException {
        return (SegmentTermDocs)segmentReader.termDocs();
    }

    public final void close() throws IOException {
        int n = 0;
        while (n < this.segTermDocs.length) {
            if (this.segTermDocs[n] != null) {
                this.segTermDocs[n].close();
            }
            ++n;
        }
    }
}

