/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.FastCharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParserConstants;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.queryParser.Token;
import org.apache.lucene.queryParser.TokenMgrError;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class QueryParser
implements QueryParserConstants {
    Analyzer analyzer;
    String field;
    int phraseSlop = 0;
    public static final int DEFAULT_OPERATOR_OR = 0;
    public static final int DEFAULT_OPERATOR_AND = 1;
    private int operator = 0;
    private static final int CONJ_NONE = 0;
    private static final int CONJ_AND = 1;
    private static final int CONJ_OR = 2;
    private static final int MOD_NONE = 0;
    private static final int MOD_NOT = 10;
    private static final int MOD_REQ = 11;
    public QueryParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[21];
    private final int[] jj_la1_0 = new int[]{384, 384, 3584, 3584, 32710528, 32706560, 20054016, 262144, 262144, 32768, 0x18000000, 0x2000000, 0x18000000, 32768, Integer.MIN_VALUE, 0x20000000, Integer.MIN_VALUE, 32768, 524288, 32768, 32702464};
    private final int[] jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0};
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static Query parse(String string, String string2, Analyzer analyzer) throws ParseException {
        try {
            QueryParser queryParser = new QueryParser(string2, analyzer);
            return queryParser.parse(string);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ParseException(tokenMgrError.getMessage());
        }
    }

    public QueryParser(String string, Analyzer analyzer) {
        this(new FastCharStream(new StringReader("")));
        this.analyzer = analyzer;
        this.field = string;
    }

    public Query parse(String string) throws ParseException, TokenMgrError {
        this.ReInit(new FastCharStream(new StringReader(string)));
        return this.Query(this.field);
    }

    public void setPhraseSlop(int n) {
        this.phraseSlop = n;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public void setOperator(int n) {
        this.operator = n;
    }

    public int getOperator() {
        return this.operator;
    }

    private void addClause(Vector vector, int n, int n2, Query query) {
        boolean bl;
        boolean bl2;
        BooleanClause booleanClause;
        if (n == 1) {
            booleanClause = (BooleanClause)vector.elementAt(vector.size() - 1);
            if (!booleanClause.prohibited) {
                booleanClause.required = true;
            }
        }
        if (this.operator == 1 && n == 2) {
            booleanClause = (BooleanClause)vector.elementAt(vector.size() - 1);
            if (!booleanClause.prohibited) {
                booleanClause.required = false;
            }
        }
        if (query == null) {
            return;
        }
        if (this.operator == 0) {
            bl2 = n2 == 10;
            boolean bl3 = bl = n2 == 11;
            if (n == 1 && !bl2) {
                bl = true;
            }
        } else {
            bl2 = n2 == 10;
            bl = !bl2 && n != 2;
        }
        vector.addElement(new BooleanClause(query, bl, bl2));
    }

    private Query getFieldQuery(String string, Analyzer analyzer, String string2) {
        TokenStream tokenStream = analyzer.tokenStream(string, new StringReader(string2));
        Vector<String> vector = new Vector<String>();
        while (true) {
            org.apache.lucene.analysis.Token token;
            try {
                token = tokenStream.next();
            }
            catch (IOException iOException) {
                token = null;
            }
            if (token == null) break;
            vector.addElement(token.termText());
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return new TermQuery(new Term(string, (String)vector.elementAt(0)));
        }
        PhraseQuery phraseQuery = new PhraseQuery();
        phraseQuery.setSlop(this.phraseSlop);
        int n = 0;
        while (n < vector.size()) {
            phraseQuery.add(new Term(string, (String)vector.elementAt(n)));
            ++n;
        }
        return phraseQuery;
    }

    private Query getRangeQuery(String string, Analyzer analyzer, String string2, String string3, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            DateFormat dateFormat = DateFormat.getDateInstance(3);
            dateFormat.setLenient(true);
            Date date = dateFormat.parse(string2);
            Date date2 = dateFormat.parse(string3);
            string2 = DateField.dateToString(date);
            string3 = DateField.dateToString(date2);
            bl2 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl2) {
            // empty if block
        }
        return new RangeQuery(new Term(string, string2), new Term(string, string3), bl);
    }

    public static void main(String[] stringArray) throws Exception {
        QueryParser queryParser = new QueryParser("field", new SimpleAnalyzer());
        Query query = queryParser.parse(stringArray[0]);
        System.out.println(query.toString("field"));
    }

    public final int Conjunction() throws ParseException {
        int n = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        n = 1;
                        break block0;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        n = 2;
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return n;
    }

    public final int Modifiers() throws ParseException {
        int n = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        n = 11;
                        break block0;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        n = 10;
                        break block0;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        n = 10;
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return n;
    }

    public final Query Query(String string) throws ParseException {
        Vector vector = new Vector();
        Query query = null;
        int n = this.Modifiers();
        Query query2 = this.Clause(string);
        this.addClause(vector, 0, n, query2);
        if (n == 0) {
            query = query2;
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            int n2 = this.Conjunction();
            n = this.Modifiers();
            query2 = this.Clause(string);
            this.addClause(vector, n2, n, query2);
        }
        if (vector.size() == 1 && query != null) {
            return query;
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        int n3 = 0;
        while (n3 < vector.size()) {
            booleanQuery.add((BooleanClause)vector.elementAt(n3));
            ++n3;
        }
        return booleanQuery;
    }

    public final Query Clause(String string) throws ParseException {
        Query query;
        Token token = null;
        if (this.jj_2_1(2)) {
            token = this.jj_consume_token(17);
            this.jj_consume_token(14);
            string = token.image;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                query = this.Term(string);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                query = this.Query(string);
                this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return query;
    }

    public final Query Term(String string) throws ParseException {
        Query query;
        Token token = null;
        Token token2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 20: 
            case 21: 
            case 24: {
                Token token3;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        token3 = this.jj_consume_token(17);
                        break;
                    }
                    case 20: {
                        token3 = this.jj_consume_token(20);
                        bl = true;
                        break;
                    }
                    case 21: {
                        token3 = this.jj_consume_token(21);
                        bl2 = true;
                        break;
                    }
                    case 24: {
                        token3 = this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        bl3 = true;
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                block17 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        token = this.jj_consume_token(24);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 18: {
                                this.jj_consume_token(18);
                                bl3 = true;
                                break block17;
                            }
                        }
                        this.jj_la1[8] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                if (bl2) {
                    query = new WildcardQuery(new Term(string, token3.image));
                    break;
                }
                if (bl) {
                    query = new PrefixQuery(new Term(string, token3.image.substring(0, token3.image.length() - 1)));
                    break;
                }
                if (bl3) {
                    query = new FuzzyQuery(new Term(string, token3.image));
                    break;
                }
                query = this.getFieldQuery(string, this.analyzer, token3.image);
                break;
            }
            case 22: {
                Token token4;
                Token token5;
                this.jj_consume_token(22);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        token5 = this.jj_consume_token(28);
                        break;
                    }
                    case 27: {
                        token5 = this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        token4 = this.jj_consume_token(28);
                        break;
                    }
                    case 27: {
                        token4 = this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(26);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        token = this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                if (token5.kind == 27) {
                    token5.image = token5.image.substring(1, token5.image.length() - 1);
                }
                if (token4.kind == 27) {
                    token4.image = token4.image.substring(1, token4.image.length() - 1);
                }
                query = this.getRangeQuery(string, this.analyzer, token5.image, token4.image, true);
                break;
            }
            case 23: {
                Token token6;
                Token token7;
                this.jj_consume_token(23);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        token7 = this.jj_consume_token(32);
                        break;
                    }
                    case 31: {
                        token7 = this.jj_consume_token(31);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        token6 = this.jj_consume_token(32);
                        break;
                    }
                    case 31: {
                        token6 = this.jj_consume_token(31);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(30);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        token = this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                if (token7.kind == 31) {
                    token7.image = token7.image.substring(1, token7.image.length() - 1);
                }
                if (token6.kind == 31) {
                    token6.image = token6.image.substring(1, token6.image.length() - 1);
                }
                query = this.getRangeQuery(string, this.analyzer, token7.image, token6.image, false);
                break;
            }
            case 16: {
                Token token8 = this.jj_consume_token(16);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        token2 = this.jj_consume_token(19);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        token = this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                    }
                }
                query = this.getFieldQuery(string, this.analyzer, token8.image.substring(1, token8.image.length() - 1));
                if (token2 == null || !(query instanceof PhraseQuery)) break;
                try {
                    int n = Float.valueOf(token2.image.substring(1)).intValue();
                    ((PhraseQuery)query).setSlop(n);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (token != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(token.image).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            query.setBoost(f);
        }
        return query;
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public QueryParser(CharStream charStream) {
        this.token_source = new QueryParserTokenManager(charStream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 21) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(CharStream charStream) {
        this.token_source.ReInit(charStream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 21) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public QueryParser(QueryParserTokenManager queryParserTokenManager) {
        this.token_source = queryParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 21) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(QueryParserTokenManager queryParserTokenManager) {
        this.token_source = queryParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 21) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int n2 = 0;
                while (n2 < this.jj_2_rtns.length) {
                    JJCalls jJCalls = this.jj_2_rtns[n2];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                    ++n2;
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int n3 = 0;
            while (n3 < this.jj_endpos) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
                ++n3;
            }
            boolean bl = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                bl = true;
                int n4 = 0;
                while (n4 < this.jj_expentry.length) {
                    if (nArray[n4] != this.jj_expentry[n4]) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) break;
            }
            if (!bl) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[33];
        int n2 = 0;
        while (n2 < 33) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 21) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    if ((this.jj_la1_1[n3] & 1 << n) != 0) {
                        blArray[32 + n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 33) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, QueryParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int n = 0;
        while (n < 1) {
            JJCalls jJCalls = this.jj_2_rtns[n];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (n) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
            ++n;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

