/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultipleTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;

public class PhrasePrefixQuery
extends Query {
    private String _field;
    private ArrayList _termArrays = new ArrayList();
    private float _idf = 0.0f;
    private float _weight = 0.0f;
    private int _slop = 0;

    public void setSlop(int n) {
        this._slop = n;
    }

    public int getSlop() {
        return this._slop;
    }

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void add(Term[] termArray) {
        if (this._termArrays.size() == 0) {
            this._field = termArray[0].field();
        }
        int n = 0;
        while (n < termArray.length) {
            if (termArray[n].field() != this._field) {
                throw new IllegalArgumentException("All phrase terms must be in the same field (" + this._field + "): " + termArray[n]);
            }
            ++n;
        }
        this._termArrays.add(termArray);
    }

    Scorer scorer(IndexReader indexReader) throws IOException {
        if (this._termArrays.size() == 0) {
            return null;
        }
        if (this._termArrays.size() == 1) {
            Term[] termArray = (Term[])this._termArrays.get(0);
            BooleanQuery booleanQuery = new BooleanQuery();
            int n = 0;
            while (n < termArray.length) {
                booleanQuery.add(new TermQuery(termArray[n]), false, false);
                ++n;
            }
            return booleanQuery.scorer(indexReader);
        }
        TermPositions[] termPositionsArray = new TermPositions[this._termArrays.size()];
        int n = 0;
        while (n < termPositionsArray.length) {
            Term[] termArray = (Term[])this._termArrays.get(n);
            TermPositions termPositions = termArray.length > 1 ? new MultipleTermPositions(indexReader, termArray) : indexReader.termPositions(termArray[0]);
            if (termPositions == null) {
                return null;
            }
            termPositionsArray[n] = termPositions;
            ++n;
        }
        if (this._slop == 0) {
            return new ExactPhraseScorer(termPositionsArray, indexReader.norms(this._field), this._weight);
        }
        return new SloppyPhraseScorer(termPositionsArray, this._slop, indexReader.norms(this._field), this._weight);
    }

    float sumOfSquaredWeights(Searcher searcher) throws IOException {
        Iterator iterator = ((AbstractList)this._termArrays).iterator();
        while (iterator.hasNext()) {
            Term[] termArray = (Term[])iterator.next();
            int n = 0;
            while (n < termArray.length) {
                this._idf += Similarity.idf(termArray[n], searcher);
                ++n;
            }
        }
        this._weight = this._idf * this.boost;
        return this._weight * this._weight;
    }

    void normalize(float f) {
        this._weight *= f;
        this._weight *= this._idf;
    }

    public final String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this._field.equals(string)) {
            stringBuffer.append(this._field);
            stringBuffer.append(":");
        }
        stringBuffer.append("\"");
        Iterator iterator = ((AbstractList)this._termArrays).iterator();
        while (iterator.hasNext()) {
            Term[] termArray = (Term[])iterator.next();
            stringBuffer.append(termArray[0].text() + (termArray.length > 0 ? "*" : ""));
        }
        stringBuffer.append("\"");
        if (this._slop != 0) {
            stringBuffer.append("~");
            stringBuffer.append(this._slop);
        }
        if (this.boost != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.boost));
        }
        return stringBuffer.toString();
    }
}

