/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermScorer;

public class PhraseQuery
extends Query {
    private String field;
    private Vector terms = new Vector();
    private float idf = 0.0f;
    private float weight = 0.0f;
    private int slop = 0;

    public void setSlop(int n) {
        this.slop = n;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        if (this.terms.size() == 0) {
            this.field = term.field();
        } else if (term.field() != this.field) {
            throw new IllegalArgumentException("All phrase terms must be in the same field: " + term);
        }
        this.terms.addElement(term);
    }

    final float sumOfSquaredWeights(Searcher searcher) throws IOException {
        this.idf = 0.0f;
        int n = 0;
        while (n < this.terms.size()) {
            this.idf += Similarity.idf((Term)this.terms.elementAt(n), searcher);
            ++n;
        }
        this.weight = this.idf * this.boost;
        return this.weight * this.weight;
    }

    final void normalize(float f) {
        this.weight *= f;
        this.weight *= this.idf;
    }

    final Scorer scorer(IndexReader indexReader) throws IOException {
        if (this.terms.size() == 0) {
            return null;
        }
        if (this.terms.size() == 1) {
            Term term = (Term)this.terms.elementAt(0);
            TermDocs termDocs = indexReader.termDocs(term);
            if (termDocs == null) {
                return null;
            }
            return new TermScorer(termDocs, indexReader.norms(term.field()), this.weight);
        }
        TermPositions[] termPositionsArray = new TermPositions[this.terms.size()];
        int n = 0;
        while (n < this.terms.size()) {
            TermPositions termPositions = indexReader.termPositions((Term)this.terms.elementAt(n));
            if (termPositions == null) {
                return null;
            }
            termPositionsArray[n] = termPositions;
            ++n;
        }
        if (this.slop == 0) {
            return new ExactPhraseScorer(termPositionsArray, indexReader.norms(this.field), this.weight);
        }
        return new SloppyPhraseScorer(termPositionsArray, this.slop, indexReader.norms(this.field), this.weight);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.field.equals(string)) {
            stringBuffer.append(this.field);
            stringBuffer.append(":");
        }
        stringBuffer.append("\"");
        int n = 0;
        while (n < this.terms.size()) {
            stringBuffer.append(((Term)this.terms.elementAt(n)).text());
            if (n != this.terms.size() - 1) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        stringBuffer.append("\"");
        if (this.slop != 0) {
            stringBuffer.append("~");
            stringBuffer.append(this.slop);
        }
        if (this.boost != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.boost));
        }
        return stringBuffer.toString();
    }
}

