/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class QueryFilter
extends Filter {
    private Query query;
    private transient WeakHashMap cache = new WeakHashMap();

    public QueryFilter(Query query) {
        this.query = query;
    }

    public BitSet bits(IndexReader indexReader) throws IOException {
        BitSet bitSet;
        WeakHashMap weakHashMap = this.cache;
        synchronized (weakHashMap) {
            bitSet = (BitSet)this.cache.get(indexReader);
            if (bitSet != null) {
                BitSet bitSet2 = bitSet;
                return bitSet2;
            }
        }
        bitSet = new BitSet(indexReader.maxDoc());
        new IndexSearcher(indexReader).search(this.query, new HitCollector(){

            public final void collect(int n, float f) {
                bitSet.set(n);
            }
        });
        WeakHashMap weakHashMap2 = this.cache;
        synchronized (weakHashMap2) {
            this.cache.put(indexReader, bitSet);
        }
        return bitSet;
    }
}

