/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;

public class RangeQuery
extends Query {
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;
    private IndexReader reader;
    private BooleanQuery query;

    public RangeQuery(Term term, Term term2, boolean bl) {
        if (term == null && term2 == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (term != null && term2 != null && term.field() != term2.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = term;
        this.upperTerm = term2;
        this.inclusive = bl;
    }

    final void prepare(IndexReader indexReader) {
        this.query = null;
        this.reader = indexReader;
    }

    final float sumOfSquaredWeights(Searcher searcher) throws IOException {
        return this.getQuery().sumOfSquaredWeights(searcher);
    }

    void normalize(float f) {
        try {
            this.getQuery().normalize(f);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    Scorer scorer(IndexReader indexReader) throws IOException {
        return this.getQuery().scorer(indexReader);
    }

    private BooleanQuery getQuery() throws IOException {
        if (this.query == null) {
            BooleanQuery booleanQuery = new BooleanQuery();
            if (this.lowerTerm == null) {
                this.lowerTerm = new Term(this.getField(), "");
            }
            TermEnum termEnum = this.reader.terms(this.lowerTerm);
            try {
                Term term;
                Object object;
                String string = null;
                boolean bl = false;
                if (!this.inclusive) {
                    if (this.lowerTerm != null) {
                        string = this.lowerTerm.text();
                        bl = true;
                    }
                    if (this.upperTerm != null) {
                        object = this.reader.terms(this.upperTerm);
                        this.upperTerm = ((TermEnum)object).term();
                    }
                }
                object = this.getField();
                while ((term = termEnum.term()) != null && term.field() == object) {
                    if (!bl || term.text().compareTo(string) > 0) {
                        int n;
                        bl = false;
                        if (this.upperTerm != null && ((n = this.upperTerm.compareTo(term)) < 0 || !this.inclusive && n == 0)) break;
                        TermQuery termQuery = new TermQuery(term);
                        termQuery.setBoost(this.boost);
                        booleanQuery.add(termQuery, false, false);
                    }
                    if (termEnum.next()) continue;
                    break;
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                termEnum.close();
                throw throwable;
            }
            termEnum.close();
            this.query = booleanQuery;
        }
        return this.query;
    }

    private String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.getField().equals(string)) {
            stringBuffer.append(this.getField());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.inclusive ? "[" : "{");
        stringBuffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        stringBuffer.append("-");
        stringBuffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        stringBuffer.append(this.inclusive ? "]" : "}");
        if (this.boost != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.boost));
        }
        return stringBuffer.toString();
    }
}

