/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonMismatchException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RemoteSearchable;
import org.apache.lucene.search.TopDocs;

public final class RemoteSearchable_Skel
implements Skeleton {
    private static final Operation[] operations = new Operation[]{new Operation("void close()"), new Operation("org.apache.lucene.document.Document doc(int)"), new Operation("int docFreq(org.apache.lucene.index.Term)"), new Operation("int maxDoc()"), new Operation("org.apache.lucene.search.TopDocs search(org.apache.lucene.search.Query, org.apache.lucene.search.Filter, int)"), new Operation("void search(org.apache.lucene.search.Query, org.apache.lucene.search.Filter, org.apache.lucene.search.HitCollector)")};
    private static final long interfaceHash = -643817005483193757L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(Remote remote, RemoteCall remoteCall, int n, long l) throws Exception {
        if (n < 0) {
            if (l == -4742752445160157748L) {
                n = 0;
            } else if (l == -3205250690722925732L) {
                n = 1;
            } else if (l == -7822449680410044026L) {
                n = 2;
            } else if (l == -2054052621300804366L) {
                n = 3;
            } else if (l == -2779958099349270815L) {
                n = 4;
            } else {
                if (l != 8210132726663281038L) throw new UnmarshalException("invalid method hash");
                n = 5;
            }
        } else if (l != -643817005483193757L) {
            throw new SkeletonMismatchException("interface hash mismatch");
        }
        RemoteSearchable remoteSearchable = (RemoteSearchable)remote;
        switch (n) {
            case 0: {
                remoteCall.releaseInputStream();
                remoteSearchable.close();
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 1: {
                ObjectOutput objectOutput;
                int n2;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        n2 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var9_22 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                Document document = remoteSearchable.doc(n2);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeObject(document);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 2: {
                ObjectOutput objectOutput;
                Term term;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        term = (Term)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var9_25 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                int n3 = remoteSearchable.docFreq(term);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n3);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 3: {
                remoteCall.releaseInputStream();
                int n4 = remoteSearchable.maxDoc();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n4);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 4: {
                ObjectOutput objectOutput;
                int n5;
                Filter filter;
                Query query;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        query = (Query)objectInput.readObject();
                        filter = (Filter)objectInput.readObject();
                        n5 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var11_44 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                TopDocs topDocs = remoteSearchable.search(query, filter, n5);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeObject(topDocs);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 5: {
                HitCollector hitCollector;
                Filter filter;
                Query query;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        query = (Query)objectInput.readObject();
                        filter = (Filter)objectInput.readObject();
                        hitCollector = (HitCollector)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    Object var11_46 = null;
                }
                catch (Throwable throwable) {
                    Object var11_47 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                remoteSearchable.search(query, filter, hitCollector);
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            default: {
                throw new UnmarshalException("invalid method number");
            }
        }
    }

    public Operation[] getOperations() {
        return (Operation[])operations.clone();
    }
}

