/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.TopDocs;

public abstract class Searcher
implements Searchable {
    public final Hits search(Query query) throws IOException {
        return this.search(query, (Filter)null);
    }

    public Hits search(Query query, Filter filter) throws IOException {
        return new Hits(this, query, filter);
    }

    public void search(Query query, HitCollector hitCollector) throws IOException {
        this.search(query, (Filter)null, hitCollector);
    }

    public abstract Document doc(int var1) throws IOException;

    public abstract TopDocs search(Query var1, Filter var2, int var3) throws IOException;

    public abstract int maxDoc() throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public abstract void close() throws IOException;

    public abstract void search(Query var1, Filter var2, HitCollector var3) throws IOException;
}

