/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;

public final class RAMDirectory
extends Directory {
    Hashtable files = new Hashtable();

    public final String[] list() {
        String[] stringArray = new String[this.files.size()];
        int n = 0;
        Enumeration enumeration = this.files.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public final boolean fileExists(String string) {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        return rAMFile != null;
    }

    public final long fileModified(String string) throws IOException {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        return rAMFile.lastModified;
    }

    public void touchFile(String string) throws IOException, SecurityException {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        rAMFile.lastModified = System.currentTimeMillis();
    }

    public final long fileLength(String string) {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        return rAMFile.length;
    }

    public final void deleteFile(String string) {
        this.files.remove(string);
    }

    public final void renameFile(String string, String string2) {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        this.files.remove(string);
        this.files.put(string2, rAMFile);
    }

    public final OutputStream createFile(String string) {
        RAMFile rAMFile = new RAMFile();
        this.files.put(string, rAMFile);
        return new RAMOutputStream(rAMFile);
    }

    public final InputStream openFile(String string) {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        return new RAMInputStream(rAMFile);
    }

    public final Lock makeLock(final String string) {
        return new Lock(){

            public boolean obtain() throws IOException {
                Hashtable hashtable = RAMDirectory.this.files;
                synchronized (hashtable) {
                    if (!RAMDirectory.this.fileExists(string)) {
                        RAMDirectory.this.createFile(string).close();
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }

            public void release() {
                RAMDirectory.this.deleteFile(string);
            }
        };
    }

    public final void close() {
    }
}

