/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ImplicitJobs {
    private final Map threadJobs = new HashMap(20);
    private ThreadJob jobCache = null;
    protected JobManager manager;

    ImplicitJobs(JobManager manager) {
        this.manager = manager;
    }

    void begin(ISchedulingRule rule) {
        ThreadJob threadJob;
        boolean join = false;
        ImplicitJobs implicitJobs = this;
        synchronized (implicitJobs) {
            Thread currentThread = Thread.currentThread();
            threadJob = (ThreadJob)this.threadJobs.get(currentThread);
            if (threadJob == null) {
                Job realJob = Platform.getJobManager().currentJob();
                if (realJob != null && realJob.getRule() != null) {
                    threadJob = this.newThreadJob(realJob.getRule());
                } else {
                    threadJob = this.newThreadJob(rule);
                    join = true;
                    if (rule != null) {
                        this.manager.getLockManager().addLockThread(currentThread);
                    }
                }
                this.threadJobs.put(currentThread, threadJob);
            }
            threadJob.push(rule);
        }
        if (join) {
            threadJob.joinRun();
        }
    }

    synchronized void end() {
        Thread currentThread = Thread.currentThread();
        ThreadJob threadJob = (ThreadJob)this.threadJobs.get(currentThread);
        Assert.isNotNull(threadJob, "IJobManager.endRule without matching IJobManager.beginRule");
        if (threadJob.pop()) {
            this.threadJobs.remove(currentThread);
            if (threadJob.running) {
                threadJob.done(Status.OK_STATUS);
                if (threadJob.getRule() != null) {
                    this.manager.getLockManager().removeLockThread(Thread.currentThread());
                }
            }
            this.recycle(threadJob);
        }
    }

    private ThreadJob newThreadJob(ISchedulingRule rule) {
        return new ThreadJob(rule);
    }

    private void recycle(ThreadJob job) {
        if (this.jobCache == null) {
            job.setRule(null);
            this.jobCache = job;
        }
    }

    class ThreadJob
    extends Job {
        private ISchedulingRule[] ruleStack;
        protected boolean running = false;
        private int top;

        ThreadJob(ISchedulingRule rule) {
            super("Implicit job");
            this.setSystem(true);
            this.setPriority(10);
            this.setRule(rule);
            this.ruleStack = new ISchedulingRule[2];
            this.top = -1;
        }

        synchronized void joinRun() {
            Thread blocker;
            this.running = false;
            InternalJob blockingJob = ImplicitJobs.this.manager.findBlockingJob(this);
            Thread thread = blocker = blockingJob == null ? null : blockingJob.getThread();
            if (!ImplicitJobs.this.manager.getLockManager().aboutToWait(blocker)) {
                this.schedule();
                while (!this.running) {
                    blocker = ImplicitJobs.this.manager.getBlockingThread(this);
                    if (ImplicitJobs.this.manager.getLockManager().aboutToWait(blocker)) continue;
                    try {
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ImplicitJobs.this.manager.getLockManager().aboutToRelease();
            this.running = true;
            this.setThread(Thread.currentThread());
        }

        boolean pop() {
            if (this.top < 0) {
                throw new IllegalArgumentException("IJobManager.endRule without matching IJobManager.beginRule");
            }
            this.ruleStack[this.top--] = null;
            return this.top < 0;
        }

        void push(ISchedulingRule rule) {
            if (++this.top >= this.ruleStack.length) {
                ISchedulingRule[] newStack = new ISchedulingRule[this.ruleStack.length * 2];
                System.arraycopy(this.ruleStack, 0, newStack, 0, this.ruleStack.length);
                this.ruleStack = newStack;
            }
            this.ruleStack[this.top] = rule;
        }

        public IStatus run(IProgressMonitor monitor) {
            ThreadJob threadJob = this;
            synchronized (threadJob) {
                this.running = true;
                this.notifyAll();
            }
            return Job.ASYNC_FINISH;
        }
    }
}

