/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.internal.plugins.Extension;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;

public class ExtensionPoint
extends ExtensionPointModel
implements IExtensionPoint {
    public IConfigurationElement[] getConfigurationElements() {
        ExtensionModel[] list = this.getDeclaredExtensions();
        if (list == null) {
            return new IConfigurationElement[0];
        }
        ArrayList<ConfigurationElementModel> result = new ArrayList<ConfigurationElementModel>();
        int i = 0;
        while (i < list.length) {
            ConfigurationElementModel[] configs = list[i].getSubElements();
            if (configs != null) {
                int j = 0;
                while (j < configs.length) {
                    result.add(configs[j]);
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        return (IPluginDescriptor)((Object)this.getParentPluginDescriptor());
    }

    public IExtension getExtension(String id) {
        if (id == null) {
            return null;
        }
        ExtensionModel[] list = this.getDeclaredExtensions();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (id.equals(((Extension)list[i]).getUniqueIdentifier())) {
                return (IExtension)((Object)list[i]);
            }
            ++i;
        }
        return null;
    }

    public IExtension[] getExtensions() {
        ExtensionModel[] list = this.getDeclaredExtensions();
        if (list == null) {
            return new IExtension[0];
        }
        IExtension[] newValues = new IExtension[list.length];
        System.arraycopy(list, 0, newValues, 0, list.length);
        return newValues;
    }

    public String getLabel() {
        String s = this.getName();
        if (s == null) {
            return "";
        }
        String localized = ((PluginDescriptor)this.getDeclaringPluginDescriptor()).getResourceString(s);
        if (localized != s) {
            this.setLocalizedName(localized);
        }
        return localized;
    }

    public String getSchemaReference() {
        String s = this.getSchema();
        return s == null ? "" : s.replace(File.separatorChar, '/');
    }

    public String getSimpleIdentifier() {
        return this.getId();
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this.getParentPluginDescriptor().getId()) + "." + this.getSimpleIdentifier();
    }

    public String toString() {
        return String.valueOf(this.getParent().getPluginId()) + "." + this.getSimpleIdentifier();
    }
}

