/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.internal.boot.ClassStats;
import org.eclipse.core.internal.boot.ClassloaderStats;
import org.eclipse.core.internal.boot.DelegatingURLClassLoader;

public class PluginStats {
    public String pluginId;
    public int activationOrder;
    private long timestamp;
    private boolean duringStartup;
    private long startupTime;
    private long startupMethodTime;
    private long traceStart = -1L;
    private long traceEnd = -1L;
    private ArrayList pluginsActivated = new ArrayList(3);
    private PluginStats activatedBy = null;
    private static Map plugins = new HashMap(20);
    private static Stack activationStack = new Stack();
    private static boolean booting = true;

    static {
        PluginStats.activateBootPlugin();
    }

    private static void activateBootPlugin() {
        PluginStats plugin = PluginStats.findPlugin("org.eclipse.core.boot");
        plugin.setTimestamp(System.currentTimeMillis());
        plugin.setActivationOrder(plugins.size());
    }

    public static void startActivation(String pluginId) {
        PluginStats plugin = PluginStats.findPlugin(pluginId);
        plugin.setTimestamp(System.currentTimeMillis());
        plugin.setActivationOrder(plugins.size());
        if (activationStack.size() != 0) {
            PluginStats activatedBy = (PluginStats)activationStack.peek();
            activatedBy.activated(plugin);
            plugin.setActivatedBy(activatedBy);
        }
        activationStack.push(plugin);
        if (DelegatingURLClassLoader.TRACE_PLUGINS) {
            PluginStats.traceActivate(pluginId, plugin);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void traceActivate(String id, PluginStats plugin) {
        try {
            PrintWriter output = new PrintWriter(new FileOutputStream(ClassloaderStats.traceFile.getAbsolutePath(), true));
            try {
                long startPosition = ClassloaderStats.traceFile.length();
                output.println("Activating plugin: " + id);
                output.println("Plugin activation stack:");
                int i = activationStack.size() - 1;
                while (true) {
                    if (i < 0) break;
                    output.println("\t" + ((PluginStats)activationStack.get(i)).getPluginId());
                    --i;
                }
                output.println("Class loading stack:");
                Stack classStack = ClassloaderStats.getClassStack();
                int i2 = classStack.size() - 1;
                while (true) {
                    block7: {
                        if (i2 >= 0) break block7;
                        output.println("Stack trace:");
                        new Throwable().printStackTrace(output);
                        plugin.setTraceStart(startPosition);
                        break;
                    }
                    output.println("\t" + ((ClassStats)classStack.get(i2)).getClassName());
                    --i2;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                output.close();
                plugin.setTraceEnd(ClassloaderStats.traceFile.length());
                throw throwable;
            }
            {
                Object var7_10 = null;
                output.close();
                plugin.setTraceEnd(ClassloaderStats.traceFile.length());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void endActivation(String pluginId) {
        if (!DelegatingURLClassLoader.MONITOR_PLUGINS) {
            return;
        }
        PluginStats plugin = (PluginStats)activationStack.pop();
        plugin.endActivation();
    }

    private static PluginStats findPlugin(String id) {
        PluginStats result = (PluginStats)plugins.get(id);
        if (result == null) {
            result = new PluginStats(id);
            plugins.put(id, result);
        }
        return result;
    }

    public static PluginStats[] getPlugins() {
        return plugins.values().toArray(new PluginStats[plugins.size()]);
    }

    public static PluginStats getPlugin(String id) {
        return (PluginStats)plugins.get(id);
    }

    private PluginStats(String pluginId) {
        this.pluginId = pluginId;
        this.duringStartup = booting;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getActivationOrder() {
        return this.activationOrder;
    }

    private void activated(PluginStats plugin) {
        this.pluginsActivated.add(plugin);
    }

    public PluginStats getActivatedBy() {
        return this.activatedBy;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public long getStartupMethodTime() {
        return this.startupMethodTime;
    }

    public boolean isStartupPlugin() {
        return this.duringStartup;
    }

    public int getClassLoadCount() {
        if (!DelegatingURLClassLoader.MONITOR_CLASSES) {
            return 0;
        }
        ClassloaderStats loader = ClassloaderStats.getLoader((String)this.pluginId);
        return loader == null ? 0 : loader.getClassLoadCount();
    }

    public long getClassLoadTime() {
        if (!DelegatingURLClassLoader.MONITOR_CLASSES) {
            return 0L;
        }
        ClassloaderStats loader = ClassloaderStats.getLoader((String)this.pluginId);
        return loader == null ? 0L : loader.getClassLoadTime();
    }

    public ArrayList getPluginsActivated() {
        return this.pluginsActivated;
    }

    public long getTraceStart() {
        return this.traceStart;
    }

    public long getTraceEnd() {
        return this.traceEnd;
    }

    private void setTimestamp(long value) {
        this.timestamp = value;
    }

    private void setActivationOrder(int value) {
        this.activationOrder = value;
    }

    private void setTraceStart(long time) {
        this.traceStart = time;
    }

    public static void setBooting(boolean boot) {
        booting = boot;
    }

    private void endActivation() {
        this.startupTime = System.currentTimeMillis() - this.timestamp;
    }

    private void setTraceEnd(long position) {
        this.traceEnd = position;
    }

    private void setActivatedBy(PluginStats value) {
        this.activatedBy = value;
    }
}

