/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.SafeFileInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public abstract class Plugin {
    private boolean debug = false;
    private IPluginDescriptor descriptor;
    public static final String PREFERENCES_DEFAULT_OVERRIDE_BASE_NAME = "preferences";
    public static final String PREFERENCES_DEFAULT_OVERRIDE_FILE_NAME = "preferences.ini";
    private Preferences preferences = null;
    static /* synthetic */ Class class$0;

    public Plugin(IPluginDescriptor descriptor) {
        Assert.isNotNull(descriptor);
        Assert.isTrue(!descriptor.isPluginActivated(), Policy.bind("plugin.deactivatedLoad", this.getClass().getName(), String.valueOf(descriptor.getUniqueIdentifier()) + " is not activated"));
        String className = ((PluginDescriptor)descriptor).getPluginClass();
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Lorg.eclipse.core.internal.plugins.DefaultPlugin;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            Assert.isTrue(className == null || className.equals(""), Policy.bind("plugin.mismatchRuntime", descriptor.getUniqueIdentifier()));
        } else {
            Assert.isTrue(this.getClass().getName().equals(className), Policy.bind("plugin.mismatchRuntime", descriptor.getUniqueIdentifier()));
        }
        this.descriptor = descriptor;
        String key = String.valueOf(descriptor.getUniqueIdentifier()) + "/debug";
        String value = Platform.getDebugOption(key);
        this.debug = value == null ? false : value.equalsIgnoreCase("true");
    }

    public final URL find(IPath path) {
        return this.getDescriptor().find(path);
    }

    public final URL find(IPath path, Map override) {
        return this.getDescriptor().find(path, override);
    }

    private String getFileFromURL(URL target) {
        String protocol = target.getProtocol();
        if (protocol.equals("file")) {
            return target.getFile();
        }
        if (protocol.equals("jar")) {
            String file = target.getFile();
            file = file.substring(0, file.length() - "!/".length());
            try {
                return this.getFileFromURL(new URL(file));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public final IPluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final ILog getLog() {
        return InternalPlatform.getLog(this);
    }

    public final IPath getStateLocation() {
        return InternalPlatform.getPluginStateLocation(this.descriptor, true);
    }

    public final Preferences getPluginPreferences() {
        if (this.preferences != null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Plugin preferences already loaded for " + this.getDescriptor().getUniqueIdentifier());
            }
            return this.preferences;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Loading preferences for plugin " + this.getDescriptor().getUniqueIdentifier());
        }
        this.preferences = new Preferences();
        this.loadPluginPreferences();
        this.initializeDefaultPluginPreferences();
        this.applyInternalPluginDefaultOverrides();
        this.applyExternalPluginDefaultOverrides();
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Completed loading preferences for plugin " + this.getDescriptor().getUniqueIdentifier());
        }
        return this.preferences;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPluginPreferences() {
        block14: {
            prefFile = InternalPlatform.getMetaArea().getPluginPreferenceLocation(this.descriptor, false).toFile();
            if (!prefFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                System.out.println("Plugin preference file " + prefFile + " not found.");
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from " + prefFile);
            }
            in = null;
            try {
                try {
                    in = new SafeFileInputStream(prefFile);
                    this.preferences.load(in);
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        System.out.println("IOException encountered loading preference file " + prefFile);
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable var5_5) {
                var4_7 = null;
                if (in == null) throw var5_5;
                try {
                    in.close();
                    throw var5_5;
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) throw var5_5;
                    System.out.println("IOException encountered closing preference file " + prefFile);
                    e.printStackTrace();
                }
                throw var5_5;
            }
            {
                var4_8 = null;
                if (in == null) break block14;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 162->169)] { 
lbl34:
            // 1 sources

            in.close();
            break block14;
lbl36:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block14;
                System.out.println("IOException encountered closing preference file " + prefFile);
                e.printStackTrace();
            }
        }
        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
        System.out.println("Preferences now set as follows:");
        prefNames = this.preferences.propertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) break;
            value = this.preferences.getString(prefNames[i]);
            System.out.println("\t" + prefNames[i] + " = " + value);
            ++i;
        }
        prefNames = this.preferences.defaultPropertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) {
                return;
            }
            value = this.preferences.getDefaultString(prefNames[i]);
            System.out.println("\tDefault values: " + prefNames[i] + " = " + value);
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public final void savePluginPreferences() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 207->211)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void initializeDefaultPluginPreferences() {
    }

    private void applyExternalPluginDefaultOverrides() {
        InternalPlatform.applyPrimaryFeaturePluginDefaultOverrides(this.getDescriptor().getUniqueIdentifier(), this.preferences);
        InternalPlatform.applyCommandLinePluginDefaultOverrides(this.getDescriptor().getUniqueIdentifier(), this.preferences);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyInternalPluginDefaultOverrides() {
        block19: {
            pluginDescriptor = this.getDescriptor();
            baseURL = pluginDescriptor.find(new Path("preferences.ini"));
            if (baseURL == null) {
                if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                System.out.println("Plugin preference file preferences.ini not found.");
                return;
            }
            iniFile = new File(this.getFileFromURL(baseURL));
            if (!iniFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                System.out.println("Plugin preference file " + iniFile + " not found.");
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from " + iniFile);
            }
            overrides = new Properties();
            in = null;
            try {
                try {
                    in = new SafeFileInputStream(iniFile);
                    overrides.load(in);
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        System.out.println("IOException encountered loading preference file " + iniFile);
                        e.printStackTrace();
                    }
                    var7_8 = null;
                    try {
                        if (in == null) return;
                        in.close();
                        return;
                    }
                    catch (IOException e) {
                        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                        System.out.println("IOException encountered closing preference file " + iniFile);
                        e.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable var8_14) {
                var7_9 = null;
                ** try [egrp 2[TRYBLOCK] [3 : 208->221)] { 
lbl40:
                // 1 sources

                if (in == null) throw var8_14;
                in.close();
                throw var8_14;
lbl43:
                // 1 sources

                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) throw var8_14;
                    System.out.println("IOException encountered closing preference file " + iniFile);
                    e.printStackTrace();
                }
                throw var8_14;
            }
            {
                var7_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 208->221)] { 
lbl50:
            // 1 sources

            if (in != null) {
                in.close();
            }
            break block19;
lbl53:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block19;
                System.out.println("IOException encountered closing preference file " + iniFile);
                e.printStackTrace();
            }
        }
        props = null;
        if (!overrides.isEmpty()) {
            props = InternalPlatform.getPreferenceTranslator(pluginDescriptor, "preferences");
        }
        it = overrides.entrySet().iterator();
        while (true) {
            if (!it.hasNext()) break;
            entry = it.next();
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            value = InternalPlatform.translatePreference(value, props);
            this.preferences.setDefault(key, value);
        }
        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
        System.out.println("Preferences now set as follows:");
        prefNames = this.preferences.propertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) break;
            value = this.preferences.getString(prefNames[i]);
            System.out.println("\t" + prefNames[i] + " = " + value);
            ++i;
        }
        prefNames = this.preferences.defaultPropertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) {
                return;
            }
            value = this.preferences.getDefaultString(prefNames[i]);
            System.out.println("\tDefault values: " + prefNames[i] + " = " + value);
            ++i;
        }
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public final InputStream openStream(IPath file) throws IOException {
        return this.openStream(file, false);
    }

    public final InputStream openStream(IPath file, boolean localized) throws IOException {
        URL target = new URL(this.getDescriptor().getInstallURL() + file.toString());
        return target.openStream();
    }

    public void setDebugging(boolean value) {
        this.debug = value;
    }

    public void shutdown() throws CoreException {
    }

    public void startup() throws CoreException {
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

