/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.SpeechEventWrapper;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.speech.EngineProperties;
import javax.speech.SpeechError;
import javax.speech.SpeechEvent;

public abstract class BaseEngineProperties
implements EngineProperties,
SpeechEventDispatcher {
    protected Vector propertyChangeListeners = new Vector();

    protected BaseEngineProperties() {
    }

    public Component getControlComponent() {
        return null;
    }

    public abstract void reset();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.propertyChangeListeners.contains(propertyChangeListener)) {
            this.propertyChangeListeners.addElement(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.removeElement(propertyChangeListener);
    }

    protected void postPropertyChangeEvent(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        SpeechEventWrapper speechEventWrapper = new SpeechEventWrapper(propertyChangeEvent);
        SpeechEventUtilities.postSpeechEvent(this, speechEventWrapper);
    }

    protected void postPropertyChangeEvent(String string, float f, float f2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, new Float(f), new Float(f2));
        SpeechEventWrapper speechEventWrapper = new SpeechEventWrapper(propertyChangeEvent);
        SpeechEventUtilities.postSpeechEvent(this, speechEventWrapper);
    }

    protected void postPropertyChangeEvent(String string, int n, int n2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, new Integer(n), new Integer(n2));
        SpeechEventWrapper speechEventWrapper = new SpeechEventWrapper(propertyChangeEvent);
        SpeechEventUtilities.postSpeechEvent(this, speechEventWrapper);
    }

    protected void postPropertyChangeEvent(String string, boolean bl, boolean bl2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, new Boolean(bl), new Boolean(bl2));
        SpeechEventWrapper speechEventWrapper = new SpeechEventWrapper(propertyChangeEvent);
        SpeechEventUtilities.postSpeechEvent(this, speechEventWrapper);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        if (this.propertyChangeListeners == null) {
            return;
        }
        Enumeration enumeration = this.propertyChangeListeners.elements();
        while (enumeration.hasMoreElements()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void dispatchSpeechEvent(SpeechEvent speechEvent) {
        if (!(speechEvent instanceof SpeechEventWrapper)) {
            throw new SpeechError("BaseEngineProperties: speech event type error");
        }
        SpeechEventWrapper speechEventWrapper = (SpeechEventWrapper)speechEvent;
        PropertyChangeEvent propertyChangeEvent = (PropertyChangeEvent)speechEventWrapper.getEventObject();
        this.firePropertyChangeEvent(propertyChangeEvent);
    }
}

