/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.SpeechEventDispatcher;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.security.AccessControlException;
import javax.speech.SpeechEvent;

public class SpeechEventUtilities {
    protected static boolean awtRunning = false;
    protected static EventQueue systemEventQueue = null;
    protected static SpeechAWTEventTarget speechAWTEventTarget = null;
    public static boolean waitUntilDispatched = false;

    protected static boolean isAWTRunning() {
        if (awtRunning) {
            return true;
        }
        try {
            ThreadGroup threadGroup;
            ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
            ThreadGroup threadGroup3 = threadGroup2.getParent();
            while (threadGroup3 != null) {
                threadGroup2 = threadGroup3;
                threadGroup3 = threadGroup3.getParent();
            }
            int n = threadGroup2.activeCount();
            Thread[] threadArray = new Thread[n];
            threadGroup2.enumerate(threadArray, true);
            int n2 = 0;
            while (n2 < threadArray.length) {
                String string;
                if (threadArray[n2] != null && (string = threadArray[n2].getName()).startsWith("AWT-EventQueue")) {
                    awtRunning = true;
                    return true;
                }
                ++n2;
            }
        }
        catch (AccessControlException accessControlException) {
            return true;
        }
        return false;
    }

    public static void postSpeechEvent(SpeechEventDispatcher speechEventDispatcher, SpeechEvent speechEvent) {
        SpeechEventUtilities.postSpeechEvent(speechEventDispatcher, speechEvent, waitUntilDispatched);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postSpeechEvent(SpeechEventDispatcher speechEventDispatcher, SpeechEvent speechEvent, boolean bl) {
        if (SpeechEventUtilities.isAWTRunning()) {
            if (speechAWTEventTarget == null) {
                speechAWTEventTarget = new SpeechAWTEventTarget();
                systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
            if (bl) {
                Object object;
                Object object2 = object = new Object();
                synchronized (object2) {
                    systemEventQueue.postEvent(new SpeechAWTEvent(speechAWTEventTarget, speechEventDispatcher, speechEvent, object));
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            systemEventQueue.postEvent(new SpeechAWTEvent(speechAWTEventTarget, speechEventDispatcher, speechEvent));
        } else {
            speechEventDispatcher.dispatchSpeechEvent(speechEvent);
        }
    }

    protected static class SpeechAWTEvent
    extends AWTEvent {
        static final int EVENT_ID = 16829;
        SpeechEventDispatcher dispatcher = null;
        SpeechEvent event = null;
        Object lock = null;

        SpeechAWTEvent(SpeechAWTEventTarget speechAWTEventTarget, SpeechEventDispatcher speechEventDispatcher, SpeechEvent speechEvent) {
            this(speechAWTEventTarget, speechEventDispatcher, speechEvent, null);
        }

        SpeechAWTEvent(SpeechAWTEventTarget speechAWTEventTarget, SpeechEventDispatcher speechEventDispatcher, SpeechEvent speechEvent, Object object) {
            super(speechAWTEventTarget, 16829);
            this.dispatcher = speechEventDispatcher;
            this.event = speechEvent;
            this.lock = object;
        }
    }

    protected static class SpeechAWTEventTarget
    extends Component {
        SpeechAWTEventTarget() {
            this.enableEvents(16829L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof SpeechAWTEvent) {
                SpeechAWTEvent speechAWTEvent = (SpeechAWTEvent)aWTEvent;
                speechAWTEvent.dispatcher.dispatchSpeechEvent(speechAWTEvent.event);
                if (speechAWTEvent.lock != null) {
                    Object object = speechAWTEvent.lock;
                    synchronized (object) {
                        speechAWTEvent.lock.notify();
                    }
                }
            }
        }
    }
}

