/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.BaseEngineProperties;
import java.beans.PropertyVetoException;
import javax.speech.SpeechError;
import javax.speech.synthesis.SynthesizerProperties;
import javax.speech.synthesis.Voice;

public class BaseSynthesizerProperties
extends BaseEngineProperties
implements SynthesizerProperties {
    protected Voice defaultVoice;
    protected float defaultPitch;
    protected float defaultPitchRange;
    protected float defaultSpeakingRate;
    protected float defaultVolume;
    protected Voice currentVoice;
    protected float currentPitch;
    protected float currentPitchRange;
    protected float currentSpeakingRate;
    protected float currentVolume;

    public BaseSynthesizerProperties() {
        this.defaultVoice = null;
        this.defaultPitch = 0.0f;
        this.defaultPitchRange = 0.0f;
        this.defaultSpeakingRate = 0.0f;
        this.defaultVolume = 0.0f;
    }

    public BaseSynthesizerProperties(Voice voice, float f, float f2, float f3, float f4) {
        this.defaultVoice = voice != null ? (Voice)voice.clone() : null;
        this.defaultPitch = f;
        this.defaultPitchRange = f2;
        this.defaultSpeakingRate = f3;
        this.defaultVolume = f4;
        this.currentVoice = voice != null ? (Voice)voice.clone() : null;
        this.currentPitch = f;
        this.currentPitchRange = f2;
        this.currentSpeakingRate = f3;
        this.currentVolume = f4;
    }

    public void reset() {
        try {
            this.setVoice(this.defaultVoice);
            this.setVolume(this.defaultVolume);
            this.setPitch(this.defaultPitch);
            this.setPitchRange(this.defaultPitchRange);
            this.setSpeakingRate(this.defaultSpeakingRate);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new SpeechError("Inconsistent default properties");
        }
    }

    public Voice getVoice() {
        return (Voice)this.currentVoice.clone();
    }

    public void setVoice(Voice voice) throws PropertyVetoException {
        Voice voice2 = this.currentVoice;
        this.currentVoice = (Voice)voice.clone();
        this.postPropertyChangeEvent("Voice", voice2, voice);
    }

    public float getPitch() {
        return this.currentPitch;
    }

    public void setPitch(float f) throws PropertyVetoException {
        float f2 = this.currentPitch;
        this.currentPitch = f;
        this.postPropertyChangeEvent("Pitch", f2, f);
    }

    public float getPitchRange() {
        return this.currentPitchRange;
    }

    public void setPitchRange(float f) throws PropertyVetoException {
        float f2 = this.currentPitchRange;
        this.currentPitchRange = f;
        this.postPropertyChangeEvent("PitchRange", f2, f);
    }

    public float getSpeakingRate() {
        return this.currentSpeakingRate;
    }

    public void setSpeakingRate(float f) throws PropertyVetoException {
        float f2 = this.currentSpeakingRate;
        this.currentSpeakingRate = f;
        this.postPropertyChangeEvent("SpeakingRate", f2, f);
    }

    public float getVolume() {
        return this.currentVolume;
    }

    public void setVolume(float f) throws PropertyVetoException {
        if (f > 1.0f) {
            f = 1.0f;
        } else if (f < 0.0f) {
            f = 0.0f;
        }
        float f2 = this.currentVolume;
        this.currentVolume = f;
        this.postPropertyChangeEvent("Volume", f2, f);
    }
}

