/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.FeatureSetImpl;
import com.sun.speech.freetts.FreeTTSSpeakable;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Token;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.util.SegmentRelationUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Utterance
implements FeatureSet,
Serializable {
    private Voice voice;
    private FeatureSetImpl features;
    private FeatureSetImpl relations;
    private Vector listeners = null;
    private boolean first;
    private boolean last;
    private FreeTTSSpeakable speakable;

    public Utterance(Voice voice) {
        this.voice = voice;
        this.listeners = new Vector();
        this.features = new FeatureSetImpl();
        this.relations = new FeatureSetImpl();
    }

    public Utterance(Voice voice, List list) {
        this(voice);
        this.setTokenList(list);
    }

    public void setSpeakable(FreeTTSSpeakable freeTTSSpeakable) {
        this.speakable = freeTTSSpeakable;
    }

    public FreeTTSSpeakable getSpeakable() {
        return this.speakable;
    }

    public Relation createRelation(String string) {
        Relation relation = new Relation(string, this);
        this.relations.setObject(string, relation);
        return relation;
    }

    public Relation getRelation(String string) {
        return (Relation)this.relations.getObject(string);
    }

    public boolean hasRelation(String string) {
        return this.relations.isPresent(string);
    }

    public Voice getVoice() {
        return this.voice;
    }

    public void dump(PrintWriter printWriter, int n, String string, boolean bl) {
        printWriter.println(" ============ " + string + " ========== ");
        if (!bl) {
            this.voice.dump(printWriter, n + 4, "Voice");
            this.features.dump(printWriter, n + 4, "Features");
        }
        this.relations.dump(printWriter, n + 4, "Relations");
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter, int n, String string) {
        this.dump(printWriter, n, string, false);
    }

    public void dump(PrintWriter printWriter, String string) {
        this.dump(printWriter, 0, string, false);
    }

    public void dump(String string) {
        this.dump(new PrintWriter(System.out), 0, string, false);
    }

    public void dumpRelations(String string) {
        this.dump(new PrintWriter(System.out), 0, string, true);
    }

    public boolean isPresent(String string) {
        if (!this.features.isPresent(string)) {
            return this.getVoice().getFeatures().isPresent(string);
        }
        return true;
    }

    public void remove(String string) {
        this.features.remove(string);
    }

    public String getString(String string) {
        if (!this.features.isPresent(string)) {
            return this.getVoice().getFeatures().getString(string);
        }
        return this.features.getString(string);
    }

    public int getInt(String string) {
        if (!this.features.isPresent(string)) {
            return this.getVoice().getFeatures().getInt(string);
        }
        return this.features.getInt(string);
    }

    public float getFloat(String string) {
        if (!this.features.isPresent(string)) {
            return this.getVoice().getFeatures().getFloat(string);
        }
        return this.features.getFloat(string);
    }

    public Object getObject(String string) {
        if (!this.features.isPresent(string)) {
            return this.getVoice().getFeatures().getObject(string);
        }
        return this.features.getObject(string);
    }

    public void setInt(String string, int n) {
        this.features.setInt(string, n);
    }

    public void setFloat(String string, float f) {
        this.features.setFloat(string, f);
    }

    public void setString(String string, String string2) {
        this.features.setString(string, string2);
    }

    public void setObject(String string, Object object) {
        this.features.setObject(string, object);
    }

    public Item getItem(String string, float f) {
        Relation relation = null;
        relation = this.getRelation("Segment");
        if (relation == null) {
            throw new IllegalStateException("Utterance has no Segment relation");
        }
        String string2 = null;
        if (!string.equals("Segment")) {
            if (string.equals("Syllable")) {
                string2 = "R:SylStructure.parent.R:Syllable";
            } else if (string.equals("SylStructure")) {
                string2 = "R:SylStructure.parent.parent";
            } else if (string.equals("Word")) {
                string2 = "R:SylStructure.parent.parent.R:Word";
            } else if (string.equals("Token")) {
                string2 = "R:SylStructure.parent.parent.R:Token.parent";
            } else if (string.equals("Phrase")) {
                string2 = "R:SylStructure.parent.parent.R:Phrase.parent";
            } else {
                throw new IllegalArgumentException("Utterance.getItem(): relation cannot be " + string);
            }
        }
        PathExtractorImpl pathExtractorImpl = new PathExtractorImpl(string2, false);
        Item item = SegmentRelationUtils.getItem(relation, f);
        if (string.equals("Segment")) {
            return item;
        }
        if (item != null) {
            return pathExtractorImpl.findItem(item);
        }
        return null;
    }

    public float getDuration() {
        float f = -1.0f;
        f = this.getLastFloat("Segment", "end");
        if (f == -1.0f && (f = this.getLastFloat("Target", "pos")) == -1.0f) {
            throw new IllegalStateException("Utterance: Error finding duration");
        }
        return f;
    }

    private float getLastFloat(String string, String string2) {
        Item item;
        float f = -1.0f;
        Relation relation = this.getRelation(string);
        if (relation != null && (item = relation.getTail()) != null) {
            f = item.getFeatures().getFloat(string2);
        }
        return f;
    }

    private void setInputText(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        this.setString("input_text", stringBuffer.toString());
    }

    private void setTokenList(List list) {
        this.setInputText(list);
        Relation relation = this.createRelation("Token");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            String string = token.getWord();
            if (string == null || string.length() <= 0) continue;
            Item item = relation.appendItem();
            FeatureSet featureSet = item.getFeatures();
            featureSet.setString("name", string);
            featureSet.setString("whitespace", token.getWhitespace());
            featureSet.setString("prepunctuation", token.getPrepunctuation());
            featureSet.setString("punc", token.getPostpunctuation());
            featureSet.setString("file_pos", String.valueOf(token.getPosition()));
            featureSet.setString("line_number", String.valueOf(token.getLineNumber()));
        }
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean bl) {
        this.first = bl;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean bl) {
        this.last = bl;
    }
}

