/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.cart;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.cart.CART;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CARTImpl
implements CART {
    static final String TOTAL = "TOTAL";
    static final String NODE = "NODE";
    static final String LEAF = "LEAF";
    static final String OPERAND_MATCHES = "MATCHES";
    private static final boolean DEBUG = false;
    Node[] cart = null;
    transient int curNode = 0;

    public CARTImpl(URL uRL) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!string.startsWith("***")) {
                this.parseAndAdd(string);
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public CARTImpl(BufferedReader bufferedReader, int n) throws IOException {
        this(n);
        int n2 = 0;
        while (n2 < n) {
            String string = bufferedReader.readLine();
            if (!string.startsWith("***")) {
                this.parseAndAdd(string);
            }
            ++n2;
        }
    }

    private CARTImpl(int n) {
        this.cart = new Node[n];
    }

    public void dumpBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.cart.length);
        int n = 0;
        while (n < this.cart.length) {
            this.cart[n].dumpBinary(dataOutputStream);
            ++n;
        }
    }

    public static CART loadBinary(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        CARTImpl cARTImpl = new CARTImpl(n);
        int n2 = 0;
        while (n2 < n) {
            String string = Utilities.getString(byteBuffer);
            cARTImpl.parseAndAdd(string);
            ++n2;
        }
        return cARTImpl;
    }

    public static CART loadBinary(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        CARTImpl cARTImpl = new CARTImpl(n);
        int n2 = 0;
        while (n2 < n) {
            String string = Utilities.getString(dataInputStream);
            cARTImpl.parseAndAdd(string);
            ++n2;
        }
        return cARTImpl;
    }

    protected void parseAndAdd(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (string2.equals(LEAF) || string2.equals(NODE)) {
            this.cart[this.curNode] = this.getNode(string2, stringTokenizer, this.curNode);
            this.cart[this.curNode].setCreationLine(string);
            ++this.curNode;
        } else if (string2.equals(TOTAL)) {
            this.cart = new Node[Integer.parseInt(stringTokenizer.nextToken())];
            this.curNode = 0;
        } else {
            throw new Error("Invalid CART type: " + string2);
        }
    }

    protected Node getNode(String string, StringTokenizer stringTokenizer, int n) {
        if (string.equals(NODE)) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            Object object = this.parseValue(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (string3.equals(OPERAND_MATCHES)) {
                return new MatchingNode(string2, object.toString(), n + 1, n2);
            }
            return new ComparisonNode(string2, object, string3, n + 1, n2);
        }
        if (string.equals(LEAF)) {
            return new LeafNode(this.parseValue(stringTokenizer.nextToken()));
        }
        return null;
    }

    protected Object parseValue(String string) {
        int n = string.indexOf("(");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        if (string2.equals("String")) {
            return string3;
        }
        if (string2.equals("Float")) {
            return new Float(Float.parseFloat(string3));
        }
        if (string2.equals("Integer")) {
            return new Integer(Integer.parseInt(string3));
        }
        if (string2.equals("List")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            int n2 = stringTokenizer.countTokens();
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                float f = Float.parseFloat(stringTokenizer.nextToken());
                nArray[n3] = Math.round(f);
                ++n3;
            }
            return nArray;
        }
        throw new Error("Unknown type: " + string2);
    }

    public Object interpret(Item item) {
        int n = 0;
        Node node = this.cart[n];
        while (!(this.cart[n] instanceof LeafNode)) {
            DecisionNode decisionNode = (DecisionNode)this.cart[n];
            n = decisionNode.getNextNode(item);
        }
        return ((LeafNode)this.cart[n]).getValue();
    }

    static class LeafNode
    extends Node {
        public LeafNode(Object object) {
            super(object);
        }

        public String toString() {
            return "LEAF " + this.getValueString();
        }
    }

    static class MatchingNode
    extends DecisionNode {
        Pattern pattern;

        public MatchingNode(String string, String string2, int n, int n2) {
            super(string, string2, n, n2);
            this.pattern = Pattern.compile(string2);
        }

        public int getNextNode(Object object) {
            return this.pattern.matcher((String)object).matches() ? this.qtrue : this.qfalse;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("NODE " + this.getFeature() + " " + CARTImpl.OPERAND_MATCHES);
            stringBuffer.append(this.getValueString() + " ");
            stringBuffer.append(Integer.toString(this.qtrue) + " ");
            stringBuffer.append(Integer.toString(this.qfalse));
            return stringBuffer.toString();
        }
    }

    static class ComparisonNode
    extends DecisionNode {
        static final String LESS_THAN = "<";
        static final String EQUALS = "=";
        static final String GREATER_THAN = ">";
        String comparisonType;

        public ComparisonNode(String string, Object object, String string2, int n, int n2) {
            super(string, object, n, n2);
            if (!(string2.equals(LESS_THAN) || string2.equals(EQUALS) || string2.equals(GREATER_THAN))) {
                throw new Error("Invalid comparison type: " + string2);
            }
            this.comparisonType = string2;
        }

        public int getNextNode(Object object) {
            boolean bl = false;
            if (this.comparisonType.equals(LESS_THAN) || this.comparisonType.equals(GREATER_THAN)) {
                float f = this.value instanceof Float ? ((Float)this.value).floatValue() : Float.parseFloat(this.value.toString());
                float f2 = object instanceof Float ? ((Float)object).floatValue() : Float.parseFloat(object.toString());
                bl = this.comparisonType.equals(LESS_THAN) ? f2 < f : f2 > f;
            } else {
                String string = object.toString();
                String string2 = this.value.toString();
                bl = string.equals(string2);
            }
            int n = bl ? this.qtrue : this.qfalse;
            return n;
        }

        private void trace(Object object, boolean bl, int n) {
            System.out.println("NODE " + this.getFeature() + " [" + object + "] " + this.comparisonType + " [" + this.getValue() + "] " + (bl ? "Yes" : "No") + " next " + n);
        }

        public String toString() {
            return "NODE " + this.getFeature() + " " + this.comparisonType + " " + this.getValueString() + " " + Integer.toString(this.qtrue) + " " + Integer.toString(this.qfalse);
        }
    }

    static abstract class DecisionNode
    extends Node {
        private PathExtractor path;
        protected int qfalse;
        protected int qtrue;

        public String getFeature() {
            return this.path.toString();
        }

        public Object findFeature(Item item) {
            return this.path.findFeature(item);
        }

        public final int getNextNode(Item item) {
            return this.getNextNode(this.findFeature(item));
        }

        public DecisionNode(String string, Object object, int n, int n2) {
            super(object);
            this.path = new PathExtractorImpl(string, true);
            this.qtrue = n;
            this.qfalse = n2;
        }

        public abstract int getNextNode(Object var1);
    }

    static abstract class Node {
        protected Object value;
        private String creationLine;

        public Node(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueString() {
            if (this.value == null) {
                return "NULL()";
            }
            if (this.value instanceof String) {
                return "String(" + this.value.toString() + ")";
            }
            if (this.value instanceof Float) {
                return "Float(" + this.value.toString() + ")";
            }
            if (this.value instanceof Integer) {
                return "Integer(" + this.value.toString() + ")";
            }
            return this.value.getClass().toString() + "(" + this.value.toString() + ")";
        }

        public void setCreationLine(String string) {
            this.creationLine = string;
        }

        public final void dumpBinary(DataOutputStream dataOutputStream) throws IOException {
            Utilities.outString(dataOutputStream, this.creationLine);
        }
    }
}

