/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.diphone;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.diphone.IntLinkedList;
import com.sun.speech.freetts.relp.LPCResult;
import com.sun.speech.freetts.relp.SampleInfo;

public class DiphonePitchmarkGenerator
implements UtteranceProcessor {
    public void processUtterance(Utterance utterance) throws ProcessException {
        Object object;
        Relation relation = utterance.getRelation("Target");
        if (relation == null) {
            throw new IllegalStateException("DiphonePitchmarkGenerator: Target relation does not exist");
        }
        SampleInfo sampleInfo = (SampleInfo)utterance.getObject("SampleInfo");
        if (sampleInfo == null) {
            throw new IllegalStateException("DiphonePitchmarkGenerator: SampleInfo does not exist");
        }
        float f = 0.0f;
        float f2 = 0.0f;
        double d = 0.0;
        int n = 0;
        IntLinkedList intLinkedList = new IntLinkedList();
        Item item = relation.getHead();
        while (item != null) {
            object = item.getFeatures();
            float f3 = object.getFloat("pos");
            float f4 = object.getFloat("f0");
            if (d != (double)f3) {
                f2 = (f4 - 120.0f) / f3;
                while (d < (double)f3) {
                    d += 1.0 / (120.0 + d * (double)f2);
                    intLinkedList.add((int)(d * (double)sampleInfo.getSampleRate()));
                    ++n;
                }
            }
            item = item.getNext();
        }
        LPCResult lPCResult = new LPCResult();
        lPCResult.resizeFrames(n);
        n = 0;
        object = lPCResult.getTimes();
        intLinkedList.resetIterator();
        while (n < ((Object)object).length) {
            object[n] = intLinkedList.nextInt();
            ++n;
        }
        utterance.setObject("target_lpcres", lPCResult);
    }

    public String toString() {
        return "DiphonePitchmarkGenerator";
    }
}

