/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.diphone;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.diphone.Diphone;
import com.sun.speech.freetts.diphone.DiphoneUnit;
import com.sun.speech.freetts.diphone.DiphoneUnitDatabase;
import java.io.IOException;
import java.net.URL;

public class DiphoneUnitSelector
implements UtteranceProcessor {
    private DiphoneUnitDatabase diphoneDatabase;

    public DiphoneUnitSelector(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("Can't load unit database");
        }
        boolean bl = uRL.getPath().endsWith(".bin");
        this.diphoneDatabase = new DiphoneUnitDatabase(uRL, bl);
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        if (utterance.getRelation("Segment") == null) {
            throw new IllegalStateException("DiphoneUnitSelector: Segment relation does not exist");
        }
        utterance.setObject("SampleInfo", this.diphoneDatabase.getSampleInfo());
        this.createUnitRelation(utterance);
    }

    private void createUnitRelation(Utterance utterance) {
        Relation relation = utterance.createRelation("Unit");
        Relation relation2 = utterance.getRelation("Segment");
        Item item = relation2.getHead();
        while (item != null && item.getNext() != null) {
            Item item2 = item.getNext();
            String string = item.getFeatures().getString("name") + "-" + item2.getFeatures().getString("name");
            float f = item.getFeatures().getFloat("end");
            int n = (int)(f * (float)this.diphoneDatabase.getSampleInfo().getSampleRate());
            Item item3 = this.createUnitItem(relation, string, n, 1);
            item.addDaughter(item3);
            float f2 = item2.getFeatures().getFloat("end");
            n = (int)((double)(f + f2) / 2.0 * (double)this.diphoneDatabase.getSampleInfo().getSampleRate());
            Item item4 = this.createUnitItem(relation, string, n, 2);
            item2.addDaughter(item4);
            item = item2;
        }
    }

    private Item createUnitItem(Relation relation, String string, int n, int n2) {
        Diphone diphone = this.diphoneDatabase.getUnit(string);
        if (diphone == null) {
            System.err.println("FreeTTS: unit database failed to find entry for: " + string);
        }
        Item item = relation.appendItem();
        FeatureSet featureSet = item.getFeatures();
        featureSet.setString("name", string);
        featureSet.setInt("target_end", n);
        featureSet.setObject("unit", new DiphoneUnit(diphone, n2));
        return item;
    }

    public String toString() {
        return "DiphoneUnitSelector";
    }
}

