/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en.us;

import com.sun.speech.freetts.lexicon.LexiconImpl;
import com.sun.speech.freetts.util.BulkTimer;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class CMULexicon
extends LexiconImpl {
    private static final String VOWELS = "aeiou";
    private static final String GLIDES_LIQUIDS = "wylr";
    private static final String NASALS = "nm";
    private static final String VOICED_OBSTRUENTS = "bdgjlmnnnrvwyz";
    static /* synthetic */ Class class$com$sun$speech$freetts$en$us$CMULexicon;

    public CMULexicon(URL uRL, URL uRL2, URL uRL3, boolean bl) {
        this.setLexiconParameters(uRL, uRL2, uRL3, bl);
    }

    public CMULexicon() {
        this("cmulex");
    }

    public CMULexicon(String string) {
        Class clazz = class$com$sun$speech$freetts$en$us$CMULexicon == null ? (class$com$sun$speech$freetts$en$us$CMULexicon = CMULexicon.class$("com.sun.speech.freetts.en.us.CMULexicon")) : class$com$sun$speech$freetts$en$us$CMULexicon;
        URL uRL = clazz.getResource(string + "_lts.bin");
        URL uRL2 = clazz.getResource(string + "_compiled.bin");
        URL uRL3 = clazz.getResource(string + "_addenda.bin");
        this.setLexiconParameters(uRL2, uRL3, uRL, true);
    }

    public static CMULexicon getInstance(boolean bl) throws IOException {
        return CMULexicon.getInstance("cmulex", bl);
    }

    public static CMULexicon getInstance(String string, boolean bl) throws IOException {
        URL uRL;
        URL uRL2;
        URL uRL3;
        Class clazz;
        Class clazz2 = clazz = class$com$sun$speech$freetts$en$us$CMULexicon == null ? (class$com$sun$speech$freetts$en$us$CMULexicon = CMULexicon.class$("com.sun.speech.freetts.en.us.CMULexicon")) : class$com$sun$speech$freetts$en$us$CMULexicon;
        if (bl) {
            uRL3 = clazz.getResource(string + "_lts.bin");
            uRL2 = clazz.getResource(string + "_compiled.bin");
            uRL = clazz.getResource(string + "_addenda.bin");
        } else {
            uRL3 = clazz.getResource(string + "_lts.txt");
            uRL2 = clazz.getResource(string + "_compiled.txt");
            uRL = clazz.getResource(string + "_addenda.txt");
            System.out.println("lts is " + uRL3);
            System.out.println("com is " + uRL2);
            System.out.println("ad is " + uRL);
        }
        CMULexicon cMULexicon = new CMULexicon(uRL2, uRL, uRL3, bl);
        cMULexicon.load();
        return cMULexicon;
    }

    public boolean isSyllableBoundary(List list, String[] stringArray, int n) {
        if (n >= stringArray.length) {
            return true;
        }
        if (CMULexicon.isSilence(stringArray[n])) {
            return true;
        }
        if (!CMULexicon.hasVowel(stringArray, n)) {
            return false;
        }
        if (!CMULexicon.hasVowel(list)) {
            return false;
        }
        if (CMULexicon.isVowel(stringArray[n])) {
            return true;
        }
        if (n == stringArray.length - 1) {
            return false;
        }
        int n2 = CMULexicon.getSonority((String)list.get(list.size() - 1));
        int n3 = CMULexicon.getSonority(stringArray[n]);
        int n4 = CMULexicon.getSonority(stringArray[n + 1]);
        return n2 <= n3 && n3 <= n4;
    }

    protected static boolean isSilence(String string) {
        return string.equals("pau");
    }

    protected static boolean hasVowel(String[] stringArray, int n) {
        int n2 = n;
        while (n2 < stringArray.length) {
            if (CMULexicon.isVowel(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean hasVowel(List list) {
        int n = 0;
        while (n < list.size()) {
            if (CMULexicon.isVowel((String)list.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static boolean isVowel(String string) {
        return VOWELS.indexOf(string.substring(0, 1)) != -1;
    }

    protected static int getSonority(String string) {
        if (CMULexicon.isVowel(string) || CMULexicon.isSilence(string)) {
            return 5;
        }
        if (GLIDES_LIQUIDS.indexOf(string.substring(0, 1)) != -1) {
            return 4;
        }
        if (NASALS.indexOf(string.substring(0, 1)) != -1) {
            return 3;
        }
        if (VOICED_OBSTRUENTS.indexOf(string.substring(0, 1)) != -1) {
            return 2;
        }
        return 1;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "cmulex";
        try {
            if (stringArray.length > 0) {
                BulkTimer.LOAD.start();
                int n = 0;
                while (n < stringArray.length) {
                    CMULexicon cMULexicon;
                    if (stringArray[n].equals("-name") && n < stringArray.length - 1) {
                        string = stringArray[++n];
                    } else if (stringArray[n].equals("-generate_binary")) {
                        BulkTimer.LOAD.start("load_text");
                        cMULexicon = CMULexicon.getInstance(string, false);
                        BulkTimer.LOAD.stop("load_text");
                        BulkTimer.LOAD.start("dump_text");
                        cMULexicon.dumpBinary(string);
                        BulkTimer.LOAD.stop("dump_text");
                    } else if (stringArray[n].equals("-compare")) {
                        BulkTimer.LOAD.start("load_text");
                        cMULexicon = CMULexicon.getInstance(string, false);
                        BulkTimer.LOAD.stop("load_text");
                        BulkTimer.LOAD.start("load_binary");
                        CMULexicon cMULexicon2 = CMULexicon.getInstance(string, true);
                        BulkTimer.LOAD.stop("load_binary");
                        BulkTimer.LOAD.start("compare");
                        cMULexicon.compare(cMULexicon2);
                        BulkTimer.LOAD.stop("compare");
                    } else if (stringArray[n].equals("-showtimes")) {
                        bl = true;
                    } else {
                        System.out.println("Unknown option " + stringArray[n]);
                    }
                    ++n;
                }
                BulkTimer.LOAD.stop();
                if (bl) {
                    BulkTimer.LOAD.show("CMULexicon loading and dumping");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showtimes");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

