/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.lexicon;

import com.sun.speech.freetts.lexicon.LetterToSound;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class LetterToSoundImpl
implements LetterToSound {
    static final String TOTAL = "TOTAL";
    static final String INDEX = "INDEX";
    static final String STATE = "STATE";
    static final String PHONE = "PHONE";
    protected boolean tokenizeOnLoad = false;
    protected boolean tokenizeOnLookup = false;
    private static final int MAGIC = -559038737;
    private static final int VERSION = 1;
    private Object[] stateMachine = null;
    private int numStates = 0;
    private static final int WINDOW_SIZE = 4;
    private char[] fval_buff = new char[8];
    protected HashMap letterIndex;
    private static List phonemeTable;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$speech$freetts$lexicon$LetterToSoundImpl;

    public LetterToSoundImpl(URL uRL, boolean bl) throws IOException {
        BulkTimer.LOAD.start("LTS");
        InputStream inputStream = uRL.openStream();
        if (bl) {
            this.loadBinary(inputStream);
        } else {
            this.loadText(inputStream);
        }
        inputStream.close();
        BulkTimer.LOAD.stop("LTS");
    }

    private void loadText(InputStream inputStream) throws IOException {
        String string = Utilities.getProperty("com.sun.speech.freetts.lexicon.LTSTokenize", "load");
        this.tokenizeOnLoad = string.equals("load");
        this.tokenizeOnLookup = string.equals("lookup");
        this.letterIndex = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (!string2.startsWith("***")) {
                this.parseAndAdd(string2);
            }
            string2 = bufferedReader.readLine();
        }
    }

    private void loadBinary(InputStream inputStream) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != -559038737) {
            throw new Error("Bad LTS binary file format");
        }
        if (dataInputStream.readInt() != 1) {
            throw new Error("Bad LTS binary file version");
        }
        int n2 = dataInputStream.readInt();
        phonemeTable = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            String string = dataInputStream.readUTF();
            phonemeTable.add(string);
            ++n3;
        }
        int n4 = dataInputStream.readInt();
        this.letterIndex = new HashMap();
        int n5 = 0;
        while (n5 < n4) {
            char c = dataInputStream.readChar();
            n = dataInputStream.readInt();
            this.letterIndex.put(Character.toString(c), new Integer(n));
            ++n5;
        }
        int n6 = dataInputStream.readInt();
        this.stateMachine = new Object[n6];
        n = 0;
        while (n < n6) {
            int n7 = dataInputStream.readInt();
            if (n7 == 2) {
                this.stateMachine[n] = FinalState.loadBinary(dataInputStream);
            } else if (n7 == 1) {
                this.stateMachine[n] = DecisionState.loadBinary(dataInputStream);
            } else {
                throw new Error("Unknown state type in LTS load");
            }
            ++n;
        }
    }

    protected void parseAndAdd(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (string2.equals(STATE) || string2.equals(PHONE)) {
            this.stateMachine[this.numStates] = this.tokenizeOnLoad ? this.getState(string2, stringTokenizer) : string;
            ++this.numStates;
        } else if (string2.equals(INDEX)) {
            Integer n = new Integer(stringTokenizer.nextToken());
            if (n != this.numStates) {
                throw new Error("Bad INDEX in file.");
            }
            String string3 = stringTokenizer.nextToken();
            this.letterIndex.put(string3, n);
        } else if (string2.equals(TOTAL)) {
            this.stateMachine = new Object[Integer.parseInt(stringTokenizer.nextToken())];
        }
    }

    public void dumpBinary(String string) throws IOException {
        Object object;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        dataOutputStream.writeInt(-559038737);
        dataOutputStream.writeInt(1);
        phonemeTable = this.findPhonemes();
        dataOutputStream.writeInt(phonemeTable.size());
        Iterator iterator = phonemeTable.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            dataOutputStream.writeUTF((String)object);
        }
        dataOutputStream.writeInt(this.letterIndex.size());
        object = this.letterIndex.keySet().iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            int n = (Integer)this.letterIndex.get(string2);
            dataOutputStream.writeChar(string2.charAt(0));
            dataOutputStream.writeInt(n);
        }
        dataOutputStream.writeInt(this.stateMachine.length);
        int n = 0;
        while (n < this.stateMachine.length) {
            this.getState(n).writeBinary(dataOutputStream);
            ++n;
        }
        dataOutputStream.close();
    }

    private List findPhonemes() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < this.stateMachine.length) {
            if (this.stateMachine[n] instanceof FinalState) {
                FinalState finalState = (FinalState)this.stateMachine[n];
                if (finalState.phoneList != null) {
                    int n2 = 0;
                    while (n2 < finalState.phoneList.length) {
                        hashSet.add(finalState.phoneList[n2]);
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return new ArrayList(hashSet);
    }

    protected State getState(int n) {
        State state = null;
        if (this.stateMachine[n] instanceof String) {
            state = this.getState((String)this.stateMachine[n]);
            if (this.tokenizeOnLookup) {
                this.stateMachine[n] = state;
            }
        } else {
            state = (State)this.stateMachine[n];
        }
        return state;
    }

    protected State getState(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        return this.getState(stringTokenizer.nextToken(), stringTokenizer);
    }

    protected State getState(String string, StringTokenizer stringTokenizer) {
        if (string.equals(STATE)) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            return new DecisionState(n, string2.charAt(0), n2, n3);
        }
        if (string.equals(PHONE)) {
            return new FinalState(stringTokenizer.nextToken());
        }
        return null;
    }

    protected char[] getFullBuff(String string) {
        char[] cArray = new char[string.length() + 8];
        int n = 0;
        while (n < 3) {
            cArray[n] = 48;
            ++n;
        }
        cArray[3] = 35;
        string.getChars(0, string.length(), cArray, 4);
        int n2 = 0;
        while (n2 < 3) {
            cArray[cArray.length - n2 - 1] = 48;
            ++n2;
        }
        cArray[cArray.length - 4] = 35;
        return cArray;
    }

    public String[] getPhones(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        char[] cArray = this.getFullBuff(string);
        int n = 0;
        while (n < string.length()) {
            int n2 = 0;
            while (n2 < 4) {
                this.fval_buff[n2] = cArray[n + n2];
                this.fval_buff[n2 + 4] = cArray[n2 + n + 1 + 4];
                ++n2;
            }
            char c = string.charAt(n);
            Integer n3 = (Integer)this.letterIndex.get(Character.toString(c));
            if (n3 != null) {
                if (!$assertionsDisabled && n3 == null) {
                    throw new AssertionError();
                }
                int n4 = n3;
                State state = this.getState(n4);
                while (!(state instanceof FinalState)) {
                    n4 = ((DecisionState)state).getNextState(this.fval_buff);
                    state = this.getState(n4);
                }
                ((FinalState)state).append(arrayList);
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean compare(LetterToSoundImpl letterToSoundImpl) {
        Object object;
        Object object2;
        Iterator iterator = this.letterIndex.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object2 = (Integer)this.letterIndex.get(string);
            if (((Integer)object2).equals(object = (Integer)letterToSoundImpl.letterIndex.get(string))) continue;
            System.out.println("Bad Index for " + string);
            return false;
        }
        int n = 0;
        while (n < this.stateMachine.length) {
            object2 = this.getState(n);
            if (!object2.compare((State)(object = letterToSoundImpl.getState(n)))) {
                System.out.println("Bad state " + n);
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "cmulex_lts";
        try {
            if (stringArray.length > 0) {
                BulkTimer bulkTimer = new BulkTimer();
                bulkTimer.start();
                int n = 0;
                while (n < stringArray.length) {
                    LetterToSoundImpl letterToSoundImpl;
                    if (stringArray[n].equals("-name") && n < stringArray.length - 1) {
                        string = stringArray[++n];
                    } else if (stringArray[n].equals("-generate_binary")) {
                        bulkTimer.start("load_text");
                        letterToSoundImpl = new LetterToSoundImpl(new URL("file:./" + string + ".txt"), false);
                        bulkTimer.stop("load_text");
                        bulkTimer.start("dump_binary");
                        letterToSoundImpl.dumpBinary(string + ".bin");
                        bulkTimer.stop("dump_binary");
                    } else if (stringArray[n].equals("-compare")) {
                        bulkTimer.start("load_text");
                        letterToSoundImpl = new LetterToSoundImpl(new URL("file:./" + string + ".txt"), false);
                        bulkTimer.stop("load_text");
                        bulkTimer.start("load_binary");
                        LetterToSoundImpl letterToSoundImpl2 = new LetterToSoundImpl(new URL("file:./" + string + ".bin"), true);
                        bulkTimer.stop("load_binary");
                        bulkTimer.start("compare");
                        if (!letterToSoundImpl.compare(letterToSoundImpl2)) {
                            System.out.println("NOT EQUIVALENT");
                        } else {
                            System.out.println("ok");
                        }
                        bulkTimer.stop("compare");
                    } else if (stringArray[n].equals("-showtimes")) {
                        bl = true;
                    } else {
                        System.out.println("Unknown option " + stringArray[n]);
                    }
                    ++n;
                }
                bulkTimer.stop();
                if (bl) {
                    bulkTimer.show("LTS loading and dumping");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showTimes");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$speech$freetts$lexicon$LetterToSoundImpl == null ? (class$com$sun$speech$freetts$lexicon$LetterToSoundImpl = LetterToSoundImpl.class$("com.sun.speech.freetts.lexicon.LetterToSoundImpl")) : class$com$sun$speech$freetts$lexicon$LetterToSoundImpl).desiredAssertionStatus();
    }

    static class FinalState
    implements State {
        static final int TYPE = 2;
        String[] phoneList;

        public FinalState(String string) {
            if (string.equals("epsilon")) {
                this.phoneList = null;
            } else {
                int n = string.indexOf(45);
                if (n != -1) {
                    this.phoneList = new String[2];
                    this.phoneList[0] = string.substring(0, n);
                    this.phoneList[1] = string.substring(n + 1);
                } else {
                    this.phoneList = new String[1];
                    this.phoneList[0] = string;
                }
            }
        }

        public FinalState(String[] stringArray) {
            this.phoneList = stringArray;
        }

        public void append(ArrayList arrayList) {
            if (this.phoneList == null) {
                return;
            }
            int n = 0;
            while (n < this.phoneList.length) {
                arrayList.add(this.phoneList[n]);
                ++n;
            }
        }

        public String toString() {
            if (this.phoneList == null) {
                return "PHONE epsilon";
            }
            if (this.phoneList.length == 1) {
                return "PHONE " + this.phoneList[0];
            }
            return "PHONE " + this.phoneList[0] + "-" + this.phoneList[1];
        }

        public boolean compare(State state) {
            if (state instanceof FinalState) {
                FinalState finalState = (FinalState)state;
                if (this.phoneList == null) {
                    return finalState.phoneList == null;
                }
                int n = 0;
                while (n < this.phoneList.length) {
                    if (!this.phoneList[n].equals(finalState.phoneList[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }

        public void writeBinary(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(2);
            if (this.phoneList == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(this.phoneList.length);
                int n = 0;
                while (n < this.phoneList.length) {
                    dataOutputStream.writeInt(phonemeTable.indexOf(this.phoneList[n]));
                    ++n;
                }
            }
        }

        public static State loadBinary(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            String[] stringArray = n == 0 ? null : new String[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = dataInputStream.readInt();
                stringArray[n2] = (String)phonemeTable.get(n3);
                ++n2;
            }
            return new FinalState(stringArray);
        }
    }

    static class DecisionState
    implements State {
        static final int TYPE = 1;
        int index;
        char c;
        int qtrue;
        int qfalse;

        public DecisionState(int n, char c, int n2, int n3) {
            this.index = n;
            this.c = c;
            this.qtrue = n2;
            this.qfalse = n3;
        }

        public int getNextState(char[] cArray) {
            return cArray[this.index] == this.c ? this.qtrue : this.qfalse;
        }

        public String toString() {
            return "STATE " + Integer.toString(this.index) + " " + Character.toString(this.c) + " " + Integer.toString(this.qtrue) + " " + Integer.toString(this.qfalse);
        }

        public void writeBinary(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(this.index);
            dataOutputStream.writeChar(this.c);
            dataOutputStream.writeInt(this.qtrue);
            dataOutputStream.writeInt(this.qfalse);
        }

        public static State loadBinary(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            char c = dataInputStream.readChar();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            return new DecisionState(n, c, n2, n3);
        }

        public boolean compare(State state) {
            if (state instanceof DecisionState) {
                DecisionState decisionState = (DecisionState)state;
                return this.index == decisionState.index && this.c == decisionState.c && this.qtrue == decisionState.qtrue && this.qfalse == decisionState.qfalse;
            }
            return false;
        }
    }

    static interface State {
        public void writeBinary(DataOutputStream var1) throws IOException;

        public boolean compare(State var1);
    }
}

