/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.freetts.mbrola;

import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.audio.AudioPlayer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFormat;

public class MbrolaAudioOutput
implements UtteranceProcessor {
    private static final AudioFormat MBROLA_AUDIO = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN);

    public void processUtterance(Utterance utterance) throws ProcessException {
        int n;
        utterance.getVoice().log("=== " + utterance.getString("input_text"));
        AudioPlayer audioPlayer = utterance.getVoice().getAudioPlayer();
        audioPlayer.setAudioFormat(MBROLA_AUDIO);
        audioPlayer.setVolume(utterance.getVoice().getVolume());
        List list = (List)utterance.getObject("mbrolaAudio");
        if (list == null) {
            throw new ProcessException("No \"mbrolaAudio\" object is associated with utterance");
        }
        try {
            n = utterance.getInt("mbrolaAudioLength");
        }
        catch (NullPointerException nullPointerException) {
            n = 0;
        }
        audioPlayer.begin(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            if (audioPlayer.write(byArray)) continue;
            throw new ProcessException("Cannot write audio data to audio player");
        }
        if (!audioPlayer.end()) {
            throw new ProcessException("audio player reports problem");
        }
    }

    public String toString() {
        return "MbrolaAudioOutput";
    }
}

