/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.boot.BundleStats;
import org.eclipse.core.internal.boot.ClassloaderStats;
import org.eclipse.core.internal.boot.InternalBootLoader;
import org.eclipse.core.internal.boot.PlatformClassLoader;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.ResourceEnumeration;
import org.eclipse.core.internal.boot.ResourceLoader;
import org.eclipse.core.internal.boot.URLContentFilter;

public abstract class DelegatingURLClassLoader
extends URLClassLoader {
    protected static Properties prefixTable = new Properties();
    protected URL base;
    protected String[] prefixes = null;
    protected DelegateLoader[] imports = null;
    protected URLClassLoader resourceLoader = null;
    private Hashtable filterTable = new Hashtable();
    public static String devClassPath;
    public static boolean DEBUG;
    public static boolean DEBUG_SHOW_CREATE;
    public static boolean DEBUG_SHOW_ACTIVATE;
    public static boolean DEBUG_SHOW_ACTIONS;
    public static boolean DEBUG_SHOW_SUCCESS;
    public static boolean DEBUG_SHOW_FAILURE;
    public static String[] DEBUG_FILTER_CLASS;
    public static String[] DEBUG_FILTER_LOADER;
    public static String[] DEBUG_FILTER_RESOURCE;
    public static String[] DEBUG_FILTER_NATIVE;
    public static boolean DEBUG_PROPERTIES;
    public static boolean DEBUG_PACKAGE_PREFIXES;
    public static boolean DEBUG_PACKAGE_PREFIXES_SUCCESS;
    public static boolean DEBUG_PACKAGE_PREFIXES_FAILURE;
    public static boolean MONITOR_PLUGINS;
    public static boolean MONITOR_CLASSES;
    public static boolean MONITOR_BUNDLES;
    public static String TRACE_FILENAME;
    public static String TRACE_FILTERS;
    public static boolean TRACE_CLASSES;
    public static boolean TRACE_PLUGINS;
    public static final String PLUGIN = "plugin";
    private static String[] JAR_VARIANTS;
    private static String[] LIBRARY_VARIANTS;

    static {
        DelegatingURLClassLoader.initializePrefixTable();
        devClassPath = null;
        DEBUG = false;
        DEBUG_SHOW_CREATE = true;
        DEBUG_SHOW_ACTIVATE = true;
        DEBUG_SHOW_ACTIONS = true;
        DEBUG_SHOW_SUCCESS = true;
        DEBUG_SHOW_FAILURE = true;
        DEBUG_FILTER_CLASS = new String[0];
        DEBUG_FILTER_LOADER = new String[0];
        DEBUG_FILTER_RESOURCE = new String[0];
        DEBUG_FILTER_NATIVE = new String[0];
        DEBUG_PROPERTIES = false;
        DEBUG_PACKAGE_PREFIXES = false;
        DEBUG_PACKAGE_PREFIXES_SUCCESS = false;
        DEBUG_PACKAGE_PREFIXES_FAILURE = false;
        MONITOR_PLUGINS = false;
        MONITOR_CLASSES = false;
        MONITOR_BUNDLES = false;
        TRACE_FILENAME = "runtime.traces";
        TRACE_FILTERS = "trace.properties";
        TRACE_CLASSES = false;
        TRACE_PLUGINS = false;
        JAR_VARIANTS = DelegatingURLClassLoader.buildJarVariants();
        LIBRARY_VARIANTS = DelegatingURLClassLoader.buildLibraryVariants();
    }

    private static String[] buildJarVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + InternalBootLoader.getWS() + "/");
        result.add("os/" + InternalBootLoader.getOS() + "/" + InternalBootLoader.getOSArch() + "/");
        result.add("os/" + InternalBootLoader.getOS() + "/");
        String nl = InternalBootLoader.getNL();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private static String[] buildLibraryVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + InternalBootLoader.getWS() + "/");
        result.add("os/" + InternalBootLoader.getOS() + "/" + InternalBootLoader.getOSArch() + "/");
        result.add("os/" + InternalBootLoader.getOS() + "/");
        String nl = InternalBootLoader.getNL();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializePrefixTable() {
        if (!InternalBootLoader.useClassLoaderProperties()) {
            return;
        }
        InputStream input = null;
        String filename = InternalBootLoader.getClassLoaderPropertiesFilename();
        if (filename == null) {
            filename = InternalBootLoader.getDefaultClassLoaderPropertiesFilename();
        }
        String errorMessage = "Error opening: " + filename + ". Continuing execution without using classloader performance enhancement.";
        try {
            input = new URL(filename).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                input = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException ex) {
                System.err.println(errorMessage);
                ex.printStackTrace();
                return;
            }
        }
        catch (IOException e) {
            System.err.println(errorMessage);
            e.printStackTrace();
            return;
        }
        try {
            try {
                prefixTable.load(input);
            }
            catch (Throwable throwable) {
                Object e = null;
                input.close();
                throw throwable;
            }
            {
                Object e = null;
                input.close();
                return;
            }
        }
        catch (IOException e) {
            System.err.println(errorMessage);
            e.printStackTrace();
        }
    }

    protected static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[0]);
    }

    public DelegatingURLClassLoader(URL[] codePath, URLContentFilter[] codeFilters, URL[] resourcePath, URLContentFilter[] resourceFilters, ClassLoader parent) {
        super(DelegatingURLClassLoader.mungeJarURLs(codePath), parent);
        int i;
        resourcePath = DelegatingURLClassLoader.mungeJarURLs(resourcePath);
        if (resourcePath != null && resourcePath.length > 0) {
            this.resourceLoader = new ResourceLoader(resourcePath);
        }
        if (codePath != null) {
            if (codeFilters == null || codeFilters.length != codePath.length) {
                throw new DelegatingLoaderException();
            }
            i = 0;
            while (i < codePath.length) {
                if (codeFilters[i] != null) {
                    this.filterTable.put(codePath[i], codeFilters[i]);
                }
                ++i;
            }
        }
        if (resourcePath != null) {
            if (resourceFilters == null || resourceFilters.length != resourcePath.length) {
                throw new DelegatingLoaderException();
            }
            i = 0;
            while (i < resourcePath.length) {
                if (resourceFilters[i] != null) {
                    this.filterTable.put(resourcePath[i], resourceFilters[i]);
                }
                ++i;
            }
        }
    }

    public void addURLs(URL[] codePath, URLContentFilter[] codeFilters, URL[] resourcePath, URLContentFilter[] resourceFilters) {
        URL path;
        int i;
        Set keys = this.filterTable.keySet();
        codePath = DelegatingURLClassLoader.mungeJarURLs(codePath);
        if ((resourcePath = DelegatingURLClassLoader.mungeJarURLs(resourcePath)) != null && resourcePath.length > 0) {
            this.resourceLoader = new ResourceLoader(resourcePath);
        }
        if (codePath != null) {
            if (codeFilters == null || codeFilters.length != codePath.length) {
                throw new DelegatingLoaderException();
            }
            i = 0;
            while (i < codePath.length) {
                path = codePath[i];
                if (!keys.contains(path)) {
                    this.addURL(path);
                    this.filterTable.put(path, codeFilters[i]);
                }
                ++i;
            }
        }
        if (resourcePath != null) {
            if (resourceFilters == null || resourceFilters.length != resourcePath.length) {
                throw new DelegatingLoaderException();
            }
            i = 0;
            while (i < resourcePath.length) {
                path = resourcePath[i];
                if (resourceFilters[i] != null && !keys.contains(path)) {
                    this.filterTable.put(path, resourceFilters[i]);
                }
                ++i;
            }
        }
    }

    private static URL mungeJarURL(URL url) {
        String file;
        if (url.getProtocol().equals("jar") && (file = url.getFile()).startsWith("file:")) {
            int ix = file.indexOf("!/");
            if (ix != -1) {
                file = file.substring(0, ix);
            }
            try {
                url = new URL(file);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return url;
    }

    private static URL[] mungeJarURLs(URL[] urls) {
        if (urls == null) {
            return null;
        }
        int i = 0;
        while (i < urls.length) {
            urls[i] = DelegatingURLClassLoader.mungeJarURL(urls[i]);
            ++i;
        }
        return urls;
    }

    protected Class checkClassVisibility(Class result, DelegatingURLClassLoader requestor, boolean inCache) {
        if (result == null) {
            return null;
        }
        if (this.isClassVisible(result, requestor)) {
            if (DEBUG && DEBUG_SHOW_SUCCESS && this.debugClass(result.getName())) {
                this.debug("found " + result.getName() + " in " + (inCache ? "cache" : this.getURLforClass(result).toExternalForm()));
            }
        } else {
            if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugClass(result.getName())) {
                this.debug("skip " + result.getName() + " in " + (inCache ? "cache" : this.getURLforClass(result).toExternalForm()));
            }
            return null;
        }
        return result;
    }

    protected URL checkResourceVisibility(String name, URL result, DelegatingURLClassLoader requestor) {
        if (result == null) {
            return null;
        }
        if (this.isResourceVisible(name, result, requestor)) {
            if (DEBUG && DEBUG_SHOW_SUCCESS && this.debugResource(name)) {
                this.debug("found " + result);
            }
        } else {
            if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugResource(name)) {
                this.debug("skip " + result);
            }
            result = null;
        }
        return result;
    }

    protected void debug(String s) {
        System.out.println(String.valueOf(this.toString()) + "^" + Integer.toHexString(Thread.currentThread().hashCode()) + " " + s);
    }

    protected boolean debugClass(String name) {
        if (this.debugLoader()) {
            return this.debugMatchesFilter(name, DEBUG_FILTER_CLASS);
        }
        return false;
    }

    protected void debugConstruction() {
        if (DEBUG && DEBUG_SHOW_CREATE && this.debugLoader()) {
            URL[] urls = this.getURLs();
            this.debug("Class Loader Created");
            this.debug("> baseURL=" + this.base);
            if (urls == null || urls.length == 0) {
                this.debug("> empty search path");
            } else {
                int i = 0;
                while (i < urls.length) {
                    this.debug("> searchURL=" + urls[i].toString());
                    URLContentFilter filter = (URLContentFilter)this.filterTable.get(urls[i]);
                    if (filter != null) {
                        this.debug(">    export=" + filter.toString());
                    }
                    ++i;
                }
            }
        }
    }

    protected String debugId() {
        return "";
    }

    protected boolean debugLoader() {
        return this.debugMatchesFilter(this.debugId(), DEBUG_FILTER_LOADER);
    }

    private boolean debugMatchesFilter(String name, String[] filter) {
        if (filter.length == 0) {
            return false;
        }
        int i = 0;
        while (i < filter.length) {
            if (filter[i].equals("*")) {
                return true;
            }
            if (name.startsWith(filter[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean debugNative(String name) {
        if (this.debugLoader()) {
            return this.debugMatchesFilter(name, DEBUG_FILTER_NATIVE);
        }
        return false;
    }

    protected boolean debugResource(String name) {
        if (this.debugLoader()) {
            return this.debugMatchesFilter(name, DEBUG_FILTER_RESOURCE);
        }
        return false;
    }

    protected Class findClassParents(String name, boolean resolve) {
        try {
            ClassLoader parent = this.getParent();
            if (parent == null) {
                return this.findSystemClass(name);
            }
            if (MONITOR_CLASSES) {
                ClassloaderStats.startLoadingClass("org.eclipse.core.boot", name);
            }
            Class<?> result = parent.loadClass(name);
            if (MONITOR_CLASSES) {
                ClassloaderStats.endLoadingClass("org.eclipse.core.boot", name, true);
            }
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (MONITOR_CLASSES) {
                ClassloaderStats.endLoadingClass("org.eclipse.core.boot", name, false);
            }
            return null;
        }
    }

    protected Class findClassParentsSelf(String name, boolean resolve, DelegatingURLClassLoader requestor, boolean checkParents) {
        if (this.prefixes == null || this.prefixes.length == 0) {
            return this.internalFindClassParentsSelf(name, resolve, requestor, checkParents);
        }
        int i = 0;
        while (i < this.prefixes.length) {
            if (name.startsWith(this.prefixes[i])) {
                if (DEBUG_PACKAGE_PREFIXES_SUCCESS) {
                    System.out.println("prefix: matched class: \"" + name + "\" with prefix: \"" + this.prefixes[i] + "\" loader: \"" + this.getPrefixId() + "\"");
                }
                return this.internalFindClassParentsSelf(name, resolve, requestor, checkParents);
            }
            ++i;
        }
        if (DEBUG_PACKAGE_PREFIXES_FAILURE) {
            System.out.println("prefix: no match for class: \"" + name + "\" loader: \"" + this.getPrefixId() + "\"");
        }
        if (checkParents) {
            return this.findClassParents(name, resolve);
        }
        return null;
    }

    protected abstract Class internalFindClassParentsSelf(String var1, boolean var2, DelegatingURLClassLoader var3, boolean var4);

    protected Class findClassPlatform(String name, boolean resolve, DelegatingURLClassLoader requestor, boolean checkParents) {
        PlatformClassLoader platform = PlatformClassLoader.getDefault();
        if (this == platform) {
            return null;
        }
        return platform.findClassParentsSelf(name, resolve, requestor, false);
    }

    protected Class findClassPrerequisites(String name, DelegatingURLClassLoader requestor, Vector seen) {
        if (this.imports == null) {
            return null;
        }
        if (seen == null) {
            seen = new Vector<DelegatingURLClassLoader>();
        }
        seen.addElement(this);
        DelegateLoader[] loaders = this.imports;
        int i = 0;
        while (i < loaders.length) {
            Class result = loaders[i].loadClass(name, this, requestor, seen);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    protected URL findClassResource(String name) {
        return super.findResource(name);
    }

    protected String findLibrary(String libName) {
        URL foundPath;
        URL[] searchList;
        if (libName.length() == 0) {
            return null;
        }
        if (libName.charAt(0) == '/' || libName.charAt(0) == '\\') {
            libName = libName.substring(1);
        }
        libName = System.mapLibraryName(libName);
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugNative(libName)) {
            this.debug("findLibrary(" + libName + ")");
        }
        if (this.base == null) {
            return null;
        }
        String libFileName = null;
        if (this.base.getProtocol().equals("file")) {
            libFileName = (String.valueOf(this.base.getFile()) + libName).replace('/', File.separatorChar);
        } else if (this.base.getProtocol().equals("platform") && (searchList = this.getSearchURLs(this.base)) != null && searchList.length != 0 && (foundPath = this.searchVariants(searchList, LIBRARY_VARIANTS, libName)) != null) {
            libFileName = foundPath.getFile();
        }
        if (libFileName == null) {
            return null;
        }
        return new File(libFileName).getAbsolutePath();
    }

    public URL findResource(String name) {
        return this.findResource(name, this, null);
    }

    protected URL findResource(String name, DelegatingURLClassLoader requestor, Vector seen) {
        if (seen != null && seen.contains(this)) {
            return null;
        }
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugResource(name)) {
            this.debug("findResource(" + name + ")");
        }
        URL result = super.findResource(name);
        if ((result = this.checkResourceVisibility(name, result, requestor)) != null) {
            return result;
        }
        if (this.resourceLoader != null) {
            result = this.resourceLoader.findResource(name);
            if ((result = this.checkResourceVisibility(name, result, requestor)) != null) {
                return result;
            }
        }
        if (this.imports != null) {
            if (seen == null) {
                seen = new Vector<DelegatingURLClassLoader>();
            }
            seen.addElement(this);
            int i = 0;
            while (i < this.imports.length && result == null) {
                result = this.imports[i].findResource(name, this, requestor, seen);
                ++i;
            }
        }
        return result;
    }

    public Enumeration findResources(String name) throws IOException {
        return this.findResources(name, this, null);
    }

    private Enumeration findResources(String name, DelegatingURLClassLoader requestor, Vector seen) {
        if (seen != null && seen.contains(this)) {
            return null;
        }
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugResource(name)) {
            this.debug("findResources(" + name + ")");
        }
        Enumeration<URL> e = null;
        try {
            e = super.findResources(name);
        }
        catch (IOException iOException) {}
        ResourceEnumeration result = new ResourceEnumeration(name, e, this, requestor);
        if (this.imports != null) {
            if (seen == null) {
                seen = new Vector<DelegatingURLClassLoader>();
            }
            seen.addElement(this);
            int i = 0;
            while (i < this.imports.length) {
                result.add(this.imports[i].findResources(name, this, requestor, seen));
                ++i;
            }
        }
        return result;
    }

    protected String getFileFromURL(URL target) {
        try {
            URL url = InternalBootLoader.resolve(target);
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                return url.getFile();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private URL[] getSearchURLs(URL base) {
        URL[] auxList = null;
        ArrayList<URL> result = new ArrayList<URL>();
        PlatformURLConnection c = null;
        try {
            c = (PlatformURLConnection)base.openConnection();
            result.add(c.getURLAsLocal());
        }
        catch (IOException iOException) {}
        try {
            auxList = c.getAuxillaryURLs();
            int auxLength = auxList == null ? 0 : auxList.length;
            int i = 0;
            while (i < auxLength) {
                try {
                    c = (PlatformURLConnection)auxList[i].openConnection();
                    result.add(c.getURLAsLocal());
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
        catch (IOException iOException) {}
        return result.toArray(new URL[result.size()]);
    }

    private URL searchVariants(URL[] basePaths, String[] variants, String path) {
        int i = 0;
        while (i < variants.length) {
            int j = 0;
            while (j < basePaths.length) {
                String fileName = String.valueOf(basePaths[j].getFile()) + variants[i] + path;
                File file = new File(fileName);
                if (!file.exists()) {
                    if (DEBUG && DEBUG_SHOW_FAILURE) {
                        this.debug("not found " + file.getAbsolutePath());
                    }
                } else {
                    if (DEBUG && DEBUG_SHOW_SUCCESS) {
                        this.debug("found " + path + " as " + file.getAbsolutePath());
                    }
                    try {
                        return new URL("file:" + fileName);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public URL getResource(String name) {
        URL result;
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugResource(name)) {
            this.debug("getResource(" + name + ")");
        }
        if ((result = super.getResource(name)) == null && DEBUG && DEBUG_SHOW_FAILURE && this.debugResource(name)) {
            this.debug("not found " + name);
        }
        return result;
    }

    public void setPackagePrefixes(String[] prefixes) {
        this.prefixes = prefixes;
    }

    public abstract String getPrefixId();

    private URL getURLforClass(Class clazz) {
        CodeSource cs;
        ProtectionDomain pd = clazz.getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            return cs.getLocation();
        }
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugClass(clazz.getName())) {
            this.debug("*** " + clazz.getName());
        }
        return null;
    }

    public void initializeImportedLoaders() {
    }

    boolean isClassVisible(Class clazz, DelegatingURLClassLoader requestor) {
        URL lib = this.getURLforClass(clazz);
        if (lib == null) {
            return true;
        }
        URLContentFilter filter = (URLContentFilter)this.filterTable.get(lib);
        if (filter == null) {
            if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugClass(clazz.getName())) {
                this.debug("*** Unable to find library filter for " + clazz.getName() + " from " + lib);
            }
            return false;
        }
        return filter.isClassVisible(clazz, this, requestor);
    }

    boolean isResourceVisible(String name, URL resource, DelegatingURLClassLoader requestor) {
        URL lib = null;
        String file = resource.getFile();
        try {
            lib = new URL(resource.getProtocol(), resource.getHost(), file.substring(0, file.length() - name.length()));
        }
        catch (MalformedURLException malformedURLException) {
            if (DEBUG) {
                this.debug("Unable to determine resource lib for " + name + " from " + resource);
            }
            return false;
        }
        URLContentFilter filter = (URLContentFilter)this.filterTable.get(lib);
        if (filter == null) {
            filter = (URLContentFilter)this.filterTable.get(DelegatingURLClassLoader.mungeJarURL(lib));
        }
        if (filter == null) {
            if (DEBUG) {
                this.debug("Unable to find library filter for " + name + " from " + lib);
            }
            return false;
        }
        return filter.isResourceVisible(name, this, requestor);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class result;
        if (DEBUG && DEBUG_SHOW_ACTIONS && this.debugClass(name)) {
            this.debug("loadClass(" + name + ")");
        }
        if ((result = this.loadClass(name, resolve, this, null, true)) == null) {
            if (DEBUG && DEBUG_SHOW_FAILURE && this.debugClass(name)) {
                this.debug("not found " + name);
            }
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private Class loadClass(String name, boolean resolve, DelegatingURLClassLoader requestor, Vector seen, boolean checkParents) {
        if (seen != null && seen.contains(this)) {
            return null;
        }
        Class result = this.findClassParentsSelf(name, resolve, requestor, checkParents);
        if (result == null) {
            result = this.findClassPlatform(name, resolve, requestor, false);
        }
        if (result == null) {
            result = this.findClassPrerequisites(name, requestor, seen);
        }
        if (result != null && resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    protected void setImportedLoaders(DelegateLoader[] loaders) {
        this.imports = loaders;
        if (DEBUG && DEBUG_SHOW_CREATE && this.debugLoader()) {
            this.debug("Imports");
            if (this.imports == null || this.imports.length == 0) {
                this.debug("> none");
            } else {
                int i = 0;
                while (i < this.imports.length) {
                    this.debug("> " + this.imports[i].loader.toString() + " export=" + this.imports[i].isExported);
                    ++i;
                }
            }
        }
    }

    public String toString() {
        return "Loader [" + this.debugId() + "]";
    }

    /*
     * Exception decompiling
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 61->64)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract String getClassloaderId();

    public InputStream getResourceAsStream(String name) {
        InputStream result = super.getResourceAsStream(name);
        if (MONITOR_BUNDLES && result != null && name.endsWith(".properties")) {
            ClassloaderStats.loadedBundle(this.getClassloaderId(), new BundleStats(this.getClassloaderId(), name, result));
            result = super.getResourceAsStream(name);
        }
        return result;
    }

    protected static class DelegateLoader {
        private DelegatingURLClassLoader loader;
        private boolean isExported;

        public DelegateLoader(DelegatingURLClassLoader loader, boolean isExported) {
            this.loader = loader;
            this.isExported = isExported;
        }

        public Class loadClass(String name, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor, Vector seen) {
            if (this.isExported || current == requestor) {
                return this.loader.loadClass(name, false, requestor, seen, false);
            }
            return null;
        }

        public URL findResource(String name, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor, Vector seen) {
            if (this.isExported || current == requestor) {
                return this.loader.findResource(name, requestor, seen);
            }
            return null;
        }

        public Enumeration findResources(String name, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor, Vector seen) {
            if (this.isExported || current == requestor) {
                return this.loader.findResources(name, requestor, seen);
            }
            return null;
        }
    }

    protected static class DelegatingLoaderException
    extends RuntimeException {
        Exception e = null;

        public DelegatingLoaderException() {
        }

        public DelegatingLoaderException(String message) {
            super(message);
        }

        public DelegatingLoaderException(String message, Exception e) {
            super(message);
            this.e = e;
        }

        public Throwable getException() {
            return this.e;
        }

        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        public void printStackTrace(PrintStream output) {
            PrintStream printStream = output;
            synchronized (printStream) {
                if (this.e != null) {
                    output.print("org.eclipse.core.internal.boot.DelegatingLoaderException: ");
                    this.e.printStackTrace(output);
                } else {
                    super.printStackTrace(output);
                }
            }
        }

        public void printStackTrace(PrintWriter output) {
            PrintWriter printWriter = output;
            synchronized (printWriter) {
                if (this.e != null) {
                    output.print("org.eclipse.core.internal.boot.DelegatingLoaderException: ");
                    this.e.printStackTrace(output);
                } else {
                    super.printStackTrace(output);
                }
            }
        }
    }
}

