/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.eclipse.core.internal.boot.PlatformURLHandlerFactory;
import org.eclipse.core.internal.runtime.PlatformURLFragmentConnection;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class PlatformURLPluginHandlerFactory
implements URLStreamHandlerFactory {
    IConfigurationElement ce = null;
    private static final String URL_HANDLERS_POINT = "org.eclipse.core.runtime.urlHandlers";
    private static final String PROTOCOL = "protocol";
    private static final String HANDLER = "class";

    public PlatformURLPluginHandlerFactory(IConfigurationElement ce) {
        this.ce = ce;
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = null;
        try {
            handler = (URLStreamHandler)this.ce.createExecutableExtension(HANDLER);
        }
        catch (CoreException coreException) {}
        return handler;
    }

    public static void startup() {
        IPluginRegistry r = Platform.getPluginRegistry();
        IConfigurationElement[] ce = r.getConfigurationElementsFor(URL_HANDLERS_POINT);
        int i = 0;
        while (i < ce.length) {
            String protocol = ce[i].getAttribute(PROTOCOL);
            if (protocol != null) {
                PlatformURLHandlerFactory.register((String)protocol, (URLStreamHandlerFactory)new PlatformURLPluginHandlerFactory(ce[i]));
            }
            ++i;
        }
        PlatformURLPluginConnection.startup();
        PlatformURLFragmentConnection.startup();
    }
}

