/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.model;

import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.Platform;

public abstract class PluginModelObject {
    private String name = null;
    private int flags = 0;
    static final int M_READ_ONLY = Integer.MIN_VALUE;

    protected void assertIsWriteable() {
        Assert.isTrue(!this.isReadOnly(), "Model is read-only");
    }

    public String getName() {
        return this.name;
    }

    public int getStartLine() {
        return (this.flags & Integer.MAX_VALUE) - 1;
    }

    public boolean isReadOnly() {
        return (this.flags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public void markReadOnly() {
        this.flags |= Integer.MIN_VALUE;
    }

    public void setLocalizedName(String value) {
        this.name = value;
        ((PluginRegistry)Platform.getPluginRegistry()).setCacheDirty();
    }

    public void setName(String value) {
        this.assertIsWriteable();
        this.name = value;
    }

    public void setStartLine(int lineNumber) {
        if (this.getStartLine() == -1) {
            this.flags = lineNumber + 1 | this.flags & Integer.MIN_VALUE;
        }
    }

    public String toString() {
        return this.getClass() + "(" + this.getName() + ")";
    }
}

