/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TableColumn
extends Item {
    Table parent;
    boolean resizable = true;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public int getWidth() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return 0;
        }
        int hwnd = this.parent.handle;
        return OS.SendMessage(hwnd, 4125, index, 0);
    }

    public void pack() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int hwnd = this.parent.handle;
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), this.text, true);
        int headerWidth = OS.SendMessage(hwnd, OS.LVM_GETSTRINGWIDTH, 0, buffer) + 10;
        if (this.image != null) {
            int margin = 0;
            if ((Widget.COMCTL32_MAJOR << 16 | Widget.COMCTL32_MINOR) >= 327760) {
                int hwndHeader = OS.SendMessage(hwnd, 4127, 0, 0);
                margin = OS.SendMessage(hwndHeader, 4629, 0, 0);
            } else {
                margin = OS.GetSystemMetrics(45) * 3;
            }
            Rectangle rect = this.image.getBounds();
            headerWidth += rect.width + margin * 2;
        }
        OS.SendMessage(hwnd, 4126, index, -1);
        int columnWidth = OS.SendMessage(hwnd, 4125, index, 0);
        if (headerWidth > columnWidth) {
            if (this.image == null) {
                OS.SendMessage(hwnd, 4126, index, -2);
            } else {
                OS.SendMessage(hwnd, 4126, index, headerWidth);
            }
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int fmt = 0;
        if ((this.style & 0x4000) == 16384) {
            fmt = 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            fmt = 2;
        }
        if ((this.style & 0x20000) == 131072) {
            fmt = 1;
        }
        int hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 1;
        lvColumn.fmt = fmt;
        OS.SendMessage(hwnd, OS.LVM_SETCOLUMN, index, lvColumn);
    }

    public void setImage(Image image) {
        int index;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setImage(image);
        int hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 17;
        lvColumn.fmt = 2048;
        lvColumn.iImage = this.parent.imageIndex(image);
        OS.SendMessage(hwnd, OS.LVM_SETCOLUMN, index, lvColumn);
        if (image == null) {
            lvColumn.mask = 1;
            if ((this.style & 0x4000) == 16384) {
                lvColumn.fmt = 0;
            }
            if ((this.style & 0x1000000) == 0x1000000) {
                lvColumn.fmt = 2;
            }
            if ((this.style & 0x20000) == 131072) {
                lvColumn.fmt = 1;
            }
            OS.SendMessage(hwnd, OS.LVM_SETCOLUMN, index, lvColumn);
        }
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        int hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 1;
        OS.SendMessage(hwnd, OS.LVM_GETCOLUMN, index, lvColumn);
        int hHeap = OS.GetProcessHeap();
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), string, true);
        int byteCount = buffer.length() * TCHAR.sizeof;
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(pszText, buffer, byteCount);
        lvColumn.mask |= 4;
        lvColumn.pszText = pszText;
        int result = OS.SendMessage(hwnd, OS.LVM_SETCOLUMN, index, lvColumn);
        if (pszText != 0) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (result == 0) {
            this.error(13);
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int hwnd = this.parent.handle;
        OS.SendMessage(hwnd, 4126, index, width);
    }
}

