/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.widgets.Control;

public class Accessible {
    Vector accessibleListeners = new Vector();
    Vector controlListeners = new Vector();
    AccessibleObject accessibleObject;
    Control control;

    Accessible(Control control, int widgetHandle) {
        this.control = control;
        AccessibleFactory.registerAccessible(this, widgetHandle);
    }

    public void addAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(listener);
    }

    public void addAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.controlListeners.addElement(listener);
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    AccessibleControlListener[] getControlListeners() {
        Object[] result = new AccessibleControlListener[this.controlListeners.size()];
        this.controlListeners.copyInto(result);
        return result;
    }

    AccessibleListener[] getAccessibleListeners() {
        Object[] result = new AccessibleListener[this.accessibleListeners.size()];
        this.accessibleListeners.copyInto(result);
        return result;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control, control.handle);
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    public void removeAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.controlListeners.remove(listener);
    }

    public void removeAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.remove(listener);
    }

    public void setFocus(int childID) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.setFocusToChild(childID);
        }
    }
}

