/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.internal.mozilla.GRE;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider2;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsString;

class AppFileLocProvider {
    static final String NS_GRE_DIR = "GreD";
    static final String NS_GRE_COMPONENT_DIR = "GreComsD";
    static final String NS_APP_DEFAULTS_50_DIR = "DefRt";
    static final String NS_APP_PREF_DEFAULTS_50_DIR = "PrfDef";
    static final String NS_APP_PROFILE_DEFAULTS_50_DIR = "profDef";
    static final String NS_APP_PROFILE_DEFAULTS_NLOC_50_DIR = "ProfDefNoLoc";
    static final String NS_APP_USER_PROFILES_ROOT_DIR = "DefProfRt";
    static final String NS_APP_RES_DIR = "ARes";
    static final String NS_APP_CHROME_DIR = "AChrom";
    static final String NS_APP_PLUGINS_DIR = "APlugns";
    static final String NS_APP_SEARCH_DIR = "SrchPlugns";
    static final String NS_APP_PLUGINS_DIR_LIST = "APluginsDL";
    static final String DEFAULTS_DIR_NAME = "defaults";
    static final String DEFAULTS_PREF_DIR_NAME = "pref";
    static final String DEFAULTS_PROFILE_DIR_NAME = "profile";
    static final String RES_DIR_NAME = "res";
    static final String CHROME_DIR_NAME = "chrome";
    static final String PLUGINS_DIR_NAME = "plugins";
    static final String SEARCH_DIR_NAME = "searchplugins";
    static final String COMPONENTS_DIR_NAME = "components";
    static final String NS_XPCOM_INIT_CURRENT_PROCESS_DIR = "MozBinD";
    static final String NS_XPCOM_CURRENT_PROCESS_DIR = "XCurProcD";
    static final String NS_XPCOM_COMPONENT_DIR = "ComsD";
    static final String NS_OS_CURRENT_PROCESS_DIR = "CurProcD";
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath = GRE.mozillaPath;
    String grePath = GRE.grePath;

    public AppFileLocProvider() {
        if (this.mozillaPath == null) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467259));
        }
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public int method0(int[] args) {
                return AppFileLocProvider.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] args) {
                return AppFileLocProvider.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 3;
        this.directoryServiceProvider = new XPCOMObject(nArray2){

            public int method0(int[] args) {
                return AppFileLocProvider.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] args) {
                return AppFileLocProvider.this.Release();
            }

            public int method3(int[] args) {
                return AppFileLocProvider.this.getFile(args[0], args[1], args[2]);
            }
        };
        int[] nArray3 = new int[5];
        nArray3[0] = 2;
        nArray3[3] = 3;
        nArray3[4] = 2;
        this.directoryServiceProvider2 = new XPCOMObject(nArray3){

            public int method0(int[] args) {
                return AppFileLocProvider.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] args) {
                return AppFileLocProvider.this.Release();
            }

            public int method3(int[] args) {
                return AppFileLocProvider.this.getFile(args[0], args[1], args[2]);
            }

            public int method4(int[] args) {
                return AppFileLocProvider.this.getFiles(args[0], args[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    int getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    int queryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove((nsID)guid, (int)riid, (int)16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.supports.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIDirectoryServiceProvider.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.directoryServiceProvider.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIDirectoryServiceProvider2.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.directoryServiceProvider2.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove((int)ppvObject, (int[])new int[1], (int)4);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int getFiles(int str, int nsISimpleEnumerator) {
        int rc = -2147467259;
        int length = XPCOM.strlen((int)str);
        byte[] dest = new byte[length];
        XPCOM.memmove((byte[])dest, (int)str, (int)length);
        String prop = new String(dest);
        XPCOM.memmove((int)nsISimpleEnumerator, (int[])new int[1], (int)4);
        nsILocalFile localFile = null;
        if (NS_APP_PLUGINS_DIR_LIST.equals(prop)) {
            if (this.mozillaPath == null) {
                return -2147467259;
            }
            if (this.mozillaPath.length() <= 0) {
                return -2147467259;
            }
            String path = new String(this.mozillaPath);
            int[] retVal = new int[1];
            rc = XPCOM.NS_NewLocalFile((String)path, (boolean)true, (int[])retVal);
            if (rc == 0 && retVal[0] == 0) {
                rc = -2147467261;
            }
            if (rc == 0) {
                localFile = new nsILocalFile(retVal[0]);
            }
            nsString node = new nsString(PLUGINS_DIR_NAME);
            rc = localFile.Append(node.getAddress());
            node.dispose();
        }
        if (rc == 0) {
            int[] retVal = new int[1];
            rc = XPCOM.NS_NewSingletonEnumerator((int)localFile.getAddress(), (int[])retVal);
            if (rc == 0 && retVal[0] == 0) {
                rc = -2147467261;
            }
            if (rc == 0) {
                XPCOM.memmove((int)nsISimpleEnumerator, (int[])retVal, (int)4);
            }
        }
        if (localFile != null) {
            localFile.Release();
        }
        return rc;
    }

    int getFile(int str, int persistent, int nsFile) {
        nsString node;
        int[] retVal;
        int rc = -2147467259;
        int length = XPCOM.strlen((int)str);
        byte[] dest = new byte[length];
        XPCOM.memmove((byte[])dest, (int)str, (int)length);
        String prop = new String(dest);
        XPCOM.memmove((int)persistent, (int[])new int[]{1}, (int)4);
        XPCOM.memmove((int)nsFile, (int[])new int[1], (int)4);
        nsILocalFile localFile = null;
        if (NS_GRE_DIR.equals(prop) || NS_GRE_COMPONENT_DIR.equals(prop)) {
            if (this.grePath == null || this.grePath.length() == 0) {
                return -2147467259;
            }
            retVal = new int[1];
            rc = XPCOM.NS_NewLocalFile((String)this.grePath, (boolean)true, (int[])retVal);
            if (rc == 0 && retVal[0] == 0) {
                rc = -2147467261;
            }
            if (rc == 0) {
                localFile = new nsILocalFile(retVal[0]);
                if (NS_GRE_COMPONENT_DIR.equals(prop)) {
                    node = new nsString(COMPONENTS_DIR_NAME);
                    rc = localFile.Append(node.getAddress());
                    node.dispose();
                }
            }
        } else if (NS_XPCOM_INIT_CURRENT_PROCESS_DIR.equals(prop) || NS_OS_CURRENT_PROCESS_DIR.equals(prop) || NS_XPCOM_COMPONENT_DIR.equals(prop)) {
            if (this.mozillaPath == null || this.mozillaPath.length() == 0) {
                return -2147467259;
            }
            retVal = new int[1];
            rc = XPCOM.NS_NewLocalFile((String)this.mozillaPath, (boolean)true, (int[])retVal);
            if (rc == 0 && retVal[0] == 0) {
                rc = -2147467261;
            }
            if (rc == 0) {
                localFile = new nsILocalFile(retVal[0]);
                if (NS_XPCOM_COMPONENT_DIR.equals(prop)) {
                    node = new nsString(COMPONENTS_DIR_NAME);
                    rc = localFile.Append(node.getAddress());
                    node.dispose();
                }
            }
        }
        if (localFile != null && rc == 0) {
            int[] result = new int[1];
            int rc1 = localFile.QueryInterface(nsIFile.NS_IFILE_IID, result);
            if (rc1 != 0 || result[0] == 0) {
                rc1 = -2147467262;
            } else {
                XPCOM.memmove((int)nsFile, (int[])result, (int)4);
            }
        }
        if (localFile != null) {
            localFile.Release();
        }
        return rc;
    }
}

