/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkVisual;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkStyle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    Event[] eventQueue;
    Callback eventCallback;
    GdkEventButton gdkEvent = new GdkEventButton();
    int eventProc;
    int windowProc2;
    int windowProc3;
    int windowProc4;
    int windowProc5;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME = "SWT";
    int freeSlot;
    int[] indexTable;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    Control imControl;
    int preeditWindow;
    int preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    Callback windowTimerCallback;
    int windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    int caretProc;
    int mouseHoverId;
    int mouseHoverHandle;
    int mouseHoverProc;
    Callback mouseHoverCallback;
    int menuPositionProc;
    Callback menuPositionCallback;
    int shellMapProc;
    Callback shellMapCallback;
    int[] treeSelection;
    int treeSelectionLength;
    int treeSelectionProc;
    Callback treeSelectionCallback;
    int cellDataProc;
    Callback cellDataCallback;
    int dragStartX;
    int dragStartY;
    boolean dragging;
    int defaultFont;
    GdkColor COLOR_WIDGET_DARK_SHADOW;
    GdkColor COLOR_WIDGET_NORMAL_SHADOW;
    GdkColor COLOR_WIDGET_LIGHT_SHADOW;
    GdkColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    GdkColor COLOR_WIDGET_BACKGROUND;
    GdkColor COLOR_WIDGET_FOREGROUND;
    GdkColor COLOR_WIDGET_BORDER;
    GdkColor COLOR_LIST_FOREGROUND;
    GdkColor COLOR_LIST_BACKGROUND;
    GdkColor COLOR_LIST_SELECTION;
    GdkColor COLOR_LIST_SELECTION_TEXT;
    GdkColor COLOR_TEXT_FOREGROUND;
    GdkColor COLOR_TEXT_BACKGROUND;
    GdkColor COLOR_INFO_BACKGROUND;
    GdkColor COLOR_INFO_FOREGROUND;
    GdkColor COLOR_TITLE_FOREGROUND;
    GdkColor COLOR_TITLE_BACKGROUND;
    GdkColor COLOR_TITLE_BACKGROUND_GRADIENT;
    GdkColor COLOR_TITLE_INACTIVE_FOREGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    Menu[] popups;
    int popupTime;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final int DOUBLE_CLICK_TIME = 250;
    static final int MAJOR = 2;
    static final int MINOR = 0;
    static final int MICRO = 6;
    Object data;
    String[] keys;
    Object[] values;
    int borderTrimWidth = 4;
    int borderTrimHeight = 4;
    int resizeTrimWidth = 6;
    int resizeTrimHeight = 6;
    int titleBorderTrimWidth = 5;
    int titleBorderTrimHeight = 28;
    int titleResizeTrimWidth = 6;
    int titleResizeTrimHeight = 29;
    int titleTrimWidth = 0;
    int titleTrimHeight = 23;

    static {
        byte[] buffer = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX", true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string((byte[])buffer);
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65364, 0x1000002}, {65361, 0x1000003}, {65363, 0x1000004}, {65365, 0x1000005}, {65366, 0x1000006}, {65360, 0x1000007}, {65367, 0x1000008}, {65379, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65307, 27}, {65385, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}};
        Displays = new Display[4];
        Device.DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        Device.CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addMouseHoverTimeout(int handle) {
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove((int)this.mouseHoverId);
        }
        this.mouseHoverId = OS.gtk_timeout_add((int)400, (int)this.mouseHoverProc, (int)handle);
        this.mouseHoverHandle = handle;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addWidget(int handle, Widget widget) {
        if (handle == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            int length = this.freeSlot + 1024;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(this.indexTable, 0, newIndexTable, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, newWidgetTable, 0, this.freeSlot);
            int i = this.freeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            this.indexTable = newIndexTable;
            this.widgetTable = newWidgetTable;
        }
        int index = this.freeSlot + 1;
        OS.g_object_set_qdata((int)handle, (int)SWT_OBJECT_INDEX, (int)index);
        int oldSlot = this.freeSlot;
        this.freeSlot = this.indexTable[oldSlot];
        this.indexTable[oldSlot] = -2;
        this.widgetTable[oldSlot] = widget;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        OS.gdk_beep();
        OS.gdk_flush();
    }

    protected void checkDevice() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    static synchronized void checkDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] != null && Display.Displays[i].thread == thread) {
                SWT.error(22);
            }
            ++i;
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread);
        this.createDisplay(data);
        this.register();
        if (Default == null) {
            Default = this;
        }
    }

    synchronized void createDisplay(DeviceData data) {
        OS.gtk_set_locale();
        if (!OS.gtk_init_check((int[])new int[1], null)) {
            SWT.error(45);
            return;
        }
        OS.gtk_widget_set_default_direction((int)1);
        OS.gdk_rgb_init();
        int ptr = OS.gtk_check_version((int)2, (int)0, (int)6);
        if (ptr != 0) {
            int length = OS.strlen((int)ptr);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)ptr, (int)length);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs(null, buffer)));
            System.out.println("***WARNING: SWT requires GTK 2.0.6");
            int major = OS.gtk_major_version();
            int minor = OS.gtk_minor_version();
            int micro = OS.gtk_micro_version();
            System.out.println("***WARNING: Detected: " + major + "." + minor + "." + micro);
        }
        byte[] buffer = Converter.wcsToMbcs(null, APP_NAME, true);
        OS.gdk_set_program_class((byte[])buffer);
        this.eventCallback = new Callback(this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        if (this.eventProc == 0) {
            SWT.error(3);
        }
        OS.gdk_event_handler_set((int)this.eventProc, (int)0, (int)0);
    }

    synchronized void deregister() {
        int i = 0;
        while (i < Displays.length) {
            if (this == Displays[i]) {
                Display.Displays[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        this.deregister();
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public static synchronized Display findDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++i;
        }
        return null;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    int eventProc(int event, int data) {
        OS.memmove((GdkEventButton)this.gdkEvent, (int)event, (int)64);
        switch (this.gdkEvent.type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Control control = null;
                boolean forward = false;
                int[] user_data = new int[1];
                int window = this.gdkEvent.window;
                do {
                    Widget widget;
                    OS.gdk_window_get_user_data((int)window, (int[])user_data);
                    int handle = user_data[0];
                    if (handle == 0 || (widget = this.getWidget(handle)) == null || !(widget instanceof Control)) continue;
                    control = (Control)widget;
                    if (control.isEnabled()) break;
                    forward = true;
                } while ((window = OS.gdk_window_get_parent((int)window)) != 0);
                if (window == 0 || !forward || control == null) break;
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove((GdkEventButton)gdkEventButton, (int)event, (int)64);
                int oldWindow = gdkEventButton.window;
                double oldX = gdkEventButton.x;
                double oldY = gdkEventButton.y;
                int eventHandle = control.eventHandle();
                gdkEventButton.window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
                int[] origin_x = new int[1];
                int[] origin_y = new int[1];
                OS.gdk_window_get_origin((int)gdkEventButton.window, (int[])origin_x, (int[])origin_y);
                gdkEventButton.x = gdkEventButton.x_root - (double)origin_x[0];
                gdkEventButton.y = gdkEventButton.y_root - (double)origin_y[0];
                OS.memmove((int)event, (GdkEventButton)gdkEventButton, (int)64);
                OS.gtk_main_do_event((int)event);
                gdkEventButton.window = oldWindow;
                gdkEventButton.x = oldX;
                gdkEventButton.y = oldY;
                OS.memmove((int)event, (GdkEventButton)gdkEventButton, (int)64);
                return 0;
            }
        }
        OS.gtk_main_do_event((int)event);
        return 0;
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            if (shells[i].hasFocus) {
                return shells[i];
            }
            ++i;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, OS.gdk_screen_width(), OS.gdk_screen_height());
    }

    public static synchronized Display getCurrent() {
        Thread current = Thread.currentThread();
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == current) {
                return display;
            }
            ++i;
        }
        return null;
    }

    public Control getCursorControl() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        int window = OS.gdk_window_at_pointer((int[])x, (int[])y);
        if (window == 0) {
            return null;
        }
        int[] user_data = new int[1];
        OS.gdk_window_get_user_data((int)window, (int[])user_data);
        int handle = user_data[0];
        if (handle == 0) {
            return null;
        }
        do {
            Control control;
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control) || !(control = (Control)widget).getEnabled()) continue;
            return control;
        } while ((handle = OS.gtk_widget_get_parent((int)handle)) != 0);
        return null;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, null);
        return new Point(x[0], y[0]);
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public Point getDPI() {
        this.checkDevice();
        int widthMM = OS.gdk_screen_width_mm();
        int width = OS.gdk_screen_width();
        int dpi = Compatibility.round(254 * width, widthMM * 10);
        return new Point(dpi, dpi);
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return 250;
    }

    public Control getFocusControl() {
        this.checkDevice();
        Shell shell = this.getActiveShell();
        if (shell == null) {
            return null;
        }
        int shellHandle = shell.shellHandle;
        int handle = OS.gtk_window_get_focus((int)shellHandle);
        if (handle == 0) {
            return null;
        }
        do {
            Control window;
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control) || !(window = (Control)widget).getEnabled()) continue;
            return window;
        } while ((handle = OS.gtk_widget_get_parent((int)handle)) != 0);
        return null;
    }

    public int getDepth() {
        this.checkDevice();
        GdkVisual visual = new GdkVisual();
        OS.memmove((GdkVisual)visual, (int)OS.gdk_visual_get_system());
        return visual.depth;
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    int getLastEventTime() {
        return OS.gtk_get_current_event_time();
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        int monitorCount;
        this.checkDevice();
        Monitor[] monitors = null;
        int screen = OS.gdk_screen_get_default();
        if (screen != 0 && (monitorCount = OS.gdk_screen_get_n_monitors((int)screen)) > 0) {
            monitors = new Monitor[monitorCount];
            GdkRectangle dest = new GdkRectangle();
            int i = 0;
            while (i < monitorCount) {
                OS.gdk_screen_get_monitor_geometry((int)screen, (int)i, (GdkRectangle)dest);
                Monitor monitor = new Monitor();
                monitor.handle = i;
                monitor.x = dest.x;
                monitor.y = dest.y;
                monitor.width = dest.width;
                monitor.height = dest.height;
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
                monitors[i] = monitor;
                ++i;
            }
        }
        if (monitors == null) {
            Monitor monitor = new Monitor();
            Rectangle bounds = this.getBounds();
            monitor.x = bounds.x;
            monitor.y = bounds.y;
            monitor.width = bounds.width;
            monitor.height = bounds.height;
            monitor.clientX = monitor.x;
            monitor.clientY = monitor.y;
            monitor.clientWidth = monitor.width;
            monitor.clientHeight = monitor.height;
            monitors = new Monitor[]{monitor};
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitors = this.getMonitors();
        return monitors[0];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int length = 0;
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                ++length;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[length];
        int i2 = 0;
        while (i2 < this.widgetTable.length) {
            Widget widget = this.widgetTable[i2];
            if (widget != null && widget instanceof Shell) {
                int j = 0;
                while (j < index) {
                    if (result[j] == widget) break;
                    ++j;
                }
                if (j == index) {
                    result[index++] = (Shell)widget;
                }
            }
            ++i2;
        }
        if (index == length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        GdkColor gdkColor = null;
        switch (id) {
            case 28: {
                gdkColor = this.COLOR_INFO_FOREGROUND;
                break;
            }
            case 29: {
                gdkColor = this.COLOR_INFO_BACKGROUND;
                break;
            }
            case 30: {
                gdkColor = this.COLOR_TITLE_FOREGROUND;
                break;
            }
            case 31: {
                gdkColor = this.COLOR_TITLE_BACKGROUND;
                break;
            }
            case 32: {
                gdkColor = this.COLOR_TITLE_BACKGROUND_GRADIENT;
                break;
            }
            case 33: {
                gdkColor = this.COLOR_TITLE_INACTIVE_FOREGROUND;
                break;
            }
            case 34: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND;
                break;
            }
            case 35: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
                break;
            }
            case 17: {
                gdkColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                gdkColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                gdkColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                gdkColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                gdkColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                gdkColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                gdkColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                gdkColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                gdkColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                gdkColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                gdkColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        if (gdkColor == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new(this, gdkColor);
    }

    void initializeSystemResources() {
        int shellHandle = OS.gtk_window_new((int)0);
        if (shellHandle == 0) {
            SWT.error(2);
        }
        OS.gtk_widget_realize((int)shellHandle);
        int tooltipShellHandle = OS.gtk_window_new((int)1);
        if (tooltipShellHandle == 0) {
            SWT.error(2);
        }
        byte[] gtk_tooltips = Converter.wcsToMbcs(null, "gtk-tooltips", true);
        OS.gtk_widget_set_name((int)tooltipShellHandle, (byte[])gtk_tooltips);
        OS.gtk_widget_realize((int)tooltipShellHandle);
        GtkStyle style = new GtkStyle();
        OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)shellHandle));
        GtkStyle tooltipStyle = new GtkStyle();
        OS.memmove((GtkStyle)tooltipStyle, (int)OS.gtk_widget_get_style((int)tooltipShellHandle));
        this.defaultFont = OS.pango_font_description_copy((int)style.font_desc);
        GdkColor gdkColor = new GdkColor();
        gdkColor.pixel = style.black_pixel;
        gdkColor.red = style.black_red;
        gdkColor.green = style.black_green;
        gdkColor.blue = style.black_blue;
        this.COLOR_WIDGET_DARK_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.dark0_pixel;
        gdkColor.red = style.dark0_red;
        gdkColor.green = style.dark0_green;
        gdkColor.blue = style.dark0_blue;
        this.COLOR_WIDGET_NORMAL_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.bg0_pixel;
        gdkColor.red = style.bg0_red;
        gdkColor.green = style.bg0_green;
        gdkColor.blue = style.bg0_blue;
        this.COLOR_WIDGET_LIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.light0_pixel;
        gdkColor.red = style.light0_red;
        gdkColor.green = style.light0_green;
        gdkColor.blue = style.light0_blue;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.fg0_pixel;
        gdkColor.red = style.fg0_red;
        gdkColor.green = style.fg0_green;
        gdkColor.blue = style.fg0_blue;
        this.COLOR_WIDGET_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.bg0_pixel;
        gdkColor.red = style.bg0_red;
        gdkColor.green = style.bg0_green;
        gdkColor.blue = style.bg0_blue;
        this.COLOR_WIDGET_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.text0_pixel;
        gdkColor.red = style.text0_red;
        gdkColor.green = style.text0_green;
        gdkColor.blue = style.text0_blue;
        this.COLOR_TEXT_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.base0_pixel;
        gdkColor.red = style.base0_red;
        gdkColor.green = style.base0_green;
        gdkColor.blue = style.base0_blue;
        this.COLOR_TEXT_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.text0_pixel;
        gdkColor.red = style.text0_red;
        gdkColor.green = style.text0_green;
        gdkColor.blue = style.text0_blue;
        this.COLOR_LIST_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.base0_pixel;
        gdkColor.red = style.base0_red;
        gdkColor.green = style.base0_green;
        gdkColor.blue = style.base0_blue;
        this.COLOR_LIST_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.text3_pixel;
        gdkColor.red = style.text3_red;
        gdkColor.green = style.text3_green;
        gdkColor.blue = style.text3_blue;
        this.COLOR_LIST_SELECTION_TEXT = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.base3_pixel;
        gdkColor.red = style.base3_red;
        gdkColor.green = style.base3_green;
        gdkColor.blue = style.base3_blue;
        this.COLOR_LIST_SELECTION = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = tooltipStyle.fg0_pixel;
        gdkColor.red = tooltipStyle.fg0_red;
        gdkColor.green = tooltipStyle.fg0_green;
        gdkColor.blue = tooltipStyle.fg0_blue;
        this.COLOR_INFO_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = tooltipStyle.bg0_pixel;
        gdkColor.red = tooltipStyle.bg0_red;
        gdkColor.green = tooltipStyle.bg0_green;
        gdkColor.blue = tooltipStyle.bg0_blue;
        this.COLOR_INFO_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.bg3_pixel;
        gdkColor.red = style.bg3_red;
        gdkColor.green = style.bg3_green;
        gdkColor.blue = style.bg3_blue;
        this.COLOR_TITLE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.fg3_pixel;
        gdkColor.red = style.fg3_red;
        gdkColor.green = style.fg3_green;
        gdkColor.blue = style.fg3_blue;
        this.COLOR_TITLE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.light3_pixel;
        gdkColor.red = style.light3_red;
        gdkColor.green = style.light3_green;
        gdkColor.blue = style.light3_blue;
        this.COLOR_TITLE_BACKGROUND_GRADIENT = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.bg4_pixel;
        gdkColor.red = style.bg4_red;
        gdkColor.green = style.bg4_green;
        gdkColor.blue = style.bg4_blue;
        this.COLOR_TITLE_INACTIVE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.fg4_pixel;
        gdkColor.red = style.fg4_red;
        gdkColor.green = style.fg4_green;
        gdkColor.blue = style.fg4_blue;
        this.COLOR_TITLE_INACTIVE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        gdkColor.pixel = style.light4_pixel;
        gdkColor.red = style.light4_red;
        gdkColor.green = style.light4_green;
        gdkColor.blue = style.light4_blue;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = gdkColor;
        OS.gtk_widget_destroy((int)tooltipShellHandle);
        OS.gtk_widget_destroy((int)shellHandle);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return Font.gtk_new(this, this.defaultFont);
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    Widget getWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        int index = OS.g_object_get_qdata((int)handle, (int)SWT_OBJECT_INDEX) - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            return this.widgetTable[index];
        }
        return null;
    }

    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSystemResources();
        this.initializeWidgetTable();
    }

    void initializeCallbacks() {
        this.windowCallback2 = new Callback(this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (this.windowProc2 == 0) {
            SWT.error(3);
        }
        this.windowCallback3 = new Callback(this, "windowProc", 3);
        this.windowProc3 = this.windowCallback3.getAddress();
        if (this.windowProc3 == 0) {
            SWT.error(3);
        }
        this.windowCallback4 = new Callback(this, "windowProc", 4);
        this.windowProc4 = this.windowCallback4.getAddress();
        if (this.windowProc4 == 0) {
            SWT.error(3);
        }
        this.windowCallback5 = new Callback(this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        if (this.windowProc5 == 0) {
            SWT.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.menuPositionCallback = new Callback(this, "menuPositionProc", 5);
        this.menuPositionProc = this.menuPositionCallback.getAddress();
        if (this.menuPositionProc == 0) {
            this.error(3);
        }
        this.shellMapCallback = new Callback(this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        if (this.shellMapProc == 0) {
            this.error(3);
        }
        this.treeSelectionCallback = new Callback(this, "treeSelectionProc", 4);
        this.treeSelectionProc = this.treeSelectionCallback.getAddress();
        if (this.treeSelectionProc == 0) {
            this.error(3);
        }
        this.cellDataCallback = new Callback(this, "cellDataProc", 5);
        this.cellDataProc = this.cellDataCallback.getAddress();
        if (this.cellDataProc == 0) {
            this.error(3);
        }
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int i = 0;
        while (i < 1023) {
            this.indexTable[i] = i + 1;
            ++i;
        }
        this.indexTable[1023] = -1;
    }

    public void internal_dispose_GC(int gdkGC, GCData data) {
        OS.g_object_unref((int)gdkGC);
    }

    public int internal_new_GC(GCData data) {
        int root;
        int gdkGC;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((gdkGC = OS.gdk_gc_new((int)(root = OS.GDK_ROOT_PARENT()))) == 0) {
            SWT.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.drawable = root;
            data.font = this.defaultFont;
        }
        return gdkGC;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        int[] origin_y;
        int[] origin_x;
        int window;
        int eventHandle;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from != null) {
            eventHandle = from.eventHandle();
            OS.gtk_widget_realize((int)eventHandle);
            window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
            point.x += origin_x[0];
            point.y += origin_y[0];
        }
        if (to != null) {
            eventHandle = to.eventHandle();
            OS.gtk_widget_realize((int)eventHandle);
            window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
            point.x -= origin_x[0];
            point.y -= origin_y[0];
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    int menuPositionProc(int menu, int x, int y, int push_in, int user_data) {
        Widget widget = this.getWidget(menu);
        if (widget == null) {
            return 0;
        }
        return widget.menuPositionProc(menu, x, y, push_in, user_data);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        int[] origin_y;
        int[] origin_x;
        int window;
        int eventHandle;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from != null) {
            eventHandle = from.eventHandle();
            OS.gtk_widget_realize((int)eventHandle);
            window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
            rect.x += origin_x[0];
            rect.y += origin_y[0];
        }
        if (to != null) {
            eventHandle = to.eventHandle();
            OS.gtk_widget_realize((int)eventHandle);
            window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
            rect.x -= origin_x[0];
            rect.y -= origin_y[0];
        }
        return rect;
    }

    int mouseHoverProc(int handle) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.hoverProc(handle);
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runPopups();
        int status = OS.gtk_events_pending();
        if (status != 0) {
            OS.gtk_main_iteration();
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages();
    }

    synchronized void register() {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] == null) {
                Display.Displays[i] = this;
                return;
            }
            ++i;
        }
        Display[] newDisplays = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
        newDisplays[Display.Displays.length] = this;
        Displays = newDisplays;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        if (this.preeditWindow != 0) {
            OS.gtk_widget_destroy((int)this.preeditWindow);
        }
        this.imControl = null;
        this.menuPositionCallback.dispose();
        this.menuPositionCallback = null;
        this.menuPositionProc = 0;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0;
        this.treeSelectionCallback.dispose();
        this.treeSelectionCallback = null;
        this.treeSelectionProc = 0;
        this.cellDataCallback.dispose();
        this.cellDataCallback = null;
        this.cellDataProc = 0;
        if (this.caretId != 0) {
            OS.gtk_timeout_remove((int)this.caretId);
        }
        this.caretProc = 0;
        this.caretId = 0;
        this.caretCallback.dispose();
        this.caretCallback = null;
        if (this.timerIds != null) {
            int i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0) {
                    OS.gtk_timeout_remove((int)this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove((int)this.mouseHoverId);
        }
        this.mouseHoverProc = 0;
        this.mouseHoverHandle = 0;
        this.mouseHoverId = 0;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        this.thread = null;
        this.windowProc5 = 0;
        this.windowProc4 = 0;
        this.windowProc3 = 0;
        this.windowProc2 = 0;
        if (this.defaultFont != 0) {
            OS.pango_font_description_free((int)this.defaultFont);
        }
        this.defaultFont = 0;
        this.COLOR_INFO_BACKGROUND = null;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        OS.gdk_event_handler_set((int)0, (int)0, (int)0);
        this.eventCallback.dispose();
        this.eventCallback = null;
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    void removeMouseHoverTimeout(int handle) {
        if (handle != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove((int)this.mouseHoverId);
        }
        this.mouseHoverHandle = 0;
        this.mouseHoverId = 0;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    Widget removeWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        Widget widget = null;
        int index = OS.g_object_get_qdata((int)handle, (int)SWT_OBJECT_INDEX) - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            widget = this.widgetTable[index];
            this.widgetTable[index] = null;
            this.indexTable[index] = this.freeSlot;
            this.freeSlot = index;
            OS.g_object_set_qdata((int)handle, (int)SWT_OBJECT_INDEX, (int)0);
        }
        return widget;
    }

    boolean runAsyncMessages() {
        return this.synchronizer.runAsyncMessages();
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.sendEvent(event);
            if (event.type != 5) continue;
            OS.gdk_window_get_pointer((int)0, null, null, null);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            menu._setVisible(true);
            result = true;
        }
        this.popups = null;
        return result;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages();
        }
        this.synchronizer = synchronizer;
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0) {
            this.preeditWindow = OS.gtk_window_new((int)1);
            if (this.preeditWindow == 0) {
                this.error(2);
            }
            this.preeditLabel = OS.gtk_label_new(null);
            if (this.preeditLabel == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)this.preeditWindow, (int)this.preeditLabel);
            OS.gtk_widget_show((int)this.preeditLabel);
        }
        int[] preeditString = new int[1];
        int[] pangoAttrs = new int[1];
        int imHandle = control.imHandle();
        OS.gtk_im_context_get_preedit_string((int)imHandle, (int[])preeditString, (int[])pangoAttrs, null);
        if (preeditString[0] != 0 && OS.strlen((int)preeditString[0]) > 0) {
            OS.gtk_widget_modify_bg((int)this.preeditWindow, (int)0, (GdkColor)control.getBackgroundColor());
            OS.gtk_widget_modify_fg((int)this.preeditLabel, (int)0, (GdkColor)control.getForegroundColor());
            OS.gtk_widget_modify_font((int)this.preeditLabel, (int)control.getFontDescription());
            if (pangoAttrs[0] != 0) {
                OS.gtk_label_set_attributes((int)this.preeditLabel, (int)pangoAttrs[0]);
            }
            OS.gtk_label_set_text((int)this.preeditLabel, (int)preeditString[0]);
            Point point = control.toDisplay(control.getIMCaretPos());
            OS.gtk_window_move((int)this.preeditWindow, (int)point.x, (int)point.y);
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)this.preeditLabel, (GtkRequisition)requisition);
            OS.gtk_window_resize((int)this.preeditWindow, (int)requisition.width, (int)requisition.height);
            OS.gtk_widget_show((int)this.preeditWindow);
        } else {
            OS.gtk_widget_hide((int)this.preeditWindow);
        }
        if (preeditString[0] != 0) {
            OS.g_free((int)preeditString[0]);
        }
        if (pangoAttrs[0] != 0) {
            OS.pango_attr_list_unref((int)pangoAttrs[0]);
        }
    }

    public boolean sleep() {
        this.checkDevice();
        while (this.getMessageCount() == 0 && OS.gtk_events_pending() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int timerId;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            OS.gtk_timeout_remove((int)this.timerIds[index]);
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (milliseconds < 0) {
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((timerId = OS.gtk_timeout_add((int)milliseconds, (int)this.timerProc, (int)index)) != 0) {
            this.timerIds[index] = timerId;
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int index) {
        if (this.timerList == null) {
            return 0;
        }
        if (index >= 0 && index < this.timerList.length) {
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (runnable != null) {
                runnable.run();
            }
        }
        return 0;
    }

    int caretProc(int clientData) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            this.caretId = OS.gtk_timeout_add((int)blinkRate, (int)this.caretProc, (int)0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    int cellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0;
        }
        return widget.cellDataProc(tree_column, cell, tree_model, iter, data);
    }

    int treeSelectionProc(int model, int path, int iter, int data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0;
        }
        return widget.treeSelectionProc(model, path, iter, this.treeSelection, this.treeSelectionLength++);
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.gtk_timeout_remove((int)this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int blinkRate = this.currentCaret.blinkRate;
        this.caretId = OS.gtk_timeout_add((int)blinkRate, (int)this.caretProc, (int)0);
    }

    int shellMapProc(int handle, int arg0, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.shellMapProc(handle, arg0, user_data);
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        OS.gdk_flush();
        while (OS.gtk_events_pending() != 0) {
            OS.gtk_main_iteration();
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
    }

    int windowProc(int handle, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, user_data);
    }

    int windowProc(int handle, int arg0, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, user_data);
    }

    int windowProc(int handle, int arg0, int arg1, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, arg1, user_data);
    }

    int windowProc(int handle, int arg0, int arg1, int arg2, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, arg1, arg2, user_data);
    }

    int windowTimerProc(int handle) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.timerProc(handle);
    }
}

