/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class Label
extends Control {
    int frameHandle;
    int labelHandle;
    int imageHandle;
    Image image;
    String text;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 2) != 0) {
            style = Widget.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Widget.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                if (wHint == -1) {
                    wHint = 64;
                }
            } else if (hHint == -1) {
                hHint = 64;
            }
        }
        int width = OS.GTK_WIDGET_WIDTH((int)this.handle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.handle);
        int labelWidth = 0;
        int labelHeight = 0;
        if (this.labelHandle != 0) {
            labelWidth = OS.GTK_WIDGET_WIDTH((int)this.labelHandle);
            labelHeight = OS.GTK_WIDGET_HEIGHT((int)this.labelHandle);
            OS.gtk_widget_set_size_request((int)this.labelHandle, (int)wHint, (int)hHint);
        }
        GtkRequisition requisition = new GtkRequisition();
        if (this.frameHandle != 0) {
            int frameWidth = OS.GTK_WIDGET_WIDTH((int)this.frameHandle);
            int frameHeight = OS.GTK_WIDGET_HEIGHT((int)this.frameHandle);
            OS.gtk_widget_set_size_request((int)this.frameHandle, (int)-1, (int)-1);
            OS.gtk_widget_set_size_request((int)this.handle, (int)wHint, (int)hHint);
            OS.gtk_widget_size_request((int)this.frameHandle, (GtkRequisition)requisition);
            OS.gtk_widget_set_size_request((int)this.frameHandle, (int)frameWidth, (int)frameHeight);
        } else {
            OS.gtk_widget_set_size_request((int)this.handle, (int)wHint, (int)hHint);
            OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_set_size_request((int)this.labelHandle, (int)labelWidth, (int)labelHeight);
        }
        OS.gtk_widget_set_size_request((int)this.handle, (int)width, (int)height);
        return new Point(requisition.width, requisition.height);
    }

    void createHandle(int index) {
        this.state |= 0x800;
        this.fixedHandle = OS.gtk_fixed_new();
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        if ((this.style & 2) != 0) {
            this.handle = (this.style & 0x100) != 0 ? OS.gtk_hseparator_new() : OS.gtk_vseparator_new();
            OS.gtk_widget_show((int)this.handle);
        } else {
            this.handle = OS.gtk_hbox_new((boolean)false, (int)0);
            if (this.handle == 0) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)this.handle, (int)this.labelHandle);
            OS.gtk_container_add((int)this.handle, (int)this.imageHandle);
            OS.gtk_widget_show((int)this.handle);
            OS.gtk_widget_show((int)this.labelHandle);
        }
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x800) != 0) {
            this.frameHandle = OS.gtk_frame_new(null);
            if (this.frameHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)this.fixedHandle, (int)this.frameHandle);
            OS.gtk_container_add((int)this.frameHandle, (int)this.handle);
            OS.gtk_widget_show((int)this.frameHandle);
            OS.gtk_frame_set_shadow_type((int)this.frameHandle, (int)3);
        } else {
            OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        }
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
        OS.gtk_widget_show((int)this.fixedHandle);
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_label_set_line_wrap((int)this.labelHandle, (boolean)true);
        }
        if ((this.style & 0x4000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)0.0f, (float)0.0f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)0);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)0.0f, (float)0.5f);
            return;
        }
        if ((this.style & 0x1000000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)0.5f, (float)0.0f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)2);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)0.5f, (float)0.5f);
            return;
        }
        if ((this.style & 0x20000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)1.0f, (float)0.0f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)1);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)1.0f, (float)0.5f);
            return;
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.frameHandle != 0) {
            this.display.removeWidget(this.frameHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            this.display.removeWidget(this.imageHandle);
        }
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    int gtk_mnemonic_activate(int widget, int arg1) {
        Composite control = this.parent;
        while (control != null) {
            Control[] children = control._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                return 1;
            }
            control = control.parent;
        }
        return 1;
    }

    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect((int)this.labelHandle, (byte[])OS.mnemonic_activate, (int)this.display.windowProc3, (int)23);
        }
    }

    void register() {
        super.register();
        if (this.frameHandle != 0) {
            this.display.addWidget(this.frameHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0) {
            this.display.addWidget(this.imageHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.imageHandle = 0;
        this.frameHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.text = null;
    }

    void resizeHandle(int width, int height) {
        OS.gtk_widget_set_size_request((int)this.fixedHandle, (int)width, (int)height);
        int widgetHandle = this.frameHandle != 0 ? this.frameHandle : this.handle;
        OS.gtk_widget_set_size_request((int)widgetHandle, (int)width, (int)height);
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)widgetHandle, (GtkRequisition)requisition);
    }

    public void setAlignment(int alignment) {
        boolean isRTL;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        boolean bl = isRTL = (this.style & 0x4000000) != 0;
        if ((this.style & 0x4000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)0.0f, (float)0.0f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)(isRTL ? 1 : 0));
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)0.0f, (float)0.5f);
            return;
        }
        if ((this.style & 0x1000000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)0.5f, (float)0.0f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)2);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)0.5f, (float)0.5f);
            return;
        }
        if ((this.style & 0x20000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)1.0f, (float)0.0f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)(isRTL ? 0 : 1));
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)1.0f, (float)0.5f);
            return;
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_bg((int)this.fixedHandle, (int)0, (GdkColor)color);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_bg((int)this.labelHandle, (int)0, (GdkColor)color);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_bg((int)this.imageHandle, (int)0, (GdkColor)color);
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean fixWrap;
        boolean bl = fixWrap = resize && this.labelHandle != 0 && (this.style & 0x40) != 0;
        if (fixWrap) {
            OS.gtk_widget_set_size_request((int)this.labelHandle, (int)-1, (int)-1);
        }
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (fixWrap) {
            int labelWidth = OS.GTK_WIDGET_WIDTH((int)this.handle);
            int labelHeight = OS.GTK_WIDGET_HEIGHT((int)this.handle);
            OS.gtk_widget_set_size_request((int)this.labelHandle, (int)labelWidth, (int)labelHeight);
            int widgetHandle = this.frameHandle != 0 ? this.frameHandle : this.handle;
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)widgetHandle, (GtkRequisition)requisition);
        }
        return changed;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_font((int)this.labelHandle, (int)font);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_font((int)this.imageHandle, (int)font);
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_fg((int)this.fixedHandle, (int)0, (GdkColor)color);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_fg((int)this.labelHandle, (int)0, (GdkColor)color);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_fg((int)this.imageHandle, (int)0, (GdkColor)color);
        }
    }

    void setOrientation() {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction((int)this.handle, (int)2);
            if (this.labelHandle != 0) {
                OS.gtk_widget_set_direction((int)this.labelHandle, (int)2);
            }
            if (this.imageHandle != 0) {
                OS.gtk_widget_set_direction((int)this.imageHandle, (int)2);
            }
            if ((this.style & 0x4000) != 0 && this.labelHandle != 0) {
                OS.gtk_label_set_justify((int)this.labelHandle, (int)1);
            }
            if ((this.style & 0x20000) != 0 && this.labelHandle != 0) {
                OS.gtk_label_set_justify((int)this.labelHandle, (int)0);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.image = image;
        if (image != null) {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)image.pixmap, (int)image.mask);
            OS.gtk_widget_hide((int)this.labelHandle);
            OS.gtk_widget_show((int)this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)0, (int)0);
            OS.gtk_widget_show((int)this.labelHandle);
            OS.gtk_widget_hide((int)this.imageHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 2) != 0) {
            return;
        }
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic((int)this.labelHandle, (byte[])buffer);
        OS.gtk_widget_hide((int)this.imageHandle);
        OS.gtk_widget_show((int)this.labelHandle);
    }
}

