/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    int cursor;
    int lastCursor;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    int cursorOrientation = 0;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        Rectangle bounds = this.computeBounds();
        int i = 0;
        while (i < rects.length) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (bounds.width != 0) {
                x = (rects[i].x - bounds.x) * 100 / bounds.width;
                width = rects[i].width * 100 / bounds.width;
            } else {
                width = 100;
            }
            if (bounds.height != 0) {
                y = (rects[i].y - bounds.y) * 100 / bounds.height;
                height = rects[i].height * 100 / bounds.height;
            } else {
                height = 100;
            }
            result[i] = new Rectangle(x, y, width, height);
            ++i;
        }
        return result;
    }

    void drawRectangles() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
        int window = OS.GDK_ROOT_PARENT();
        if (this.parent != null) {
            window = OS.GTK_WIDGET_WINDOW((int)this.parent.paintHandle());
        }
        if (window == 0) {
            return;
        }
        int gc = OS.gdk_gc_new((int)window);
        if (gc == 0) {
            return;
        }
        int colormap = OS.gdk_colormap_get_system();
        GdkColor color = new GdkColor();
        OS.gdk_color_white((int)colormap, (GdkColor)color);
        OS.gdk_gc_set_foreground((int)gc, (GdkColor)color);
        OS.gdk_gc_set_subwindow((int)gc, (int)1);
        OS.gdk_gc_set_function((int)gc, (int)2);
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle rect = this.rectangles[i];
            OS.gdk_draw_rectangle((int)window, (int)gc, (int)0, (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
            ++i;
        }
        OS.g_object_unref((int)gc);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        return this.rectangles;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            return;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            return;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            return;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            return;
        }
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        int mask;
        int hStyle;
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        int window = OS.GDK_ROOT_PARENT();
        if (this.parent != null) {
            window = OS.GTK_WIDGET_WINDOW((int)this.parent.paintHandle());
        }
        if (window == 0) {
            return false;
        }
        boolean cancelled = false;
        this.tracking = true;
        this.drawRectangles();
        int[] oldX = new int[1];
        int[] oldY = new int[1];
        int[] state = new int[1];
        OS.gdk_window_get_pointer((int)window, (int[])oldX, (int[])oldY, (int[])state);
        int vStyle = this.style & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        boolean bl = (state[0] & (mask = 1792)) != 0;
        GdkEvent gdkEvent = new GdkEvent();
        GdkEventKey keyEvent = new GdkEventKey();
        int[] newX = new int[1];
        int[] newY = new int[1];
        int grabMask = 516;
        int ptrGrabResult = OS.gdk_pointer_grab((int)window, (boolean)false, (int)grabMask, (int)window, (int)this.cursor, (int)0);
        this.lastCursor = this.cursor;
        while (this.tracking) {
            int eventPtr;
            if (this.parent != null && this.parent.isDisposed()) break;
            while ((eventPtr = OS.gdk_event_get()) == 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            OS.memmove((GdkEvent)gdkEvent, (int)eventPtr, (int)4);
            int eventType = gdkEvent.type;
            switch (eventType) {
                case 3: {
                    if (this.cursor != this.lastCursor) {
                        if (ptrGrabResult == 0) {
                            OS.gdk_pointer_ungrab((int)0);
                        }
                        ptrGrabResult = OS.gdk_pointer_grab((int)window, (boolean)false, (int)grabMask, (int)window, (int)this.cursor, (int)0);
                    }
                }
                case 7: {
                    OS.gdk_window_get_pointer((int)window, (int[])newX, (int[])newY, null);
                    if (oldX[0] != newX[0] || oldY[0] != newY[0]) {
                        this.drawRectangles();
                        Event event = new Event();
                        event.x = newX[0];
                        event.y = newY[0];
                        if ((this.style & 0x10) != 0) {
                            this.resizeRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                            this.sendEvent(11, event);
                        } else {
                            this.moveRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                            this.sendEvent(10, event);
                        }
                        if (this.isDisposed()) {
                            cancelled = true;
                            break;
                        }
                        this.drawRectangles();
                        oldX[0] = newX[0];
                        oldY[0] = newY[0];
                    }
                    this.tracking = eventType != 7;
                    break;
                }
                case 8: {
                    OS.memmove((GdkEventKey)keyEvent, (int)eventPtr, (int)36);
                    int stepSize = (keyEvent.state & 4) != 0 ? 1 : 9;
                    int xChange = 0;
                    int yChange = 0;
                    switch (keyEvent.keyval) {
                        case 65307: {
                            cancelled = true;
                        }
                        case 65293: {
                            this.tracking = false;
                            break;
                        }
                        case 65361: {
                            xChange = -stepSize;
                            break;
                        }
                        case 65363: {
                            xChange = stepSize;
                            break;
                        }
                        case 65362: {
                            yChange = -stepSize;
                            break;
                        }
                        case 65364: {
                            yChange = stepSize;
                        }
                    }
                    if (xChange == 0 && yChange == 0) break;
                    this.drawRectangles();
                    Event event = new Event();
                    event.x = oldX[0] + xChange;
                    event.y = oldY[0] + yChange;
                    if ((this.style & 0x10) != 0) {
                        this.resizeRectangles(xChange, yChange);
                        this.sendEvent(11, event);
                    } else {
                        this.moveRectangles(xChange, yChange);
                        this.sendEvent(10, event);
                    }
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    this.drawRectangles();
                }
            }
            OS.gdk_event_free((int)eventPtr);
        }
        if (!this.isDisposed()) {
            this.drawRectangles();
        }
        if (ptrGrabResult == 0) {
            OS.gdk_pointer_ungrab((int)0);
        }
        return !cancelled;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        Rectangle bounds = this.computeBounds();
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                bounds.x += bounds.width;
                xChange -= bounds.width;
                bounds.width = 0;
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += bounds.width;
            bounds.width = 0;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                bounds.y += bounds.height;
                yChange -= bounds.height;
                bounds.height = 0;
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += bounds.height;
            bounds.height = 0;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            bounds.x += xChange;
            bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            bounds.y += yChange;
            bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle proportion = this.proportions[i];
            newRects[i] = new Rectangle(proportion.x * bounds.width / 100 + bounds.x, proportion.y * bounds.height / 100 + bounds.y, proportion.width * bounds.width / 100, proportion.height * bounds.height / 100);
            ++i;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor value) {
        this.checkWidget();
        this.cursor = 0;
        if (value != null) {
            this.cursor = value.handle;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        this.rectangles = rectangles;
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

