/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String TYPENAME = "text/uri-list";
    private static final int TYPEID = Transfer.registerType("text/uri-list");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof String[])) {
            return;
        }
        String[] files = (String[])object;
        String nativeFormat = "";
        int i = 0;
        int length = files.length;
        while (i < length) {
            nativeFormat = nativeFormat + "file:" + files[i] + "\r";
            ++i;
        }
        byte[] buffer = Converter.wcsToMbcs(null, nativeFormat, true);
        super.javaToNative(buffer, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] data = (byte[])super.nativeToJava(transferData);
        if (data == null) {
            return null;
        }
        char[] unicode = Converter.mbcsToWcs(null, data);
        String string = new String(unicode);
        int start = string.indexOf("file:");
        if (start == -1) {
            return null;
        }
        start += 5;
        String[] fileNames = new String[]{};
        while (start < string.length()) {
            int end = string.indexOf("\r", start);
            if (end == -1) {
                end = string.length() - 1;
            }
            String fileName = string.substring(start, end);
            String[] newFileNames = new String[fileNames.length + 1];
            System.arraycopy(fileNames, 0, newFileNames, 0, fileNames.length);
            newFileNames[fileNames.length] = fileName;
            fileNames = newFileNames;
            start = string.indexOf("file:", end);
            if (start == -1) break;
            start += 5;
        }
        return fileNames;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }
}

