/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Combo
extends Composite {
    public static final int LIMIT = Integer.MAX_VALUE;
    boolean ignoreSelect;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        OS.XmComboBoxAddItem(this.handle, xmString, -1, false);
        OS.XmStringFree(xmString);
    }

    public void add(String string, int index) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == -1) {
            this.error(6);
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > index || index > argList[1]) {
            this.error(6);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        OS.XmComboBoxAddItem(this.handle, xmString, index + 1, false);
        OS.XmStringFree(xmString);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Widget.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextClearSelection(argList[1], OS.XtLastTimestampProcessed(xDisplay));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNlist, 0, OS.XmNtextField, 0, OS.XmNitemCount, 0, OS.XmNmarginWidth, 0, OS.XmNshadowThickness, 0, OS.XmNhighlightThickness, 0, OS.XmNarrowSize, 0, OS.XmNarrowSpacing, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        XtWidgetGeometry result = new XtWidgetGeometry();
        result.request_mode = 4;
        OS.XtQueryGeometry(argList[1], null, result);
        int width = result.width;
        int height = this.getTextHeight();
        int[] argList2 = new int[]{OS.XmNmarginWidth, 0, OS.XmNshadowThickness, 0};
        OS.XtGetValues(argList[3], argList2, argList2.length / 2);
        if ((this.style & 8) == 0) {
            width += 2 * argList[7];
        }
        if ((this.style & 4) != 0) {
            width += argList[13] + argList[15];
        } else {
            int itemCount = argList[5] == 0 ? 5 : argList[5];
            height += this.getItemHeight() * itemCount;
        }
        width += 2 * argList[9] + 2 * argList[11] + 2 * argList2[1] + 2 * argList2[3];
        if (argList[5] == 0) {
            width = 64;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if (wHint != -1) {
            width = wHint;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    public void copy() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextCopy(argList[1], OS.XtLastTimestampProcessed(xDisplay));
    }

    void createHandle(int index) {
        this.state |= 0x800;
        int parentHandle = this.parent.handle;
        int[] argList1 = new int[]{OS.XmNancestorSensitive, 1};
        this.formHandle = OS.XmCreateForm(parentHandle, null, argList1, argList1.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int comboBoxType = 1;
        if ((this.style & 0x40) != 0) {
            comboBoxType = 0;
        } else if ((this.style & 8) != 0) {
            comboBoxType = 2;
        }
        int[] argList2 = new int[]{OS.XmNcomboBoxType, comboBoxType, OS.XmNtopAttachment, 1, OS.XmNbottomAttachment, 1, OS.XmNleftAttachment, 1, OS.XmNrightAttachment, 1, OS.XmNresizable, 0};
        this.handle = OS.XmCreateComboBox(this.formHandle, null, argList2, argList2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
    }

    public void cut() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextCut(argList[1], OS.XtLastTimestampProcessed(xDisplay));
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        int[] argList = new int[]{OS.XmNtextField, 0, OS.XmNlist, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (OS.XmListPosSelected(argList[3], index + 1)) {
            Display display = this.getDisplay();
            boolean warnings = display.getWarnings();
            display.setWarnings(false);
            OS.XmTextSetString(argList[1], new byte[1]);
            display.setWarnings(warnings);
            OS.XmListDeselectAllItems(argList[3]);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNtextField, 0, OS.XmNlist, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        OS.XmTextSetString(argList[1], new byte[1]);
        display.setWarnings(warnings);
        OS.XmListDeselectAllItems(argList[3]);
    }

    public String getItem(int index) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNitemCount, 0, OS.XmNitems, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > index || index >= argList[1]) {
            this.error(6);
        }
        if (argList[3] == 0) {
            this.error(8);
        }
        int ptr = argList[3] + index * 4;
        int[] buffer1 = new int[1];
        OS.memmove(buffer1, ptr, 4);
        ptr = buffer1[0];
        int address = OS.XmStringUnparse(ptr, null, 0, 0, null, 0, 0);
        if (address == 0) {
            this.error(8);
        }
        int length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, length);
        OS.XtFree(address);
        return this.decodeString(new String(Converter.mbcsToWcs(this.getCodePage(), buffer)));
    }

    public int getItemCount() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getItemHeight() {
        this.checkWidget();
        int[] listHandleArgs = new int[]{OS.XmNlist, 0};
        OS.XtGetValues(this.handle, listHandleArgs, listHandleArgs.length / 2);
        int[] argList = new int[]{OS.XmNlistSpacing, 0, OS.XmNhighlightThickness, 0};
        OS.XtGetValues(listHandleArgs[1], argList, argList.length / 2);
        int spacing = argList[1];
        int highlight = argList[3];
        return this.getFontHeight() + spacing + 2 * highlight;
    }

    public String[] getItems() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNitems, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        int[] buffer1 = new int[1];
        String[] result = new String[itemCount];
        String codePage = this.getCodePage();
        int i = 0;
        while (i < itemCount) {
            OS.memmove(buffer1, items, 4);
            int ptr = buffer1[0];
            int address = OS.XmStringUnparse(ptr, null, 0, 0, null, 0, 0);
            if (address == 0) {
                this.error(8);
            }
            int length = OS.strlen(address);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, address, length);
            OS.XtFree(address);
            result[i] = this.decodeString(new String(Converter.mbcsToWcs(codePage, buffer)));
            items += 4;
            ++i;
        }
        return result;
    }

    String getNameText() {
        return this.getText();
    }

    public Point getSelection() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextGetSelectionPosition(argList[1], start, end);
        if (start[0] == end[0]) {
            start[0] = end[0] = OS.XmTextGetInsertionPosition(argList[1]);
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNlist, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int index = OS.XmListGetKbdItemPos(argList[1]);
        if (OS.XmListPosSelected(argList[1], index)) {
            return index - 1;
        }
        int[] positions = new int[1];
        int[] count = new int[1];
        if (!OS.XmListGetSelectedPos(argList[1], positions, count)) {
            return -1;
        }
        if (count[0] == 0) {
            return -1;
        }
        int address = positions[0];
        int[] indices = new int[1];
        OS.memmove(indices, address, 4);
        OS.XtFree(address);
        return indices[0] - 1;
    }

    public String getText() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = OS.XmTextGetString(argList[1]);
        if (ptr == 0) {
            return "";
        }
        int length = OS.strlen(ptr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr, length);
        OS.XtFree(ptr);
        return this.decodeString(new String(Converter.mbcsToWcs(this.getCodePage(), buffer)));
    }

    public int getTextHeight() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (!OS.XtIsRealized(this.handle)) {
                this.getShell().realizeWidget();
            }
            XtWidgetGeometry result = new XtWidgetGeometry();
            result.request_mode = 8;
            OS.XtQueryGeometry(this.handle, null, result);
            return result.height;
        }
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int[] argList2 = new int[]{OS.XmNmarginHeight, 0};
        OS.XtGetValues(argList[1], argList2, argList2.length / 2);
        int height = this.getFontHeight();
        XRectangle rect = new XRectangle();
        OS.XmWidgetGetDisplayRect(argList[1], rect);
        height += rect.y * 2 + 2 * argList2[1];
        int[] argList3 = new int[]{OS.XmNmarginHeight, 0, OS.XmNshadowThickness, 0, OS.XmNhighlightThickness, 0};
        OS.XtGetValues(this.handle, argList3, argList3.length / 2);
        return height += 2 * argList3[1] + 2 * argList3[3] + 2 * argList3[5];
    }

    public int getTextLimit() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return OS.XmTextGetMaxLength(argList[1]);
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.getDisplay().windowProc;
        OS.XtAddCallback(this.handle, OS.XmNselectionCallback, windowProc, 22);
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XtAddCallback(argList[1], OS.XmNactivateCallback, windowProc, 9);
        OS.XtAddCallback(argList[1], OS.XmNvalueChangedCallback, windowProc, 25);
        OS.XtAddEventHandler(argList[1], 1, false, windowProc, 6);
        OS.XtAddEventHandler(argList[1], 2, false, windowProc, 7);
        OS.XtInsertEventHandler(argList[1], 0x200000, false, windowProc, 5, 1);
    }

    public int indexOf(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            return -1;
        }
        int[] argList = new int[]{OS.XmNlist, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int index = OS.XmListItemPos(argList[1], xmString);
        OS.XmStringFree(xmString);
        return index - 1;
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int[] argList = new int[]{OS.XmNitems, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        if (0 > start || start >= itemCount) {
            return -1;
        }
        byte[] buffer1 = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true);
        int xmString = OS.XmStringCreateLocalized(buffer1);
        if (xmString == 0) {
            return -1;
        }
        int index = start;
        items += start * 4;
        int[] buffer2 = new int[1];
        while (index < itemCount) {
            OS.memmove(buffer2, items, 4);
            if (OS.XmStringCompare(buffer2[0], xmString)) break;
            items += 4;
            ++index;
        }
        OS.XmStringFree(xmString);
        if (index == itemCount) {
            return -1;
        }
        return index;
    }

    public void paste() {
        this.checkWidget();
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextFieldPaste(argList[1]);
        display.setWarnings(warnings);
    }

    public void remove(int index) {
        this.checkWidget();
        if (index == -1) {
            this.error(6);
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > index || index >= argList[1]) {
            this.error(6);
        }
        OS.XmComboBoxDeletePos(this.handle, index + 1);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int[] argList = new int[]{OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > start || start >= argList[1]) {
            this.error(6);
        }
        int newEnd = Math.min(end, argList[1] - 1);
        int i = start;
        while (i <= newEnd) {
            OS.XmComboBoxDeletePos(this.handle, start + 1);
            ++i;
        }
        if (end >= argList[1]) {
            this.error(6);
        }
    }

    void register() {
        super.register();
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        WidgetTable.put(argList[1], this);
    }

    public void remove(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(15);
        }
        int[] argList = new int[]{OS.XmNlist, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int index = OS.XmListItemPos(argList[1], xmString);
        OS.XmStringFree(xmString);
        if (index == 0) {
            this.error(5);
        }
        OS.XmComboBoxDeletePos(this.handle, index);
    }

    public void removeAll() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNtextField, 0, OS.XmNlist, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        OS.XmTextSetString(argList[1], new byte[1]);
        display.setWarnings(warnings);
        OS.XmListDeselectAllItems(argList[3]);
        int i = 0;
        while (i < argList[5]) {
            OS.XmComboBoxDeletePos(this.handle, 1);
            ++i;
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            int[] argList = new int[]{OS.XmNtextField, 0, OS.XmNlist, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            Display display = this.getDisplay();
            boolean warnings = display.getWarnings();
            display.setWarnings(false);
            OS.XmTextSetString(argList[1], new byte[1]);
            display.setWarnings(warnings);
            OS.XmListDeselectAllItems(argList[3]);
        } else {
            int[] argList = new int[]{OS.XmNitemCount, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            if (0 > index || index >= argList[1]) {
                return;
            }
            int[] argList2 = new int[]{OS.XmNselectedPosition, index};
            this.ignoreSelect = true;
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            this.ignoreSelect = false;
        }
    }

    byte[] sendIMKeyEvent(int type, XKeyEvent xEvent) {
        byte[] mbcs = super.sendIMKeyEvent(type, xEvent);
        if (mbcs == null || xEvent.keycode != 0) {
            return null;
        }
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int textHandle = argList[1];
        int[] unused = new int[1];
        byte[] buffer = new byte[2];
        int length = OS.XmImMbLookupString(textHandle, xEvent, buffer, buffer.length, unused, unused);
        if (length != 0) {
            return null;
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.XmTextGetSelectionPosition(textHandle, start, end);
        if (start[0] == end[0]) {
            start[0] = end[0] = OS.XmTextGetInsertionPosition(textHandle);
        }
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        OS.XmTextReplace(textHandle, start[0], end[0], mbcs);
        int position = start[0] + mbcs.length - 1;
        OS.XmTextSetInsertionPosition(textHandle, position);
        display.setWarnings(warnings);
        return mbcs;
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int[] argList1 = new int[]{OS.XmNtextField, 0, OS.XmNlist, 0};
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int text = argList1[1];
        int list = argList1[3];
        int[] argList2 = new int[]{OS.XmNforeground, 0, OS.XmNhighlightColor, 0};
        OS.XtGetValues(text, argList2, argList2.length / 2);
        OS.XmChangeColor(text, pixel);
        OS.XtSetValues(text, argList2, argList2.length / 2);
        int[] argList3 = new int[]{OS.XmNforeground, 0, OS.XmNhighlightColor, 0};
        OS.XtGetValues(list, argList3, argList3.length / 2);
        OS.XmChangeColor(list, pixel);
        OS.XtSetValues(list, argList3, argList3.length / 2);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        this.checkWidget();
        int newHeight = resize && (this.style & 4) != 0 ? this.getTextHeight() : height;
        return super.setBounds(x, y, width, newHeight, move, resize);
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if (OS.XtIsRealized(this.handle)) {
            int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            OS.XtResizeWidget(this.handle, argList[1], argList[3] + 1, argList[5]);
            OS.XtResizeWidget(this.handle, argList[1], argList[3], argList[5]);
        }
    }

    void setForegroundPixel(int pixel) {
        int[] argList1 = new int[]{OS.XmNtextField, 0, OS.XmNlist, 0};
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int[] argList2 = new int[]{OS.XmNforeground, pixel};
        OS.XtSetValues(argList1[1], argList2, argList2.length / 2);
        OS.XtSetValues(argList1[3], argList2, argList2.length / 2);
        super.setForegroundPixel(pixel);
    }

    public void setItem(int index, String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == -1) {
            this.error(6);
        }
        int[] argList = new int[]{OS.XmNlist, 0, OS.XmNitemCount, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (0 > index || index >= argList[3]) {
            this.error(6);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        boolean isSelected = OS.XmListPosSelected(argList[1], index + 1);
        OS.XmListReplaceItemsPosUnselected(argList[1], new int[]{xmString}, 1, index + 1);
        if (isSelected) {
            OS.XmListSelectPos(argList[1], index + 1, false);
        }
        OS.XmStringFree(xmString);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.removeAll();
            return;
        }
        int index = 0;
        int[] table = new int[items.length];
        String codePage = this.getCodePage();
        while (index < items.length) {
            byte[] buffer;
            int xmString;
            String string = items[index];
            if (string == null || (xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(codePage, this.encodeString(string), true))) == 0) break;
            table[index++] = xmString;
        }
        int ptr = OS.XtMalloc(index * 4);
        OS.memmove(ptr, table, index * 4);
        int[] argList1 = new int[]{OS.XmNitems, ptr, OS.XmNitemCount, index};
        OS.XtSetValues(this.handle, argList1, argList1.length / 2);
        int i = 0;
        while (i < index) {
            OS.XmStringFree(table[i]);
            ++i;
        }
        OS.XtFree(ptr);
        if (index < items.length) {
            this.error(14);
        }
        int[] argList2 = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList2, argList2.length / 2);
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        OS.XmTextSetString(argList2[1], new byte[1]);
        display.setWarnings(warnings);
        int[] argList3 = new int[]{OS.XmNlist, 0};
        OS.XtGetValues(this.handle, argList3, argList3.length / 2);
        int[] argList4 = new int[]{OS.XmNselectedItemCount, 0, OS.XmNselectedItems, 0};
        OS.XtSetValues(argList3[1], argList4, argList4.length / 2);
    }

    public void setSelection(Point selection) {
        int xDisplay;
        this.checkWidget();
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int position = OS.XmTextGetLastPosition(argList[1]);
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        if ((xDisplay = OS.XtDisplay(argList[1])) == 0) {
            return;
        }
        int nStart = Math.min(Math.max(Math.min(selection.x, selection.y), 0), position);
        int nEnd = Math.min(Math.max(Math.max(selection.x, selection.y), 0), position);
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        OS.XmTextSetSelection(argList[1], nStart, nEnd, OS.XtLastTimestampProcessed(xDisplay));
        OS.XmTextSetInsertionPosition(argList[1], nEnd);
        display.setWarnings(warnings);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
        } else {
            byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
            int xmString = OS.XmStringCreateLocalized(buffer);
            if (xmString == 0) {
                return;
            }
            int[] argList = new int[]{OS.XmNtextField, 0, OS.XmNlist, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int index = OS.XmListItemPos(argList[3], xmString);
            if (index > 0) {
                OS.XmComboBoxSelectItem(this.handle, xmString);
            } else {
                Display display = this.getDisplay();
                boolean warnings = display.getWarnings();
                display.setWarnings(false);
                OS.XmTextSetString(argList[1], buffer);
                OS.XmTextSetInsertionPosition(argList[1], 0);
                display.setWarnings(warnings);
            }
            OS.XmStringFree(xmString);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextSetMaxLength(argList[1], limit);
    }

    void deregister() {
        super.deregister();
        int[] argList = new int[]{OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        WidgetTable.remove(argList[1]);
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        int[] argList = new int[]{OS.XmNlist, 0, OS.XmNtextField, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        this.enableHandle(enabled, argList[1]);
        this.enableHandle(enabled, argList[3]);
    }

    String encodeString(String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != ' ') {
                return string;
            }
            ++i;
        }
        return string + ' ';
    }

    String decodeString(String string) {
        if (string.length() == 0) {
            return string;
        }
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != ' ') {
                return string;
            }
            ++i;
        }
        return string.substring(0, string.length() - 1);
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        this.postEvent(14);
        return 0;
    }

    int XmNselectionCallback(int w, int client_data, int call_data) {
        if (this.ignoreSelect || this.getSelectionIndex() == -1) {
            return 0;
        }
        this.postEvent(13);
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        this.sendEvent(24);
        return 0;
    }
}

