/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String filterPath = "";
    boolean cancel = true;
    String message = "";

    public DirectoryDialog(Shell parent) {
        this(parent, 32768);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    int activate(int widget, int client, int call) {
        this.cancel = client == 2;
        OS.XtUnmanageChild(widget);
        return 0;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        int parent2;
        String string;
        Display appContext = Display.getCurrent();
        boolean destroyContext = appContext == null;
        if (destroyContext) {
            appContext = new Display();
        }
        int display = appContext.xDisplay;
        int parentHandle = appContext.shellHandle;
        if (this.parent != null && this.parent.getDisplay() == appContext) {
            if (OS.IsAIX) {
                this.parent.realizeWidget();
            }
            parentHandle = this.parent.shellHandle;
        }
        if ((string = this.title).length() == 0) {
            string = " ";
        }
        byte[] buffer1 = Converter.wcsToMbcs(null, string, true);
        int xmStringPtr1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        byte[] buffer2 = Converter.wcsToMbcs(null, "*", true);
        int xmStringPtr2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        byte[] buffer3 = Converter.wcsToMbcs(null, this.filterPath, true);
        int xmStringPtr3 = OS.XmStringParseText(buffer3, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        byte[] buffer7 = Converter.wcsToMbcs(null, "Selection", true);
        int xmStringPtr4 = OS.XmStringParseText(buffer7, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        byte[] name = new byte[]{0};
        int[] argList1 = new int[]{OS.XmNresizePolicy, 0, OS.XmNdialogStyle, 1, OS.XmNwidth, OS.XDisplayWidth(display, OS.XDefaultScreen(display)) * 4 / 9, OS.XmNdialogTitle, xmStringPtr1, OS.XmNpattern, xmStringPtr2, OS.XmNdirectory, xmStringPtr3, OS.XmNpathMode, 0, OS.XmNfilterLabelString, xmStringPtr4};
        int dialog = OS.XmCreateFileSelectionDialog(parentHandle, name, argList1, argList1.length / 2);
        int child = OS.XmFileSelectionBoxGetChild(dialog, 7);
        if (child != 0) {
            OS.XtUnmanageChild(child);
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog, 8)) != 0 && (parent2 = OS.XtParent(child)) != 0) {
            OS.XtUnmanageChild(parent2);
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog, 9)) != 0) {
            OS.XtUnmanageChild(child);
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog, 13)) != 0) {
            OS.XtUnmanageChild(child);
        }
        if ((child = OS.XmFileSelectionBoxGetChild(dialog, 11)) != 0) {
            OS.XtUnmanageChild(child);
        }
        OS.XmStringFree(xmStringPtr1);
        OS.XmStringFree(xmStringPtr2);
        OS.XmStringFree(xmStringPtr3);
        OS.XmStringFree(xmStringPtr4);
        byte[] buffer4 = Converter.wcsToMbcs(null, this.message, true);
        int xmString1 = OS.XmStringGenerate(buffer4, null, 0, null);
        int[] argList = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, xmString1};
        int textArea = OS.XmCreateLabel(dialog, name, argList, argList.length / 2);
        OS.XtManageChild(textArea);
        OS.XmStringFree(xmString1);
        Callback callback = new Callback(this, "activate", 3);
        int address = callback.getAddress();
        OS.XtAddCallback(dialog, OS.XmNokCallback, address, 4);
        OS.XtAddCallback(dialog, OS.XmNcancelCallback, address, 2);
        this.cancel = true;
        OS.XtManageChild(dialog);
        while (OS.XtIsRealized(dialog) && OS.XtIsManaged(dialog)) {
            if (appContext.readAndDispatch()) continue;
            appContext.sleep();
        }
        String directoryPath = "";
        if (!this.cancel) {
            int length;
            int[] argList2 = new int[]{OS.XmNdirMask, 0};
            OS.XtGetValues(dialog, argList2, argList2.length / 2);
            int xmString3 = argList2[1];
            int ptr = OS.XmStringUnparse(xmString3, null, 0, 0, null, 0, 0);
            if (ptr != 0) {
                length = OS.strlen(ptr);
                byte[] buffer = new byte[length];
                OS.memmove(buffer, ptr, length);
                OS.XtFree(ptr);
                directoryPath = new String(Converter.mbcsToWcs(null, buffer));
            }
            OS.XmStringFree(xmString3);
            length = directoryPath.length();
            if (length != 0) {
                if (directoryPath.charAt(length - 1) == '/') {
                    directoryPath = directoryPath.substring(0, length - 1);
                } else if (length > 1 && directoryPath.charAt(length - 2) == '/' && directoryPath.charAt(length - 1) == '*') {
                    directoryPath = directoryPath.substring(0, length - 2);
                }
            }
            this.filterPath = directoryPath;
        }
        if (OS.XtIsRealized(dialog)) {
            OS.XtDestroyWidget(dialog);
        }
        if (destroyContext) {
            appContext.dispose();
        }
        callback.dispose();
        if (this.cancel) {
            return null;
        }
        return directoryPath;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

