/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.AbstractTreeItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends AbstractTreeItem {
    private static final int DEFAULT_ITEM_CONNECTOR_WIDTH = 8;
    private static final int ITEM_CONNECTOR_PADDING = 2;
    private static final int IMAGE_PADDING = 3;
    private static final int ITEM_NOIMAGE_OFFSET = 8;
    private static final int ROOT_INDENT = 5;
    private static final int SELECTION_PADDING = 2;
    private static final int TEXT_INDENT = 2;
    private TreeItem parentItem;
    private int index;
    private int paintStartX = -1;
    private Point itemExtent;
    private Point imageExtent;
    private int textYPosition = -1;
    private boolean isExpanding = false;
    Color background = null;
    Color foreground = null;

    public TreeItem(Tree parent, int style) {
        this(parent, style, TreeItem.checkNull(parent).getItemCount());
    }

    public TreeItem(Tree parent, int style, int index) {
        super(parent, style);
        parent.addItem(this, index);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(parentItem, style, TreeItem.checkNull(parentItem).getItemCount());
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        super(TreeItem.checkNull(parentItem).getParent(), style);
        this.setParentItem(parentItem);
        parentItem.add(this, index);
    }

    void calculateVisibleItemCount() {
        int visibleItemCount = 0;
        if (this.internalGetExpanded()) {
            Vector children = this.getChildren();
            visibleItemCount = children.size();
            int i = 0;
            while (i < children.size()) {
                TreeItem child = (TreeItem)children.elementAt(i);
                visibleItemCount += child.getVisibleItemCount();
                ++i;
            }
        }
        this.setVisibleItemCount(visibleItemCount);
        this.calculateVisibleItemCountParent();
    }

    void calculateVisibleItemCountParent() {
        TreeItem parentItem = this.getParentItem();
        if (parentItem != null) {
            parentItem.calculateVisibleItemCount();
        } else {
            this.getParent().getRoot().calculateVisibleItemCount();
        }
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Point drawHierarchyIndicator(GC gc, Point position) {
        Point connectorLinePosition;
        Tree parent = this.getParent();
        Rectangle indicatorRectangle = parent.getHierarchyIndicatorRect();
        int x = position.x;
        int y = position.y;
        int yCenter = y + parent.getItemHeight() / 2;
        if (!this.isLeaf()) {
            Image hierarchyImage = this.getExpanded() ? parent.getExpandedImage() : parent.getCollapsedImage();
            if (hierarchyImage != null) {
                gc.drawImage(hierarchyImage, x + indicatorRectangle.x, y + indicatorRectangle.y);
            }
            connectorLinePosition = new Point(x + indicatorRectangle.width, yCenter);
        } else {
            connectorLinePosition = new Point(x + indicatorRectangle.width / 2 + indicatorRectangle.width % 2, yCenter);
        }
        return connectorLinePosition;
    }

    Point drawHorizontalItemConnector(GC gc, Point position) {
        int itemConnectorEndPos = position.x + this.getItemConnectorWidth() - 1;
        gc.drawLine(position.x, position.y, itemConnectorEndPos, position.y);
        return new Point(itemConnectorEndPos + 1, position.y);
    }

    Point drawImage(GC gc, Point destinationPosition) {
        Tree parent = this.getParent();
        Image image = this.getImage();
        Point destinationImageExtent = parent.getImageExtent();
        if (image != null) {
            Point sourceImageExtent = this.getImageExtent();
            int yCenter = (parent.getItemHeight() - destinationImageExtent.y) / 2;
            gc.drawImage(image, 0, 0, sourceImageExtent.x, sourceImageExtent.y, destinationPosition.x, destinationPosition.y + yCenter, destinationImageExtent.x, destinationImageExtent.y);
        }
        if (destinationImageExtent != null) {
            destinationPosition.x += destinationImageExtent.x + 3;
        }
        return destinationPosition;
    }

    void drawSelectionFocus(GC gc, Point position) {
        Point selectionExtent = this.getSelectionExtent();
        if (selectionExtent == null) {
            return;
        }
        if (this.getParent().hasFocus(this)) {
            gc.drawFocus(position.x, position.y, selectionExtent.x, selectionExtent.y);
        }
    }

    void drawVerticalItemConnector(GC gc, int yPosition, boolean isFirstChild) {
        Tree parent = this.getParent();
        TreeItem nextDrawItem = this.getParentItem();
        AbstractTreeItem parentItem = nextDrawItem;
        Rectangle indicatorRectangle = parent.getHierarchyIndicatorRect();
        int itemHeight = parent.getItemHeight();
        int itemHeightDiv2 = itemHeight / 2 + itemHeight % 2;
        int indicatorHeightDiv2 = indicatorRectangle.height / 2 + indicatorRectangle.height % 2;
        int lineX = this.getPaintStartX() + indicatorRectangle.width / 2;
        int lineStartY = yPosition - itemHeightDiv2;
        int lineEndY = yPosition + itemHeightDiv2;
        if (parentItem == null) {
            parentItem = parent.getRoot();
        }
        if (this.getIndex() != parentItem.getItemCount() - 1) {
            if (isFirstChild) {
                lineStartY += indicatorHeightDiv2;
            }
            gc.drawLine(lineX, lineStartY, lineX, lineEndY);
        }
        if (nextDrawItem != null) {
            nextDrawItem.drawVerticalItemConnector(gc, yPosition, false);
        }
    }

    Point drawVerticalItemConnector(GC gc, Point position) {
        TreeItem predecessor;
        Tree parent = this.getParent();
        TreeItem parentItem = this.getParentItem();
        Rectangle indicatorRectangle = parent.getHierarchyIndicatorRect();
        int itemHeight = parent.getItemHeight();
        int itemHeightDiv2 = itemHeight / 2 + itemHeight % 2;
        int indicatorHeightDiv2 = indicatorRectangle.height / 2 + indicatorRectangle.height % 2;
        int lineX = position.x + indicatorRectangle.width / 2;
        int lineStartY = position.y - itemHeightDiv2;
        int lineEndY = position.y + itemHeightDiv2 - itemHeight % 2;
        boolean isFirstChild = false;
        if (this.isRoot()) {
            if (this.getIndex() == 0) {
                return position;
            }
        } else if (this.getIndex() == 0) {
            lineStartY += itemHeightDiv2;
            isFirstChild = true;
        }
        if ((predecessor = this.getPredecessor()) != null && !predecessor.isLeaf()) {
            lineStartY += indicatorHeightDiv2;
        }
        if (!this.isLeaf()) {
            lineEndY -= indicatorHeightDiv2;
        }
        gc.drawLine(lineX, lineStartY, lineX, lineEndY);
        if (parentItem != null) {
            parentItem.drawVerticalItemConnector(gc, position.y, isFirstChild);
        }
        return position;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background != null) {
            return this.background;
        }
        Tree parent = this.getParent();
        return parent.getBackground();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Tree parent = this.getParent();
        Point extent = this.getItemExtent();
        int x = this.getTextXPos() - 2;
        return new Rectangle(x, parent.getRedrawY(this), extent.x - (x - this.getItemStartX()), extent.y);
    }

    int getCheckboxXPosition() {
        return this.getPaintStartX() + this.getDecorationsWidth();
    }

    int getDecorationsWidth() {
        int indicatorWidth = this.getParent().getHierarchyIndicatorRect().width;
        int width = indicatorWidth + this.getItemConnectorWidth();
        if (this.isLeaf()) {
            width -= indicatorWidth / 2;
        }
        return width;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground != null) {
            return this.foreground;
        }
        Tree parent = this.getParent();
        return parent.getForeground();
    }

    int getGlobalIndex() {
        int globalItemIndex = this.getIndex();
        AbstractTreeItem item = null;
        if (!this.isRoot()) {
            item = this.getParentItem();
            ++globalItemIndex;
        } else {
            item = this.getParent().getRoot();
        }
        return globalItemIndex += item.getVisibleIndex(this.getIndex());
    }

    Point getImageExtent() {
        Image image = this.getImage();
        if (this.imageExtent == null && image != null) {
            Rectangle imageBounds = image.getBounds();
            this.imageExtent = new Point(imageBounds.width, imageBounds.height);
        }
        return this.imageExtent;
    }

    int getIndex() {
        return this.index;
    }

    int getItemConnectorWidth() {
        Tree parent = this.getParent();
        Point imageExtent = parent.getImageExtent();
        int indicatorWidth = parent.getHierarchyIndicatorRect().width;
        int itemConnectorWidth = imageExtent != null ? imageExtent.x / 2 + 2 : 8;
        if (!this.isLeaf()) {
            itemConnectorWidth -= indicatorWidth / 2;
        }
        return itemConnectorWidth;
    }

    public int getItemCount() {
        this.checkWidget();
        return super.getItemCount();
    }

    Point getItemExtent() {
        if (this.itemExtent == null) {
            Tree parent = this.getParent();
            Point imageExtent = parent.getImageExtent();
            String text = this.getText();
            int itemWidth = 2;
            if (text != null) {
                itemWidth += parent.getTextWidth(text) + 2;
            }
            if (imageExtent != null) {
                itemWidth += imageExtent.x + 3;
            }
            this.itemExtent = new Point(itemWidth, parent.getItemHeight());
        }
        return this.itemExtent;
    }

    int getItemStartX() {
        int itemStartX = this.getPaintStartX() + this.getDecorationsWidth();
        if (this.isCheckable()) {
            itemStartX += this.getCheckboxBounds().width + 1;
        }
        return itemStartX;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        Object[] childrenArray = new TreeItem[this.getItemCount()];
        this.getChildren().copyInto(childrenArray);
        return childrenArray;
    }

    int getPaintStartX() {
        Tree parent = this.getParent();
        if (this.paintStartX == -1) {
            if (this.isRoot()) {
                this.paintStartX = 5;
            } else {
                TreeItem parentItem = this.getParentItem();
                this.paintStartX = parentItem.getPaintStartX() - parent.getHorizontalOffset() + parentItem.getDecorationsWidth() - parent.getHierarchyIndicatorRect().width / 2;
                Point imageExtent = parent.getImageExtent();
                this.paintStartX = imageExtent != null ? (this.paintStartX += imageExtent.x / 2) : (this.paintStartX += 8);
            }
        }
        return this.paintStartX + parent.getHorizontalOffset();
    }

    int getPaintStopX() {
        return this.getItemStartX() + this.getItemExtent().x - this.getParent().getHorizontalOffset();
    }

    public Tree getParent() {
        this.checkWidget();
        return (Tree)super.getSelectableParent();
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    TreeItem getPredecessor() {
        Vector children;
        AbstractTreeItem parentItem = this.getParentItem();
        int previousIndex = this.getIndex() - 1;
        TreeItem previousItem = null;
        if (parentItem == null) {
            parentItem = this.getParent().getRoot();
        }
        if (previousIndex >= 0 && !(previousItem = (TreeItem)(children = parentItem.getChildren()).elementAt(previousIndex)).isLeaf() && previousItem.getExpanded()) {
            previousItem = null;
        }
        return previousItem;
    }

    Point getSelectionExtent() {
        Point selectionExtent = this.getItemExtent();
        Point imageExtent = this.getParent().getImageExtent();
        int x = selectionExtent.x;
        if (imageExtent != null) {
            x -= imageExtent.x + 3;
        }
        return new Point(x, selectionExtent.y);
    }

    int getSelectionX() {
        return this.getTextXPos() - 2;
    }

    int getTextXPos() {
        Point imageExtent = this.getParent().getImageExtent();
        int textXPos = this.getItemStartX() + 2;
        if (imageExtent != null) {
            textXPos += imageExtent.x + 3;
        }
        return textXPos;
    }

    int getTextYPosition(GC gc) {
        if (this.textYPosition == -1) {
            String text = this.getText();
            this.textYPosition = text != null ? (this.getParent().getItemHeight() - gc.stringExtent((String)text).y) / 2 : 0;
        }
        return this.textYPosition;
    }

    int getVisibleIndex() {
        int visibleItemIndex = this.getIndex();
        AbstractTreeItem item = null;
        if (!this.isRoot()) {
            if (!this.isVisible()) {
                return -1;
            }
            item = this.getParentItem();
            ++visibleItemIndex;
        } else {
            item = this.getParent().getRoot();
        }
        return visibleItemIndex += item.getVisibleIndex(this.getIndex());
    }

    int getVisibleIndex(int childIndex) {
        Enumeration children = this.getChildren().elements();
        int visibleItemIndex = this.getIndex();
        if (!this.isRoot()) {
            ++visibleItemIndex;
        }
        while (children.hasMoreElements()) {
            TreeItem child = (TreeItem)children.nextElement();
            if (child.getIndex() == childIndex) {
                if (!this.isRoot()) {
                    visibleItemIndex += this.getParentItem().getVisibleIndex(this.getIndex());
                    break;
                }
                visibleItemIndex += this.getParent().getRoot().getVisibleIndex(this.getIndex());
                break;
            }
            visibleItemIndex += child.getVisibleItemCount();
        }
        return visibleItemIndex;
    }

    /*
     * Unable to fully structure code
     */
    TreeItem getVisibleItem(int searchIndex) {
        foundItem = null;
        children = this.getChildren().elements();
        if (searchIndex == 0) {
            return this;
        }
        if (this.getExpanded()) ** GOTO lbl13
        return null;
lbl-1000:
        // 1 sources

        {
            child = (TreeItem)children.nextElement();
            --searchIndex;
            if (child.getExpanded()) {
                searchIndex -= child.getVisibleItemCount();
            }
            if (searchIndex > 0) continue;
            foundItem = child.getVisibleItem(searchIndex + child.getVisibleItemCount());
lbl13:
            // 3 sources

            ** while (children.hasMoreElements() && foundItem == null)
        }
lbl14:
        // 1 sources

        return foundItem;
    }

    boolean isChild(TreeItem item) {
        Vector children = this.getChildren();
        if (children.contains(item)) {
            return true;
        }
        int i = 0;
        while (i < children.size()) {
            TreeItem child = (TreeItem)children.elementAt(i);
            if (child.isChild(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isRoot() {
        return this.getParentItem() == null;
    }

    boolean isSelectionHit(Point position) {
        Point itemExtent = this.getItemExtent();
        if (itemExtent == null) {
            return false;
        }
        return new Rectangle(this.getItemStartX() - this.getPaintStartX(), 0, itemExtent.x, itemExtent.y).contains(position);
    }

    boolean isVisible() {
        boolean isVisible = true;
        TreeItem parentItem = this.getParentItem();
        if (!this.isRoot() && (isVisible = parentItem.getExpanded())) {
            isVisible = parentItem.isVisible();
        }
        return isVisible;
    }

    void makeVisible() {
        TreeItem parentItem = this.getParentItem();
        if (!this.isVisible() && parentItem != null) {
            this.getParent().expand(parentItem, true);
            parentItem.makeVisible();
        }
    }

    void paint(GC gc, int yPosition) {
        if (!this.isVisible()) {
            return;
        }
        Tree parent = this.getParent();
        Point paintPosition = new Point(this.getPaintStartX(), yPosition);
        Point extent = this.getSelectionExtent();
        gc.setForeground(parent.CONNECTOR_LINE_COLOR);
        paintPosition = this.drawVerticalItemConnector(gc, paintPosition);
        paintPosition = this.drawHierarchyIndicator(gc, paintPosition);
        paintPosition = this.drawHorizontalItemConnector(gc, paintPosition);
        gc.setForeground(parent.getForeground());
        if (this.isCheckable()) {
            paintPosition = this.drawCheckbox(gc, new Point(paintPosition.x, yPosition));
        }
        paintPosition = this.drawImage(gc, new Point(paintPosition.x, yPosition));
        if (this.isSelected()) {
            gc.setBackground(this.getSelectionBackgroundColor());
            gc.setForeground(this.getSelectionForegroundColor());
            gc.fillRectangle(paintPosition.x, paintPosition.y, extent.x, extent.y);
        } else {
            gc.setBackground(this.getBackground());
            gc.setForeground(this.getForeground());
            if (this.getBackground() != parent.getBackground()) {
                gc.fillRectangle(paintPosition.x, paintPosition.y, extent.x, extent.y);
            }
        }
        if (this.text != null) {
            gc.drawString(this.text, this.getTextXPos(), paintPosition.y + this.getTextYPosition(gc), true);
        }
        if (this == parent.getInsertItem()) {
            this.drawInsertMark(gc, paintPosition);
        }
        this.drawSelectionFocus(gc, paintPosition);
    }

    void redraw() {
        Rectangle bounds = this.getBounds();
        this.getParent().redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
    }

    void redrawExpanded(int itemIndex) {
        Tree parent = this.getParent();
        int indicatorWidth = parent.getHierarchyIndicatorRect().width;
        int itemHeight = parent.getItemHeight();
        parent.redraw(this.getPaintStartX(), itemIndex * itemHeight, indicatorWidth, itemHeight, false);
    }

    void reset() {
        super.reset();
        this.setImageExtent(null);
        this.setItemExtent(null);
        this.setPaintStartX(-1);
        this.setTextYPosition(-1);
    }

    public void setExpanded(boolean expand) {
        this.checkWidget();
        if (!this.isLeaf() && expand) {
            this.getParent().expand(this, false);
        } else {
            this.getParent().collapse(this, false);
        }
    }

    public void setImage(Image newImage) {
        boolean isSameImage;
        this.checkWidget();
        Tree parent = this.getParent();
        Image oldImage = this.getImage();
        int imageWidth = 0;
        int redrawX = 0;
        super.setImage(newImage);
        if (newImage != null && oldImage != null) {
            isSameImage = newImage.equals(oldImage);
        } else {
            boolean bl = isSameImage = newImage == oldImage;
        }
        if (!isSameImage) {
            if (parent.getVisibleRedrawY(this) != -1) {
                if (parent.getImageExtent() != null) {
                    imageWidth = parent.getImageExtent().x;
                } else if (newImage != null) {
                    imageWidth = newImage.getBounds().x;
                }
                redrawX = this.getItemStartX();
            }
            parent.itemChanged(this, redrawX, imageWidth);
        }
    }

    void setImageExtent(Point imageExtent) {
        this.imageExtent = imageExtent;
    }

    void setIndex(int index) {
        this.index = index;
    }

    void setItemExtent(Point extent) {
        this.itemExtent = extent;
    }

    void setPaintStartX(int startX) {
        this.paintStartX = startX;
    }

    void setParentItem(TreeItem parentItem) {
        this.parentItem = parentItem;
    }

    public void setText(String newText) {
        this.checkWidget();
        Tree parent = this.getParent();
        String oldText = this.getText();
        int redrawX = 0;
        int redrawWidth = 0;
        if (newText == null) {
            this.error(4);
        }
        super.setText(newText);
        if (!newText.equals(oldText)) {
            if (parent.getVisibleRedrawY(this) != -1) {
                redrawX = this.getTextXPos();
                redrawWidth = parent.getClientArea().width - redrawX;
            }
            parent.itemChanged(this, redrawX, redrawWidth);
        }
    }

    void setTextYPosition(int yPosition) {
        this.textYPosition = yPosition;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Tree parent = this.getParent();
        if (!parent.isRemovingAll()) {
            parent.collapseNoRedraw(this);
        }
        if (this.parentItem != null) {
            this.parentItem.removeItem(this);
        } else {
            parent.removeItem(this);
        }
        super.dispose();
    }

    void doDispose() {
        this.setParentItem(null);
        this.setImageExtent(null);
        this.setItemExtent(null);
        this.setIndex(-1);
        this.setPaintStartX(-1);
        this.setTextYPosition(-1);
        super.doDispose();
    }

    public boolean getChecked() {
        this.checkWidget();
        return super.getChecked();
    }

    public Display getDisplay() {
        return super.getDisplay();
    }

    boolean getExpanding() {
        return this.isExpanding;
    }

    public boolean getGrayed() {
        this.checkWidget();
        return super.getGrayed();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.background = color;
        this.redraw();
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        super.setChecked(checked);
    }

    void setExpanding(boolean expanding) {
        this.isExpanding = expanding;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.foreground = color;
        this.redraw();
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        super.setGrayed(grayed);
    }
}

