package org.argosdic.action.program;

import org.argosdic.ArgosDic;
import org.argosdic.action.BaseAction;
import org.argosdic.speech.SpeechManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

/**
 * SpeakAction.java
 * @author Xavier Cho
 * @version $Revision: 1.2 $ $Date: 2003/09/21 08:31:54 $
 */
public class SpeakAction extends BaseAction {

    public SpeakAction(ArgosDic application) {
        super(application);

        setEnabled(false);
    }

    /**
     * @see org.eclipse.jface.action.IAction#runWithEvent(org.eclipse.swt.widgets.Event)
     */
    public void runWithEvent(Event event) {
        Display.getCurrent().asyncExec(new Runnable() {
            public void run() {
                String sentence = application.getSearchWord();

                SpeechManager manager = SpeechManager.getInstance();
                manager.speak(sentence);
            }
        });
    }
}
