package org.argosdic.widget;

import java.util.Iterator;

import org.argosdic.ArgosDic;
import org.argosdic.action.ActionMap;
import org.argosdic.action.dictionary.RefreshDictionariesAction;
import org.argosdic.action.dictionary.SetDictionaryAction;
import org.argosdic.action.help.AboutAction;
import org.argosdic.action.program.BackAction;
import org.argosdic.action.program.ForwardAction;
import org.argosdic.action.program.QuitAction;
import org.argosdic.action.program.SearchAction;
import org.argosdic.action.program.SettingsAction;
import org.argosdic.action.program.SpeakAction;
import org.argosdic.action.program.SpellCheckAction;
import org.argosdic.dictionary.Dictionary;
import org.argosdic.dictionary.DictionaryEvent;
import org.argosdic.dictionary.DictionaryListener;
import org.argosdic.dictionary.DictionaryManager;
import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.util.Assert;

/**
 * ArgosDicMenuManager.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/10/13 02:49:01 $
 */
public class ArgosDicMenuManager extends MenuManager {
    protected ActionMap actions;

    private ArgosDic application;
    private ResourceManager resources;
    private MenuManager dictionaryMenu;

    public ArgosDicMenuManager(ArgosDic application) {
        Assert.isNotNull(application);

        this.application = application;
        this.actions = application.getActionMap();
        this.resources = ResourceManager.getInstance();

        initialize();
    }

    protected void initialize() {
        add(createProgramMenu());
        add(createDictionaryMenu());
        add(createHelpMenu());

        DictionaryManager manager = DictionaryManager.getInstance();
        manager.addDictionaryListener(new DictionaryListener() {
            public void dictionaryUpdated(DictionaryEvent event) {
                refreshDictionaryMenu();
            }

            public void dictionaryChanged(DictionaryEvent event) {
            }
        });
    }

    protected MenuManager createProgramMenu() {
        String name = resources.getString("menu.program"); //$NON-NLS-1$
        MenuManager manager = new MenuManager(name);

        manager.add(actions.get(SearchAction.class.getName()));
        manager.add(actions.get(SpellCheckAction.class.getName()));
        manager.add(actions.get(SpeakAction.class.getName()));
        manager.add(new Separator());
        manager.add(actions.get(BackAction.class.getName()));
        manager.add(actions.get(ForwardAction.class.getName()));
        manager.add(new Separator());
        manager.add(actions.get(SettingsAction.class.getName()));
        manager.add(new Separator());
        manager.add(actions.get(QuitAction.class.getName()));

        return manager;
    }

    protected MenuManager createDictionaryMenu() {
        String name = resources.getString("menu.dictionary"); //$NON-NLS-1$
        this.dictionaryMenu = new MenuManager(name);

        refreshDictionaryMenu();

        return dictionaryMenu;
    }

    public void refreshDictionaryMenu() {
        if (dictionaryMenu != null) {
            dictionaryMenu.removeAll();

            dictionaryMenu.add(new GroupMarker("dictionary")); //$NON-NLS-1$

            IPreferenceStore preferences =
                JFacePreferences.getPreferenceStore();

            String defaultId = preferences.getString("default.dictionary"); //$NON-NLS-1$

            DictionaryManager manager = DictionaryManager.getInstance();

            if(manager.getDictionary(defaultId) == null) {
                defaultId = null;
            }

            Iterator it = manager.getDictionaries();
            while (it.hasNext()) {
                Dictionary dictionary = (Dictionary) it.next();
                IAction action =
                    new SetDictionaryAction(application, dictionary);

                if (defaultId == null) {
                    defaultId = dictionary.getId();
                }

                if(defaultId.equals(dictionary.getId())) {
                    manager.setSelectedDictionary(defaultId);
                    action.setChecked(true);
                }

                dictionaryMenu.appendToGroup("dictionary", action); //$NON-NLS-1$
            }

            dictionaryMenu.add(new Separator());
            dictionaryMenu.add(
                actions.get(RefreshDictionariesAction.class.getName()));
        }
    }

    protected MenuManager createHelpMenu() {
        String name = resources.getString("menu.help"); //$NON-NLS-1$

        MenuManager manager = new MenuManager(name);

        manager.add(actions.get(AboutAction.class.getName()));

        return manager;
    }
}
