package org.argosdic.widget;

import org.argosdic.ArgosDic;
import org.argosdic.action.ActionMap;
import org.argosdic.action.program.BackAction;
import org.argosdic.action.program.ForwardAction;
import org.argosdic.action.program.QuitAction;
import org.argosdic.action.program.SettingsAction;
import org.argosdic.action.program.SpeakAction;
import org.argosdic.action.program.SpellCheckAction;
import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWT;

/**
 * ArgosDicToolBarManager.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/10/13 02:49:01 $
 */
public class ArgosDicToolBarManager extends ToolBarManager {
    protected ActionMap actions;

    public ArgosDicToolBarManager(ArgosDic application) {
        this(application, SWT.FLAT | SWT.WRAP);
    }

    public ArgosDicToolBarManager(ArgosDic application, int style) {
        super(style);

        Assert.isNotNull(application);
        this.actions = application.getActionMap();

        initialize();
    }

    protected void initialize() {
        ResourceManager resources = ResourceManager.getInstance();

        add(actions.get(SpeakAction.class.getName()));
        add(actions.get(SpellCheckAction.class.getName()));
        add(new Separator());
        add(actions.get(BackAction.class.getName()));
        add(actions.get(ForwardAction.class.getName()));
        add(new Separator());
        add(actions.get(SettingsAction.class.getName()));
        add(new Separator());
        add(actions.get(QuitAction.class.getName()));
    }
}
