/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.XmlDataSetWriter;
import org.dbunit.dataset.xml.XmlProducer;
import org.xml.sax.InputSource;

public class XmlDataSet
extends CachedDataSet {
    private static final String DEFAULT_ENCODING = "UTF8";

    public XmlDataSet(Reader reader) throws DataSetException {
        super(new XmlProducer(new InputSource(reader)));
    }

    public XmlDataSet(InputStream in) throws DataSetException {
        super(new XmlProducer(new InputSource(in)));
    }

    public static void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        OutputStreamWriter writer = new OutputStreamWriter(out, DEFAULT_ENCODING);
        XmlDataSet.write(dataSet, writer);
    }

    public static void write(IDataSet dataSet, Writer writer) throws IOException, DataSetException {
        XmlDataSet.write(dataSet, writer, null);
    }

    public static void write(IDataSet dataSet, Writer writer, String encoding) throws IOException, DataSetException {
        XmlDataSetWriter datasetWriter = new XmlDataSetWriter(writer, encoding);
        datasetWriter.write(dataSet);
    }
}

