/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.operation.DatabaseOperation;

public abstract class AbstractOperation
extends DatabaseOperation {
    protected String getQualifiedName(String prefix, String name, IDatabaseConnection connection) {
        String escapePattern = (String)connection.getConfig().getProperty("http://www.dbunit.org/properties/escapePattern");
        return DataSetUtils.getQualifiedName(prefix, name, escapePattern);
    }

    static ITableMetaData getOperationMetaData(IDatabaseConnection connection, ITableMetaData metaData) throws DatabaseUnitException, SQLException {
        IDataSet databaseDataSet = connection.createDataSet();
        String tableName = metaData.getTableName();
        ITableMetaData databaseMetaData = databaseDataSet.getTableMetaData(tableName);
        Column[] databaseColumns = databaseMetaData.getColumns();
        Column[] columns = metaData.getColumns();
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (int j = 0; j < columns.length; ++j) {
            String columnName = columns[j].getColumnName();
            Column column = DataSetUtils.getColumn(columnName, databaseColumns);
            if (column == null) {
                throw new NoSuchColumnException(tableName + "." + columnName);
            }
            columnList.add(column);
        }
        return new DefaultTableMetaData(databaseMetaData.getTableName(), columnList.toArray(new Column[0]), databaseMetaData.getPrimaryKeys());
    }
}

