/*
 * Decompiled with CFR 0.152.
 */
package com.babukuma.util.dbunit;

import com.babukuma.util.dbunit.AbstractDataCreator;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.ext.oracle.OracleConnection;
import org.dbunit.ext.oracle.OracleDataTypeFactory;

public class OracleDataCreator
extends AbstractDataCreator {
    public OracleDataCreator(String classLocation, String jdbcDriver, String url, String userID, String password, String schema) {
        super(classLocation, jdbcDriver, url, userID, password, schema);
    }

    protected IDatabaseConnection getConnection() {
        OracleConnection connection = null;
        try {
            File path = new File(this.getClassLocation());
            URL[] urls = new URL[]{path.toURL()};
            URLClassLoader cl = new URLClassLoader(urls);
            Driver driver = (Driver)cl.loadClass(this.getJdbcDriver()).newInstance();
            Properties prop = new Properties();
            prop.put("user", this.getUserID());
            prop.put("password", this.getPassword());
            Connection jdbcConnection = driver.connect(this.getUrl(), prop);
            connection = new OracleConnection(jdbcConnection, this.getSchema());
            DatabaseConfig config = connection.getConfig();
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", new OracleDataTypeFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return connection;
    }
}

