/*
 * Decompiled with CFR 0.152.
 */
package com.babukuma.util.dbunit;

import com.babukuma.util.dbunit.AbstractDataCreator;
import com.babukuma.util.dbunit.DB2DataCreator;
import com.babukuma.util.dbunit.HSQLDBDataCreator;
import com.babukuma.util.dbunit.MSSQLDataCreator;
import com.babukuma.util.dbunit.MySQLDataCreator;
import com.babukuma.util.dbunit.OracleDataCreator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TestXmlCreator
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JComboBox jcmbDBType = null;
    private JTextField jtxfDriver = null;
    private JTextField jtxfLocation = null;
    private JTextField jtxfURL = null;
    private JTextField jtxfUserID = null;
    private JPasswordField jpwfPassword = null;
    private JTextField jtxfSchema = null;
    private JTextField jtxfResultName = null;
    private JTextField jtxfFile = null;
    private JRadioButton[] jrdoScope = null;
    private JButton jbtnLocation = null;
    private JButton jbtnFile = null;
    private JButton jbtnReset = null;
    private JButton jbtnCreate = null;
    private JTextArea jtxaQuery = null;
    private final String[] dbType = new String[]{"Oracle", "MySQL", "MS-SQL", "DB2", "HSQLDB"};

    private JPanel getJpnlTop() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.setRows(7);
        JPanel jpnlTop = new JPanel();
        jpnlTop.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "DB Information", 0, 0, null, null));
        jpnlTop.setLayout(gridLayout1);
        jpnlTop.add((Component)this.getJpnlDBType(), null);
        jpnlTop.add((Component)this.getJpnlDriver(), null);
        jpnlTop.add((Component)this.getJpnlLocation(), null);
        jpnlTop.add((Component)this.getJpnlURL(), null);
        jpnlTop.add((Component)this.getJpnlUserID(), null);
        jpnlTop.add((Component)this.getJpnlPassword(), null);
        jpnlTop.add((Component)this.getJpnlSchema(), null);
        return jpnlTop;
    }

    private JPanel getJpnlDown() {
        JLabel jlblQuery = new JLabel();
        jlblQuery.setText("Query");
        JPanel jpnlDown = new JPanel();
        jpnlDown.setLayout(new BorderLayout());
        jpnlDown.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Create Data Infomation", 0, 0, null, null));
        jpnlDown.add((Component)this.getJpnlScope(), "North");
        jpnlDown.add((Component)this.getJpnlSouth(), "South");
        jpnlDown.add((Component)jlblQuery, "West");
        jpnlDown.add((Component)this.getJscpQuery(), "Center");
        return jpnlDown;
    }

    private JPanel getJpnlDBType() {
        JLabel jlblDBType = new JLabel();
        jlblDBType.setText("DB Type");
        jlblDBType.setHorizontalAlignment(4);
        jlblDBType.setToolTipText("DB Type");
        jlblDBType.setPreferredSize(new Dimension(100, 18));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        JPanel jpnlDBType = new JPanel();
        jpnlDBType.setLayout(flowLayout);
        jpnlDBType.add((Component)jlblDBType, null);
        this.jcmbDBType = new JComboBox();
        int i = 0;
        while (i < this.dbType.length) {
            this.jcmbDBType.addItem(this.dbType[i]);
            ++i;
        }
        jpnlDBType.add((Component)this.jcmbDBType, null);
        return jpnlDBType;
    }

    private JPanel getJpnlDriver() {
        JLabel jlblDriver = new JLabel();
        jlblDriver.setText("JDBC Driver");
        jlblDriver.setPreferredSize(new Dimension(100, 18));
        jlblDriver.setToolTipText("JDBC Driver Class");
        jlblDriver.setHorizontalAlignment(4);
        FlowLayout flowLayout1 = new FlowLayout();
        flowLayout1.setAlignment(0);
        JPanel jpnlDriver = new JPanel();
        jpnlDriver.setLayout(flowLayout1);
        jpnlDriver.add((Component)jlblDriver, null);
        this.jtxfDriver = new JTextField();
        this.jtxfDriver.setPreferredSize(new Dimension(250, 22));
        this.jtxfDriver.setText("oracle.jdbc.driver.OracleDriver");
        jpnlDriver.add((Component)this.jtxfDriver, null);
        return jpnlDriver;
    }

    private JPanel getJpnlLocation() {
        JLabel jlblLocation = new JLabel();
        jlblLocation.setText("Class location");
        jlblLocation.setPreferredSize(new Dimension(100, 18));
        jlblLocation.setToolTipText("Class location");
        jlblLocation.setHorizontalAlignment(4);
        FlowLayout flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(0);
        JPanel jpnlLocation = new JPanel();
        jpnlLocation.setLayout(flowLayout2);
        jpnlLocation.add((Component)jlblLocation, null);
        this.jtxfLocation = new JTextField();
        this.jtxfLocation.setPreferredSize(new Dimension(200, 22));
        jpnlLocation.add((Component)this.jtxfLocation, null);
        this.jbtnLocation = new JButton();
        this.jbtnLocation.setText("File");
        this.jbtnLocation.addActionListener(this);
        jpnlLocation.add((Component)this.jbtnLocation, null);
        return jpnlLocation;
    }

    private JPanel getJpnlURL() {
        JLabel jlblURL = new JLabel();
        jlblURL.setText("Connection URL");
        jlblURL.setPreferredSize(new Dimension(100, 18));
        jlblURL.setToolTipText("Connection URL");
        jlblURL.setHorizontalAlignment(4);
        FlowLayout flowLayout3 = new FlowLayout();
        flowLayout3.setAlignment(0);
        JPanel jpnlURL = new JPanel();
        jpnlURL.setLayout(flowLayout3);
        jpnlURL.add((Component)jlblURL, null);
        this.jtxfURL = new JTextField();
        this.jtxfURL.setPreferredSize(new Dimension(250, 22));
        this.jtxfURL.setText("jdbc:oracle:thin:@ct-java:1521:orcl");
        jpnlURL.add((Component)this.jtxfURL, null);
        return jpnlURL;
    }

    private JPanel getJpnlUserID() {
        JLabel jlblUserID = new JLabel();
        jlblUserID.setText("User ID");
        jlblUserID.setPreferredSize(new Dimension(100, 18));
        jlblUserID.setToolTipText("User ID");
        jlblUserID.setHorizontalAlignment(4);
        FlowLayout flowLayout4 = new FlowLayout();
        flowLayout4.setAlignment(0);
        JPanel jpnlUserID = new JPanel();
        jpnlUserID.setLayout(flowLayout4);
        jpnlUserID.add((Component)jlblUserID, null);
        this.jtxfUserID = new JTextField();
        this.jtxfUserID.setPreferredSize(new Dimension(100, 22));
        this.jtxfUserID.setText("eco");
        jpnlUserID.add((Component)this.jtxfUserID, null);
        return jpnlUserID;
    }

    private JPanel getJpnlPassword() {
        JLabel jlblPassword = new JLabel();
        jlblPassword.setText("Password");
        jlblPassword.setPreferredSize(new Dimension(100, 18));
        jlblPassword.setToolTipText("Password");
        jlblPassword.setHorizontalAlignment(4);
        FlowLayout flowLayout5 = new FlowLayout();
        flowLayout5.setAlignment(0);
        JPanel jpnlPassword = new JPanel();
        jpnlPassword.setLayout(flowLayout5);
        jpnlPassword.add((Component)jlblPassword, null);
        this.jpwfPassword = new JPasswordField();
        this.jpwfPassword.setPreferredSize(new Dimension(100, 22));
        this.jpwfPassword.setText("eco");
        jpnlPassword.add((Component)this.jpwfPassword, null);
        return jpnlPassword;
    }

    private JPanel getJpnlSchema() {
        JLabel jlblSchema = new JLabel();
        jlblSchema.setText("Schema");
        jlblSchema.setPreferredSize(new Dimension(100, 18));
        jlblSchema.setToolTipText("Schema");
        jlblSchema.setHorizontalAlignment(4);
        FlowLayout flowLayout6 = new FlowLayout();
        flowLayout6.setAlignment(0);
        JPanel jpnlSchema = new JPanel();
        jpnlSchema.setLayout(flowLayout6);
        jpnlSchema.add((Component)jlblSchema, null);
        this.jtxfSchema = new JTextField();
        this.jtxfSchema.setPreferredSize(new Dimension(150, 22));
        this.jtxfSchema.setText("ECO");
        jpnlSchema.add((Component)this.jtxfSchema, null);
        return jpnlSchema;
    }

    private JPanel getJpnlScope() {
        FlowLayout flowLayout7 = new FlowLayout();
        flowLayout7.setAlignment(0);
        JPanel jpnlScope = new JPanel();
        jpnlScope.setLayout(flowLayout7);
        this.jrdoScope = new JRadioButton[2];
        this.jrdoScope[0] = new JRadioButton();
        this.jrdoScope[0].setText("SELECT");
        this.jrdoScope[0].addActionListener(this);
        this.jrdoScope[1] = new JRadioButton();
        this.jrdoScope[1].setText("ALL TABLE");
        this.jrdoScope[1].addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.jrdoScope[0]);
        group.add(this.jrdoScope[1]);
        this.jrdoScope[0].setSelected(true);
        jpnlScope.add((Component)this.jrdoScope[0], null);
        jpnlScope.add((Component)this.jrdoScope[1], null);
        return jpnlScope;
    }

    private JPanel getJpnlSouth() {
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.setRows(3);
        JPanel jpnlSouth = new JPanel();
        jpnlSouth.setLayout(gridLayout2);
        jpnlSouth.add((Component)this.getJpnlResultName(), null);
        jpnlSouth.add((Component)this.getJpnlFile(), null);
        jpnlSouth.add((Component)this.getJpnlBtn(), null);
        return jpnlSouth;
    }

    private JPanel getJpnlResultName() {
        JLabel jlblResultName = new JLabel();
        jlblResultName.setText("Result Name");
        jlblResultName.setPreferredSize(new Dimension(100, 18));
        jlblResultName.setToolTipText("Result Name");
        jlblResultName.setHorizontalAlignment(4);
        FlowLayout flowLayout8 = new FlowLayout();
        flowLayout8.setAlignment(0);
        JPanel jpnlResultName = new JPanel();
        jpnlResultName.setLayout(flowLayout8);
        jpnlResultName.add((Component)jlblResultName, null);
        this.jtxfResultName = new JTextField();
        this.jtxfResultName.setPreferredSize(new Dimension(250, 22));
        this.jtxfResultName.setText("TEST_TABLE");
        jpnlResultName.add((Component)this.jtxfResultName, null);
        return jpnlResultName;
    }

    private JPanel getJpnlFile() {
        JLabel jlblFile = new JLabel();
        jlblFile.setText("Save File");
        jlblFile.setPreferredSize(new Dimension(100, 18));
        jlblFile.setToolTipText("Save XML File Path");
        jlblFile.setHorizontalAlignment(4);
        FlowLayout flowLayout9 = new FlowLayout();
        flowLayout9.setAlignment(0);
        JPanel jpnlFile = new JPanel();
        jpnlFile.setLayout(flowLayout9);
        jpnlFile.add((Component)jlblFile, null);
        this.jtxfFile = new JTextField();
        this.jtxfFile.setPreferredSize(new Dimension(200, 22));
        jpnlFile.add((Component)this.jtxfFile, null);
        this.jbtnFile = new JButton();
        this.jbtnFile.setText("File");
        this.jbtnFile.addActionListener(this);
        jpnlFile.add((Component)this.jbtnFile, null);
        return jpnlFile;
    }

    private JPanel getJpnlBtn() {
        FlowLayout fwlBtn = new FlowLayout();
        fwlBtn.setAlignment(2);
        JPanel jpnlBtn = new JPanel();
        jpnlBtn.setLayout(fwlBtn);
        this.jbtnReset = new JButton();
        this.jbtnReset.setText("Reset");
        this.jbtnReset.setToolTipText("Reset");
        this.jbtnReset.addActionListener(this);
        jpnlBtn.add((Component)this.jbtnReset, null);
        this.jbtnCreate = new JButton();
        this.jbtnCreate.setText("Create");
        this.jbtnCreate.setToolTipText("Test XML Create..");
        this.jbtnCreate.addActionListener(this);
        jpnlBtn.add((Component)this.jbtnCreate, null);
        return jpnlBtn;
    }

    private JScrollPane getJscpQuery() {
        JScrollPane jscpQuery = new JScrollPane();
        this.jtxaQuery = new JTextArea();
        jscpQuery.setViewportView(this.jtxaQuery);
        return jscpQuery;
    }

    public static void main(String[] args) {
        new TestXmlCreator();
    }

    public TestXmlCreator() {
        this.initialize();
        this.setVisible(true);
    }

    private void initialize() {
        this.setSize(400, 600);
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getJcpnMain());
        this.setTitle("TextXml Creator for DBUnit");
    }

    private JPanel getJcpnMain() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(2);
        JPanel jcpnMain = new JPanel();
        jcpnMain.setLayout(gridLayout);
        jcpnMain.add((Component)this.getJpnlTop(), null);
        jcpnMain.add((Component)this.getJpnlDown(), null);
        return jcpnMain;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.jrdoScope[0] || obj == this.jrdoScope[1]) {
            this.changeScope();
        } else if (obj == this.jbtnCreate) {
            this.runCreate();
        } else if (obj == this.jbtnLocation) {
            this.setClassLocation();
        } else if (obj == this.jbtnFile) {
            this.setSaveFilePath();
        } else if (obj == this.jbtnReset) {
            this.eventReset();
        }
    }

    private void changeScope() {
        if (this.jrdoScope[0].isSelected()) {
            this.jtxaQuery.setEnabled(true);
            this.jtxfResultName.setEnabled(true);
            this.jtxaQuery.setBackground(Color.WHITE);
            this.jtxfResultName.setBackground(Color.WHITE);
        } else {
            this.jtxaQuery.setEnabled(false);
            this.jtxfResultName.setEnabled(false);
            this.jtxaQuery.setBackground(Color.LIGHT_GRAY);
            this.jtxfResultName.setBackground(Color.LIGHT_GRAY);
        }
    }

    private void eventReset() {
        this.jrdoScope[0].setSelected(true);
        this.jtxaQuery.setText("");
        this.jtxfResultName.setText("");
    }

    private void runCreate() {
        if (this.jrdoScope[0].isSelected()) {
            if (this.jtxaQuery.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Query is Empty!!", "Warning", 2);
                return;
            }
            if (this.jtxfResultName.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Result Name is Empty!!", "Warning", 2);
                return;
            }
        }
        AbstractDataCreator creator = null;
        switch (this.jcmbDBType.getSelectedIndex()) {
            case 0: {
                creator = new OracleDataCreator(this.jtxfLocation.getText(), this.jtxfDriver.getText(), this.jtxfURL.getText(), this.jtxfUserID.getText(), new String(this.jpwfPassword.getPassword()), this.jtxfSchema.getText());
                break;
            }
            case 1: {
                creator = new MySQLDataCreator(this.jtxfLocation.getText(), this.jtxfDriver.getText(), this.jtxfURL.getText(), this.jtxfUserID.getText(), new String(this.jpwfPassword.getPassword()), this.jtxfSchema.getText());
                break;
            }
            case 2: {
                creator = new MSSQLDataCreator(this.jtxfLocation.getText(), this.jtxfDriver.getText(), this.jtxfURL.getText(), this.jtxfUserID.getText(), new String(this.jpwfPassword.getPassword()), this.jtxfSchema.getText());
                break;
            }
            case 3: {
                creator = new DB2DataCreator(this.jtxfLocation.getText(), this.jtxfDriver.getText(), this.jtxfURL.getText(), this.jtxfUserID.getText(), new String(this.jpwfPassword.getPassword()), this.jtxfSchema.getText());
                break;
            }
            case 4: {
                creator = new HSQLDBDataCreator(this.jtxfLocation.getText(), this.jtxfDriver.getText(), this.jtxfURL.getText(), this.jtxfUserID.getText(), new String(this.jpwfPassword.getPassword()), this.jtxfSchema.getText());
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "Failed!!", "Warning", 2);
                return;
            }
        }
        try {
            if (creator.makeXmlData(this.jrdoScope[0].isSelected(), this.jtxaQuery.getText(), this.jtxfResultName.getText(), this.jtxfFile.getText())) {
                JOptionPane.showMessageDialog(this, "Complete!!", "Alert", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Failed!!", "Warning", 2);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }

    private void setClassLocation() {
        JFileChooser fc = new JFileChooser();
        if (fc.showSaveDialog(this) == 0) {
            this.jtxfLocation.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void setSaveFilePath() {
        JFileChooser fc = new JFileChooser();
        if (fc.showSaveDialog(this) == 0) {
            this.jtxfFile.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }
}

