package com.babukuma.util.dbunit;

import java.sql.Connection;

import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.ext.db2.Db2Connection;
import org.dbunit.ext.db2.Db2DataTypeFactory;

/**
 * DB2용 데이터 생성 클래스
 * @author BABUKUMA
 */
public class DB2DataCreator extends AbstractDataCreator {

    /**
     * @param classLocation JDBC Class Location
     * @param jdbcDriver JDBC Driver Name
     * @param url DB Connect URL
     * @param userID DB Connect User ID
     * @param password DB Connect User Password
     * @param schema 사용할 DB schema
     */
    public DB2DataCreator(String classLocation, String jdbcDriver, String url,
        String userID, String password, String schema) {
        super(classLocation, jdbcDriver, url, userID, password, schema);
    }

    /**
     * DB2용 Connection을 얻어온다.
     * @param connection Connection
     * @return IDatabaseConnection
     */
    protected IDatabaseConnection getDatabaseConnection(Connection connection) {
        IDatabaseConnection databaseConnection = null;
        try {
            databaseConnection = new Db2Connection(connection, getSchema());
            DatabaseConfig config = databaseConnection.getConfig();
            config.setProperty(DatabaseConfig.PROPERTY_DATATYPE_FACTORY,
                new Db2DataTypeFactory());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return databaseConnection;
    }

}
