/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.kldp.beat.action.AwareInjector;
import net.kldp.beat.annotation.After;
import net.kldp.beat.annotation.Beat;
import net.kldp.beat.annotation.Before;
import net.kldp.beat.annotation.BeforeResult;
import net.kldp.beat.annotation.Multipart;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.annotation.Results;
import net.kldp.beat.interceptor.AroundInterceptor;
import net.kldp.beat.interceptor.BeforeInterceptor;
import net.kldp.beat.interceptor.Interceptor;

public class InterceptorStack {
    private boolean isMultipart = false;
    private Multipart multipart;
    private List<Result> results = new ArrayList<Result>();
    private Map<Interceptor, Annotation> before = new HashMap<Interceptor, Annotation>();
    private Map<Interceptor, Annotation> after = new HashMap<Interceptor, Annotation>();
    private Method beforeMethod;
    private Method afterMethod;
    private Method resultBeforeMethod;

    public InterceptorStack(Object object, AwareInjector awareInjector) throws ServletException {
        Annotation[] annotationArray = object.getClass().getAnnotations();
        Object[] objectArray = annotationArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object3;
            Annotation annotation = objectArray[i];
            if (!this.isBeat(annotation)) continue;
            if (annotation instanceof Multipart) {
                this.isMultipart = true;
                this.multipart = (Multipart)annotation;
                continue;
            }
            if (annotation instanceof Result) {
                this.results.add((Result)annotation);
                continue;
            }
            if (annotation instanceof Results) {
                object3 = (Results)annotation;
                for (Result result : object3.value()) {
                    this.results.add(result);
                }
                continue;
            }
            object3 = annotation.annotationType().getSimpleName();
            String string = "web.interceptor." + (String)object3 + "Interceptor";
            try {
                Interceptor interceptor = (Interceptor)Class.forName(string).newInstance();
                awareInjector.injection(interceptor);
                if (interceptor instanceof AroundInterceptor) {
                    this.before.put(interceptor, annotation);
                    this.after.put(interceptor, annotation);
                    continue;
                }
                if (interceptor instanceof BeforeInterceptor) {
                    this.before.put(interceptor, annotation);
                    continue;
                }
                this.after.put(interceptor, annotation);
                continue;
            }
            catch (Exception exception) {
                throw new ServletException("Can not found Interceptor class :" + string);
            }
        }
        for (Object object3 : objectArray = object.getClass().getMethods()) {
            Before before = ((Method)object3).getAnnotation(Before.class);
            After after = ((Method)object3).getAnnotation(After.class);
            BeforeResult beforeResult = ((Method)object3).getAnnotation(BeforeResult.class);
            if (before != null && this.beforeMethod == null) {
                this.beforeMethod = object3;
                continue;
            }
            if (beforeResult != null && this.resultBeforeMethod == null) {
                this.resultBeforeMethod = object3;
                continue;
            }
            if (after == null || this.afterMethod != null) continue;
            this.afterMethod = object3;
        }
    }

    private boolean isBeat(Annotation annotation) {
        for (Annotation annotation2 : annotation.annotationType().getAnnotations()) {
            if (!(annotation2 instanceof Beat)) continue;
            return true;
        }
        return false;
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    public Multipart getMultipart() {
        return this.multipart;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public Result getResult(String string) {
        for (Result result : this.results) {
            if (!result.name().equals(string)) continue;
            return result;
        }
        return null;
    }

    public Map<Interceptor, Annotation> getBeforeInterceptors() {
        return this.before;
    }

    public Map<Interceptor, Annotation> getAfterInterceptors() {
        return this.after;
    }

    public Method getBeforeMethod() {
        return this.beforeMethod;
    }

    public Method getAfterMethod() {
        return this.afterMethod;
    }

    public Method getBeforeResultMethod() {
        return this.resultBeforeMethod;
    }
}

