/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.action.ServletDispatcher;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.config.Config;
import org.apache.commons.beanutils.PropertyUtils;

public class ServletDispatcherImpl
implements ServletDispatcher {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext context;

    public ServletDispatcherImpl(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.context = servletContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public void dispatch(String string, String string2) throws ServletException, IOException {
        if (string2.equals("include")) {
            RequestDispatcher requestDispatcher = this.context.getRequestDispatcher(string);
            requestDispatcher.include((ServletRequest)this.request, (ServletResponse)this.response);
        } else if (string2.equals("redirect")) {
            this.response.sendRedirect(string);
        } else {
            RequestDispatcher requestDispatcher = this.context.getRequestDispatcher(string);
            requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
    }

    @Override
    public void dispatch(Result result, Object object) throws ServletException, IOException {
        String string = result.type();
        if (string.equals("redirect")) {
            this.dispatch(result.value(), string);
        }
        String string2 = Config.view_path() + result.value();
        if (result.params() != null && result.params().length > 0) {
            String string3 = this.arrayToParam(result.params());
            try {
                Map map = PropertyUtils.describe((Object)object);
                map.remove("class");
                for (String string4 : map.keySet()) {
                    string3 = string3.replaceAll("\\$\\{" + string4 + "}", map.get(string4).toString());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            string2 = string2 + "?" + string3;
        }
        this.dispatch(string2, string);
    }

    private String arrayToParam(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            stringBuffer.append(string + "&");
        }
        if (stringBuffer.length() < 1) {
            return "";
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }
}

