/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.kldp.beat.annotation.After;
import net.kldp.beat.annotation.Beat;
import net.kldp.beat.annotation.Before;
import net.kldp.beat.annotation.BeforeResult;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.annotation.Results;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.AfterInterceptor;
import net.kldp.beat.interceptor.BeforeInterceptor;
import net.kldp.beat.interceptor.Interceptor;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.web.interceptor.InterceptorFactory;

public class InterceptorStack {
    private List<Result> results = new ArrayList<Result>();
    private Map<UserInterceptor, Annotation> before = new HashMap<UserInterceptor, Annotation>();
    private Map<UserInterceptor, Annotation> after = new HashMap<UserInterceptor, Annotation>();
    private Map<SystemInterceptor, Annotation> system = new HashMap<SystemInterceptor, Annotation>();
    private Method beforeMethod;
    private Method afterMethod;
    private Method resultBeforeMethod;

    public InterceptorStack(Object object) throws ServletException {
        for (Annotation annotation : InterceptorStack.getAnnotations(object)) {
            this.classifyAnnotations(annotation);
        }
        this.classifyMethods(object.getClass().getMethods());
    }

    private void classifyMethods(Method[] methodArray) {
        for (Method method : methodArray) {
            Before before = method.getAnnotation(Before.class);
            After after = method.getAnnotation(After.class);
            BeforeResult beforeResult = method.getAnnotation(BeforeResult.class);
            if (before != null && this.beforeMethod == null) {
                this.beforeMethod = method;
                continue;
            }
            if (beforeResult != null && this.resultBeforeMethod == null) {
                this.resultBeforeMethod = method;
                continue;
            }
            if (after == null || this.afterMethod != null) continue;
            this.afterMethod = method;
        }
    }

    private void classifyAnnotations(Annotation annotation) {
        if (annotation instanceof Result) {
            this.results.add((Result)annotation);
        } else if (annotation instanceof Results) {
            Results results = (Results)annotation;
            for (Result result : results.value()) {
                this.results.add(result);
            }
        } else {
            this.classifyInterceptors(annotation);
        }
    }

    private void classifyInterceptors(Annotation annotation) {
        try {
            Interceptor interceptor = InterceptorFactory.getInterceptor((Annotation)annotation);
            if (interceptor instanceof SystemInterceptor) {
                this.system.put((SystemInterceptor)interceptor, annotation);
            } else {
                if (interceptor instanceof BeforeInterceptor) {
                    this.before.put((UserInterceptor)interceptor, annotation);
                }
                if (interceptor instanceof AfterInterceptor) {
                    this.after.put((UserInterceptor)interceptor, annotation);
                }
            }
        }
        catch (InterceptorException interceptorException) {
            interceptorException.printStackTrace();
        }
    }

    public static ArrayList<Annotation> getAnnotations(Object object) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Annotation object2 : object.getClass().getAnnotations()) {
            if (!InterceptorStack.isBeat(object2)) continue;
            arrayList.add(object2);
        }
        for (Class<?> clazz : object.getClass().getInterfaces()) {
            for (Annotation annotation : clazz.getAnnotations()) {
                arrayList.add(annotation);
            }
        }
        return arrayList;
    }

    public static boolean isBeat(Annotation annotation) {
        for (Annotation annotation2 : annotation.annotationType().getAnnotations()) {
            if (!(annotation2 instanceof Beat)) continue;
            return true;
        }
        return false;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public boolean hasResults() {
        return this.results.size() > 0;
    }

    public Result getResult(String string) {
        for (Result result : this.results) {
            if (!result.name().equals(string)) continue;
            return result;
        }
        return null;
    }

    public Map<SystemInterceptor, Annotation> getSystemInterceptors() {
        return this.system;
    }

    public Map<UserInterceptor, Annotation> getBeforeInterceptors() {
        return this.before;
    }

    public Map<UserInterceptor, Annotation> getAfterInterceptors() {
        return this.after;
    }

    public Method getBeforeMethod() {
        return this.beforeMethod;
    }

    public Method getAfterMethod() {
        return this.afterMethod;
    }

    public Method getBeforeResultMethod() {
        return this.resultBeforeMethod;
    }
}

