/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.kldp.beat.upload.FormFile;
import org.apache.commons.fileupload.FileItem;

public class FormFileImpl
extends File
implements FormFile {
    private static final long serialVersionUID = 2619755555221510054L;
    private File file;
    private String fieldName;
    private String contentType;

    public FormFileImpl(File file) {
        super(file.getAbsolutePath());
        this.file = file;
    }

    public FormFileImpl(FileItem fileItem) {
        super("sdfdsfdsf");
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    @Override
    public void copyFile(File file) throws IOException {
        if (file.exists()) {
            file.createNewFile();
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFileName() {
        return this.file == null ? null : this.file.getName();
    }

    @Override
    public int getFileSize() {
        return (int)(this.file == null ? 0L : this.file.length());
    }

    @Override
    public String getFileSuffix() {
        String string = this.getFileName();
        if (string == null) {
            return null;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (string.lastIndexOf(46) > 0) {
            return string2;
        }
        return "";
    }
}

