package net.kldp.beat.action;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.annotation.Result;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.web.interceptor.InterceptorFactory;

public class ActionService {
	private ServletDispatcherImpl dispatcher;
	private ActionContext context;

	public ActionService(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
		this.dispatcher = new ServletDispatcherImpl(context, request, response);
		this.context = new ActionContext(request, response, context);
	}

	public void doService(Object action, ActionMapper mapper) throws ServletException {
		// 인터셉터 분류
		InterceptorStack stack = new InterceptorStack(action);
		
		// 시스템 인터셉터 처리
		executeSystemInterceptor(action, stack.getSystemInterceptors());

		// 액션으로 파라미터 주입
		PropertyCopy.mapToBean(context.getParameterMap(), action);
		
		// Validation 처리
		if (!validate(action, stack.getResult("input")))
			return;
		
		// 사용자 인터셉터 초기화
		initInterceptors(stack);
		
		// 전처리 인터셉터 처리
		if (!executeInterceptors(action, stack.getBeforeInterceptors())) {
			executeInterceptors(action, stack.getAfterInterceptors());
			return;
		}
		
		// 전처리 메서드 실행
		invokeMethod(action, stack.getBeforeMethod());
		
		// execute 메서드 실행
		Result result = stack.getResult(executeAction(action));
		if (result == null) {
			if (!stack.hasResults())
				result = mapper.getDefaultResult();
			else
				throw new ServletException("can not found Result");
		}
		
		// 전처리 Result 메서드 실행
		invokeMethod(action, stack.getBeforeResultMethod());
		
		System.out.println("Bean injection");
		// Request로 빈 주입
		PropertyCopy.beanToMap(action, context.getRequestMap());
		
		// View로 디스패치
		dispatchView(result, action);
		
		// 후처리 메서드 실행
		invokeMethod(action, stack.getAfterMethod());
		
		// 후처리 인터셉터 실행
		executeInterceptors(action, stack.getAfterInterceptors());
	}

	private void initInterceptors(InterceptorStack stack) throws InterceptorException {
		Map<UserInterceptor, Annotation> before = stack.getBeforeInterceptors();
		for (UserInterceptor interceptor : before.keySet()) {
			ArrayList<Annotation> annotations = InterceptorStack.getAnnotations(interceptor);
			for (Annotation annotation : annotations) {
				InterceptorFactory.intecept(interceptor, context, annotation);
			}
		}
		Map<UserInterceptor, Annotation> after = stack.getAfterInterceptors();
		for (UserInterceptor interceptor : after.keySet()) {
			if (!before.containsKey(interceptor)) {
				ArrayList<Annotation> annotations = InterceptorStack.getAnnotations(interceptor);
				for (Annotation annotation : annotations) {
					InterceptorFactory.intecept(interceptor, context, annotation);
				}
			}
		}
	}

	private void dispatchView(Result result, Object action) throws ServletException {
		try {
			dispatcher.dispatch(result, action);
		} catch (IOException e) {
			throw new ServletException(e);
		}
	}

	private boolean validate(Object action, Result input) throws ServletException {
		if (context.getErrorsMap().size() > 0) {
			if (input == null) {
				throw new ServletException("can not found Result annotation for input.");
			}
			PropertyCopy.beanToMap(action, context.getRequestMap());
			System.out.println("name" + context.getRequestMap().get("name"));
			try {
				dispatcher.dispatch(input, action);
			} catch (IOException e) {
				throw new ServletException(e);
			}
			return false;
		} else {
			return true;
		}
	}

	private void invokeMethod(Object action, Method method) throws ServletException {
		if (method != null) {
			try {
				method.invoke(action, (Object) null);
			} catch (Exception e) {
				throw new ServletException("Can not execute Method");
			}
		}
	}

	private void executeSystemInterceptor(Object action, Map<SystemInterceptor, Annotation> systemInterceptors)
			throws InterceptorException {
		InterceptorFactory.intecept(action, systemInterceptors, context);
	}

	private boolean executeInterceptors(Object action, Map<UserInterceptor, Annotation> interceptors)
			throws ServletException {
		boolean result = true;
		for (UserInterceptor interceptor : interceptors.keySet()) {
			// Interceptor가 true일경우에만 Action과 View 처리
			if (!interceptor.intercept(action, interceptors.get(interceptor)))
				result = false;
		}
		return result;
	}

	private String executeAction(Object action) throws ServletException {
		try {
			Method method = action.getClass().getMethod("execute");
			return (String) method.invoke(action);
		} catch (Exception e) {
			throw new ServletException(e);
		}
	}
}