package net.kldp.beat.map;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

public class ParameterMap extends AbstractMap {

	private HttpServletRequest request;
	private Map<String, Object> map = new HashMap<String, Object>();
	private Map<String, Object> remove = new HashMap<String, Object>();

	public ParameterMap(HttpServletRequest request) {
		this.request = request;
	}

	@Override
	Object getAttribute(String key) {
		if(remove.containsKey(key))
			return null;

		if (!map.containsKey(key)) {
			String value = request.getParameter(key);
			map.put(key, value);
		}
		return map.get(key);
	}

	@SuppressWarnings("unchecked")
	@Override
	Enumeration<String> getAttributeNames() {
		return request.getParameterNames();
	}

	@Override
	void removeAttribute(String key) {
		remove.put(key, map.remove(key));
	}

	@Override
	void setAttribute(String key, Object value) {
		map.put(key, value);
	}
}